/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractIndexCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.RenameIndexCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.storage.RenameIndexEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class RenameIndexCommand
extends AbstractIndexCommand {
    private final String newIndexName;
    private final boolean ifIndexExists;

    public static RenameIndexCommandBuilder builder() {
        return new Builder();
    }

    private RenameIndexCommand(String schemaName, String indexName, boolean ifIndexExists, String newIndexName) throws CatalogValidationException {
        super(schemaName, indexName);
        CatalogParamsValidationUtils.validateIdentifier(newIndexName, "New index name");
        this.newIndexName = newIndexName;
        this.ifIndexExists = ifIndexExists;
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogIndexDescriptor index = CatalogUtils.indexOrThrow(schema, this.indexName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.newIndexName);
        return List.of(new RenameIndexEntry(index.id(), this.newIndexName));
    }

    public boolean ifIndexExists() {
        return this.ifIndexExists;
    }

    private static class Builder
    implements RenameIndexCommandBuilder {
        private String schemaName;
        private String indexName;
        private boolean ifExists;
        private String newIndexName;

        private Builder() {
        }

        @Override
        public RenameIndexCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public RenameIndexCommandBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Override
        public RenameIndexCommandBuilder ifIndexExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public RenameIndexCommandBuilder newIndexName(String newIndexName) {
            this.newIndexName = newIndexName;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new RenameIndexCommand(this.schemaName, this.indexName, this.ifExists, this.newIndexName);
        }
    }
}

