/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import com.google.auto.service.AutoService;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineConfiguration;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineExtensionConfiguration;
import org.jetbrains.annotations.Nullable;

@AutoService(value={DataStorageModule.class})
public class VolatilePageMemoryDataStorageModule
implements DataStorageModule {
    public String name() {
        return "aimem";
    }

    public StorageEngine createEngine(String igniteInstanceName, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, LogSyncer logSyncer, HybridClock clock, ScheduledExecutorService commonScheduler) throws StorageException {
        StorageConfiguration storageConfig = ((StorageExtensionConfiguration)configRegistry.getConfiguration(StorageExtensionConfiguration.KEY)).storage();
        VolatilePageMemoryStorageEngineConfiguration engineConfig = ((VolatilePageMemoryStorageEngineExtensionConfiguration)storageConfig.engines()).aimem();
        assert (engineConfig != null);
        PageIoRegistry ioRegistry = new PageIoRegistry();
        ioRegistry.loadFromServiceLoader();
        return new VolatilePageMemoryStorageEngine(igniteInstanceName, engineConfig, storageConfig, ioRegistry, clock);
    }
}

