/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rule.ImmutableSortExchangeTransposeRule;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.immutables.value.Value;

@Value.Enclosing
public class SortExchangeTransposeRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.INSTANCE.toRule();

    private SortExchangeTransposeRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public boolean matches(RelOptRuleCall call) {
        IgniteExchange exchange = (IgniteExchange)call.rel(1);
        return SortExchangeTransposeRule.hashAlike(TraitUtils.distribution(exchange.getInput())) && exchange.distribution() == IgniteDistributions.single() && call.rel(0).isEnforcer();
    }

    private static boolean hashAlike(IgniteDistribution distribution) {
        return distribution.getType() == RelDistribution.Type.HASH_DISTRIBUTED || distribution.getType() == RelDistribution.Type.RANDOM_DISTRIBUTED;
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteSort sort = (IgniteSort)call.rel(0);
        assert (sort.isEnforcer()) : "Non enforcer sort can not be pushed under Exchanger";
        IgniteExchange exchange = (IgniteExchange)call.rel(1);
        RelOptCluster cluster = sort.getCluster();
        RelCollation collation = sort.collation();
        RelNode input = exchange.getInput();
        call.transformTo((RelNode)new IgniteExchange(cluster, exchange.getTraitSet().replace((RelTrait)collation), SortExchangeTransposeRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().replace((RelTrait)collation)), exchange.distribution()));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config INSTANCE = (Config)ImmutableSortExchangeTransposeRule.Config.of().withDescription("SortExchangeTransposeRule").withOperandSupplier(o0 -> o0.operand(IgniteSort.class).predicate(Sort::isEnforcer).oneInput(o1 -> o1.operand(IgniteExchange.class).anyInputs())).as(Config.class);

        default public SortExchangeTransposeRule toRule() {
            return new SortExchangeTransposeRule(this);
        }
    }
}

