/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.sql.ColumnType;

public class CacheKey {
    static final ColumnType[] EMPTY_CLASS_ARRAY = new ColumnType[0];
    private final int catalogVersion;
    private final String schemaName;
    private final String query;
    private final Object contextKey;
    private final Object[] paramTypes;
    private int hashCode = 0;

    public CacheKey(int catalogVersion, String schemaName, String query, Object contextKey, ColumnType[] paramTypes) {
        this.catalogVersion = catalogVersion;
        this.schemaName = schemaName;
        this.query = query;
        this.contextKey = contextKey;
        this.paramTypes = paramTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        if (this.catalogVersion != cacheKey.catalogVersion) {
            return false;
        }
        if (!this.schemaName.equals(cacheKey.schemaName)) {
            return false;
        }
        if (!this.query.equals(cacheKey.query)) {
            return false;
        }
        if (!Objects.equals(this.contextKey, cacheKey.contextKey)) {
            return false;
        }
        return Arrays.deepEquals(this.paramTypes, cacheKey.paramTypes);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.catalogVersion;
            result = 31 * result + this.schemaName.hashCode();
            result = 31 * result + this.query.hashCode();
            result = 31 * result + (this.contextKey != null ? this.contextKey.hashCode() : 0);
            this.hashCode = result = 31 * result + Arrays.deepHashCode(this.paramTypes);
        }
        return this.hashCode;
    }
}

