/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite.internal.sql.engine.exec.fsm.Result;
import org.apache.ignite.internal.sql.engine.exec.fsm.Transition;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.ExceptionUtils;

class Program<ResultT> {
    private static final IgniteLogger LOG = Loggers.forClass(Program.class);
    private final String name;
    private final Map<ExecutionPhase, Transition> transitions;
    private final Predicate<ExecutionPhase> terminalPhase;
    private final Function<Query, ResultT> result;
    private final BiPredicate<Query, Throwable> errorHandler;

    Program(String name, List<Transition> transitions, Predicate<ExecutionPhase> terminalPhase, Function<Query, ResultT> result, BiPredicate<Query, Throwable> errorHandler) {
        this.name = name;
        this.transitions = transitions.stream().collect(Collectors.toMap(Transition::from, Function.identity()));
        this.terminalPhase = terminalPhase;
        this.result = result;
        this.errorHandler = errorHandler;
    }

    CompletableFuture<ResultT> run(Query query) {
        do {
            Result result;
            ExecutionPhase phase = query.currentPhase();
            try {
                result = phase.evaluate(query);
            }
            catch (Throwable th) {
                try {
                    if (this.errorHandler.test(query, th)) {
                        continue;
                    }
                }
                catch (AssertionError | Exception ex2) {
                    LOG.warn("Exception in error handler [queryId={}]", (Throwable)ex2, new Object[]{query.id});
                    query.onError(th);
                }
                return Commons.cast(query.resultHolder);
            }
            if (result.status() != Result.Status.WAITING_FOR_COMPLETION) continue;
            CompletableFuture<Void> awaitFuture = result.await();
            assert (awaitFuture != null);
            if (awaitFuture.isDone() && !awaitFuture.isCompletedExceptionally()) continue;
            awaitFuture.whenComplete((ignored, ex) -> {
                if (ex != null) {
                    ex = ExceptionUtils.unwrapCause((Throwable)ex);
                    try {
                        if (this.errorHandler.test(query, (Throwable)ex)) {
                            query.executor.execute(() -> this.run(query));
                        }
                    }
                    catch (AssertionError | Exception ex0) {
                        LOG.warn("Exception in error handler [queryId={}]", (Throwable)ex0, new Object[]{query.id});
                        query.onError((Throwable)ex);
                    }
                    return;
                }
                query.executor.execute(() -> {
                    if (this.advanceQuery(query)) {
                        this.run(query);
                    }
                });
            });
            break;
        } while (this.advanceQuery(query));
        return Commons.cast(query.resultHolder);
    }

    private boolean advanceQuery(Query query) {
        ExecutionPhase phase = query.currentPhase();
        Transition transition = this.transitions.get((Object)phase);
        assert (transition != null) : "Transition not found in program \"" + this.name + "\" for phase " + String.valueOf((Object)phase);
        transition.move(query);
        if (this.terminalPhase.test(query.currentPhase())) {
            ResultT result = this.result.apply(query);
            query.resultHolder.complete(result);
            return false;
        }
        return true;
    }
}

