/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.lang.ErrorGroups;

public class ErrorGroup {
    private final String groupName;
    private final short groupCode;
    private final String errorPrefix;
    private final Set<Short> codes = new HashSet<Short>();

    ErrorGroup(String errorPrefix, String groupName, short groupCode) {
        this.groupName = groupName;
        this.groupCode = groupCode;
        this.errorPrefix = errorPrefix;
    }

    public String errorPrefix() {
        return this.errorPrefix;
    }

    public String name() {
        return this.groupName;
    }

    public short groupCode() {
        return this.groupCode;
    }

    public int registerErrorCode(short errorCode) {
        if (this.codes.contains(errorCode)) {
            throw new IllegalArgumentException("Error code already registered [errorCode=" + errorCode + ", group=" + this.name() + "]");
        }
        this.codes.add(errorCode);
        return this.groupCode() << 16 | errorCode & 0xFFFF;
    }

    public static short extractErrorCode(int code) {
        return (short)(code & 0xFFFF);
    }

    public static String errorMessage(UUID traceId, int code, String message) {
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode(code);
        return ErrorGroup.errorMessage(errorGroup.errorPrefix(), traceId, errorGroup.name(), code, message);
    }

    static String errorMessage(String errorPrefix, UUID traceId, String groupName, int code, String message) {
        return errorPrefix + "-" + groupName + "-" + Short.toUnsignedInt(ErrorGroup.extractErrorCode(code)) + " TraceId:" + String.valueOf(traceId) + (String)(message != null && !message.isEmpty() ? " " + message : "");
    }

    public String toString() {
        return "ErrorGroup [errorPrefix=" + this.errorPrefix + ", name=" + this.name() + ", groupCode=" + this.groupCode() + "]";
    }
}

