/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgnitePlanner;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlanningContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.ValidationResult;
import org.apache.ignite.internal.processors.query.calcite.schema.ViewTableImpl;
import org.apache.ignite.internal.util.typedef.F;

public class ViewTableMacroImpl
implements TableMacro {
    private static final ThreadLocal<Set<ViewTableMacroImpl>> stack = ThreadLocal.withInitial(HashSet::new);
    private final String viewSql;
    private final SchemaPlus schema;

    public ViewTableMacroImpl(String viewSql, SchemaPlus schema) {
        this.viewSql = viewSql;
        this.schema = schema;
    }

    public TranslatableTable apply(List<?> arguments) {
        if (!stack.get().add(this)) {
            throw new IgniteSQLException("Recursive views are not supported: " + this.viewSql);
        }
        try {
            IgnitePlanner planner = PlanningContext.builder().parentContext(BaseQueryContext.builder().defaultSchema(this.schema).build()).build().planner();
            SqlNode sqlNode = planner.parse(this.viewSql);
            ValidationResult res = planner.validateAndGetTypeMetadata(sqlNode);
            HashMap<String, List<String>> origins = new HashMap<String, List<String>>();
            if (!F.isEmpty(res.origins())) {
                for (int i = 0; i < res.origins().size(); ++i) {
                    List<String> origin = res.origins().get(i);
                    if (F.isEmpty(origin)) continue;
                    origins.put(((RelDataTypeField)res.dataType().getFieldList().get(i)).getName(), origin);
                }
            }
            ViewTableImpl viewTableImpl = new ViewTableImpl(planner.getTypeFactory().getJavaClass(res.dataType()), RelDataTypeImpl.proto((RelDataType)res.dataType()), this.viewSql, CalciteSchema.from((SchemaPlus)this.schema).path(null), origins);
            return viewTableImpl;
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException("Failed to validate SQL view query. " + e.getMessage(), 1001, (Throwable)e);
        }
        finally {
            stack.get().remove(this);
        }
    }

    public List<FunctionParameter> getParameters() {
        return Collections.emptyList();
    }
}

