/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsRepository;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnLocalDataView;
import org.apache.ignite.internal.util.typedef.F;

public class ColumnLocalDataViewSupplier {
    private final IgniteStatisticsRepository repo;

    public ColumnLocalDataViewSupplier(IgniteStatisticsRepository repository) {
        this.repo = repository;
    }

    public Iterable<StatisticsColumnLocalDataView> columnLocalStatisticsViewSupplier(Map<String, Object> filter) {
        Map<StatisticsKey, ObjectStatisticsImpl> locStatsMap;
        String type = (String)filter.get("type");
        if (type != null && !"TABLE".equalsIgnoreCase(type)) {
            return Collections.emptyList();
        }
        String schema = (String)filter.get("schema");
        String name = (String)filter.get("name");
        String column = (String)filter.get("column");
        if (!F.isEmpty(schema) && !F.isEmpty(name)) {
            StatisticsKey key = new StatisticsKey(schema, name);
            ObjectStatisticsImpl objLocStat = this.repo.getLocalStatistics(key, null);
            if (objLocStat == null) {
                return Collections.emptyList();
            }
            locStatsMap = Collections.singletonMap(key, objLocStat);
        } else {
            locStatsMap = this.repo.localStatisticsMap().entrySet().stream().filter(e -> F.isEmpty(schema) || schema.equals(((StatisticsKey)e.getKey()).schema())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((IgniteStatisticsRepository.VersionedStatistics)e.getValue()).statistics()));
        }
        ArrayList<StatisticsColumnLocalDataView> res = new ArrayList<StatisticsColumnLocalDataView>();
        for (Map.Entry<StatisticsKey, ObjectStatisticsImpl> locStatsEntry : locStatsMap.entrySet()) {
            StatisticsKey key = locStatsEntry.getKey();
            ObjectStatisticsImpl stat = locStatsEntry.getValue();
            if (column == null) {
                for (Map.Entry<String, ColumnStatistics> colStat : locStatsEntry.getValue().columnsStatistics().entrySet()) {
                    StatisticsColumnLocalDataView colStatView = new StatisticsColumnLocalDataView(key, colStat.getKey(), stat);
                    res.add(colStatView);
                }
                continue;
            }
            ColumnStatistics colStat = locStatsEntry.getValue().columnStatistics(column);
            if (colStat == null) continue;
            StatisticsColumnLocalDataView colStatView = new StatisticsColumnLocalDataView(key, column, stat);
            res.add(colStatView);
        }
        return res;
    }
}

