/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload;

import java.io.File;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.ignite.yardstick.upload.AbstractUploadBenchmark;
import org.yardstickframework.BenchmarkUtils;

public class CopyBenchmark
extends AbstractUploadBenchmark {
    private String warmupCsvPath;
    private String realCsvPath;
    private Long packetSize;

    @Override
    protected void init() {
        super.init();
        this.packetSize = this.args.upload.copyPacketSize();
        this.warmupCsvPath = this.generateWarmupCsv();
        this.realCsvPath = this.generateRealCsv();
    }

    private String generateRealCsv() {
        String prefix = "data-" + this.insertRowsCnt + "-rows-";
        return this.generate(prefix, this.insertRowsCnt);
    }

    private String generateWarmupCsv() {
        String prefix = "warmup-" + this.warmupRowsCnt + "-rows-";
        return this.generate(prefix, this.warmupRowsCnt);
    }

    private String generate(String filePrefix, long records) {
        try {
            File workDir = new File(System.getProperty("user.dir"));
            File f = File.createTempFile(filePrefix, ".csv", workDir);
            f.deleteOnExit();
            BenchmarkUtils.println((String)("Generating file: " + f.getAbsolutePath()));
            try (PrintStream out = new PrintStream(f);){
                for (long id = 1L; id <= records; ++id) {
                    String csvLine = this.queries.randomCsvLine(id);
                    out.println(csvLine);
                }
            }
            long sizeMb = f.length() / 0x100000L;
            BenchmarkUtils.println((String)("File have been generated (" + sizeMb + "MiB). It will be removed on exit"));
            return f.getAbsolutePath();
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't generate CSV file, terminating", ex);
        }
    }

    @Override
    protected void warmup(Connection warmupConn) throws Exception {
        try (PreparedStatement fromCsv = warmupConn.prepareStatement(this.queries.copyFrom(this.warmupCsvPath, this.packetSize));){
            fromCsv.executeUpdate();
        }
    }

    @Override
    public void upload(Connection uploadConn) throws Exception {
        try (PreparedStatement fromCsv = uploadConn.prepareStatement(this.queries.copyFrom(this.realCsvPath, this.packetSize));){
            fromCsv.executeUpdate();
        }
    }
}

