/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class GridReversedLinesFileReader
implements Closeable {
    private final int blockSize;
    private final Charset encoding;
    private final RandomAccessFile randomAccessFile;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped = false;

    public GridReversedLinesFileReader(File file) throws IOException {
        this(file, 4096, Charset.defaultCharset().toString());
    }

    public GridReversedLinesFileReader(File file, int blockSize, Charset charset) throws IOException {
        this.blockSize = blockSize;
        this.encoding = charset;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.totalByteLength = this.randomAccessFile.length();
        int lastBlockLength = (int)(this.totalByteLength % (long)blockSize);
        if (lastBlockLength > 0) {
            this.totalBlockCount = this.totalByteLength / (long)blockSize + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)blockSize;
            if (this.totalByteLength > 0L) {
                lastBlockLength = blockSize;
            }
        }
        this.currentFilePart = new FilePart(this.totalBlockCount, lastBlockLength, null);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        float maxBytesPerChar = charsetEncoder.maxBytesPerChar();
        if (maxBytesPerChar == 1.0f) {
            this.byteDecrement = 1;
        } else if (charset == Charset.forName("UTF-8")) {
            this.byteDecrement = 1;
        } else if (charset == Charset.forName("Shift_JIS")) {
            this.byteDecrement = 1;
        } else if (charset == Charset.forName("UTF-16BE") || charset == Charset.forName("UTF-16LE")) {
            this.byteDecrement = 2;
        } else {
            if (charset == Charset.forName("UTF-16")) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + charset + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{"\r\n".getBytes(charset), "\n".getBytes(charset), "\r".getBytes(charset)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
    }

    public GridReversedLinesFileReader(File file, int blockSize, String encoding) throws IOException {
        this(file, blockSize, Charset.forName(encoding));
    }

    public String readLine() throws IOException {
        String line = this.currentFilePart.readLine();
        while (line == null) {
            this.currentFilePart = this.currentFilePart.rollOver();
            if (this.currentFilePart == null) break;
            line = this.currentFilePart.readLine();
        }
        if ("".equals(line) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            line = this.readLine();
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    private class FilePart {
        private final long no;
        private final byte[] data;
        private byte[] leftOver;
        private int currentLastBytePos;

        private FilePart(long no, int length, byte[] leftOverOfLastFilePart) throws IOException {
            this.no = no;
            int dataLength = length + (leftOverOfLastFilePart != null ? leftOverOfLastFilePart.length : 0);
            this.data = new byte[dataLength];
            long off = (no - 1L) * (long)GridReversedLinesFileReader.this.blockSize;
            if (no > 0L) {
                GridReversedLinesFileReader.this.randomAccessFile.seek(off);
                int cntRead = GridReversedLinesFileReader.this.randomAccessFile.read(this.data, 0, length);
                if (cntRead != length) {
                    throw new IllegalStateException("Count of requested bytes and actually read bytes don't match");
                }
            }
            if (leftOverOfLastFilePart != null) {
                System.arraycopy(leftOverOfLastFilePart, 0, this.data, length, leftOverOfLastFilePart.length);
            }
            this.currentLastBytePos = this.data.length - 1;
            this.leftOver = null;
        }

        private FilePart rollOver() throws IOException {
            if (this.currentLastBytePos > -1) {
                throw new IllegalStateException("Current currentLastCharPos unexpectedly positive... last readLine() should have returned something! currentLastCharPos=" + this.currentLastBytePos);
            }
            if (this.no > 1L) {
                return new FilePart(this.no - 1L, GridReversedLinesFileReader.this.blockSize, this.leftOver);
            }
            if (this.leftOver != null) {
                throw new IllegalStateException("Unexpected leftover of the last block: leftOverOfThisFilePart=" + new String(this.leftOver, GridReversedLinesFileReader.this.encoding));
            }
            return null;
        }

        private String readLine() throws IOException {
            String line = null;
            boolean isLastFilePart = this.no == 1L;
            int i = this.currentLastBytePos;
            while (i > -1) {
                if (!isLastFilePart && i < GridReversedLinesFileReader.this.avoidNewlineSplitBufferSize) {
                    this.createLeftOver();
                    break;
                }
                int newLineMatchByteCnt = this.getNewLineMatchByteCount(this.data, i);
                if (newLineMatchByteCnt > 0) {
                    int lineStart = i + 1;
                    int lineLengthBytes = this.currentLastBytePos - lineStart + 1;
                    if (lineLengthBytes < 0) {
                        throw new IllegalStateException("Unexpected negative line length=" + lineLengthBytes);
                    }
                    byte[] lineData = new byte[lineLengthBytes];
                    System.arraycopy(this.data, lineStart, lineData, 0, lineLengthBytes);
                    line = new String(lineData, GridReversedLinesFileReader.this.encoding);
                    this.currentLastBytePos = i - newLineMatchByteCnt;
                    break;
                }
                if ((i -= GridReversedLinesFileReader.this.byteDecrement) >= 0) continue;
                this.createLeftOver();
                break;
            }
            if (isLastFilePart && this.leftOver != null) {
                line = new String(this.leftOver, GridReversedLinesFileReader.this.encoding);
                this.leftOver = null;
            }
            return line;
        }

        private void createLeftOver() {
            int lineLengthBytes = this.currentLastBytePos + 1;
            if (lineLengthBytes > 0) {
                this.leftOver = new byte[lineLengthBytes];
                System.arraycopy(this.data, 0, this.leftOver, 0, lineLengthBytes);
            } else {
                this.leftOver = null;
            }
            this.currentLastBytePos = -1;
        }

        private int getNewLineMatchByteCount(byte[] data, int i) {
            for (byte[] newLineSeq : GridReversedLinesFileReader.this.newLineSequences) {
                boolean match = true;
                for (int j = newLineSeq.length - 1; j >= 0; --j) {
                    int k = i + j - (newLineSeq.length - 1);
                    match &= k >= 0 && data[k] == newLineSeq[j];
                }
                if (!match) continue;
                return newLineSeq.length;
            }
            return 0;
        }
    }
}

