/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.util;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ByteBufferCompat {
    private static final ByteBufferAccess byteBufferAccess;

    private ByteBufferCompat() {
    }

    public static void byteBufferFlip(ByteBuffer byteBuffer) {
        byteBufferAccess.flip(byteBuffer);
    }

    public static void byteBufferClear(ByteBuffer byteBuffer) {
        byteBufferAccess.clear(byteBuffer);
    }

    public static void byteBufferLimit(ByteBuffer byteBuffer, int limit) {
        byteBufferAccess.limit(byteBuffer, limit);
    }

    public static void byteBufferPosition(ByteBuffer byteBuffer, int position) {
        byteBufferAccess.position(byteBuffer, position);
    }

    static {
        try {
            Method m = ByteBuffer.class.getMethod("flip", new Class[0]);
            int classFileVersion = 52;
            if (m.getReturnType() == ByteBuffer.class) {
                classFileVersion = 55;
            }
            String owner = m.getReturnType().getName();
            String ownerSlash = owner.replace('.', '/');
            String ownerDesc = Type.getDescriptor(m.getReturnType());
            final String classNameDots = "org.caffinitas.ohc.util.ByteBufferHelper";
            String classNameSlash = classNameDots.replace('.', '/');
            ClassWriter cw = new ClassWriter(0);
            cw.visit(classFileVersion, 49, classNameSlash, null, "java/lang/Object", new String[]{ByteBufferAccess.class.getName().replace('.', '/')});
            cw.visitSource("ByteBufferHelper.java", null);
            String bbDesc = Type.getDescriptor(ByteBuffer.class);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(17, "flip", "(" + bbDesc + ")V", null, null);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, ownerSlash, "flip", "()" + ownerDesc, false);
            mv.visitInsn(87);
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            mv = cw.visitMethod(17, "clear", "(" + bbDesc + ")V", null, null);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, ownerSlash, "clear", "()" + ownerDesc, false);
            mv.visitInsn(87);
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            mv = cw.visitMethod(17, "limit", "(" + bbDesc + "I)V", null, null);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, ownerSlash, "limit", "(I)" + ownerDesc, false);
            mv.visitInsn(87);
            mv.visitInsn(177);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
            mv = cw.visitMethod(17, "position", "(" + bbDesc + "I)V", null, null);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(182, ownerSlash, "position", "(I)" + ownerDesc, false);
            mv.visitInsn(87);
            mv.visitInsn(177);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
            final byte[] classBytes = cw.toByteArray();
            ClassLoader cl = new ClassLoader(ByteBufferCompat.class.getClassLoader()){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    if (classNameDots.equals(name)) {
                        return this.defineClass(name, classBytes, 0, classBytes.length);
                    }
                    throw new ClassNotFoundException(name);
                }
            };
            byteBufferAccess = (ByteBufferAccess)cl.loadClass(classNameDots).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ByteBufferAccess {
        public void flip(ByteBuffer var1);

        public void clear(ByteBuffer var1);

        public void limit(ByteBuffer var1, int var2);

        public void position(ByteBuffer var1, int var2);
    }
}

