/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.type;

import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.type.define.SerialEnum;

public final class HugeType
extends Enum<HugeType>
implements SerialEnum {
    public static final /* enum */ HugeType UNKNOWN = new HugeType(0, "UNKNOWN");
    public static final /* enum */ HugeType VERTEX_LABEL = new HugeType(1, "VL");
    public static final /* enum */ HugeType EDGE_LABEL = new HugeType(2, "EL");
    public static final /* enum */ HugeType PROPERTY_KEY = new HugeType(3, "PK");
    public static final /* enum */ HugeType INDEX_LABEL = new HugeType(4, "IL");
    public static final /* enum */ HugeType META = new HugeType(40, "M");
    public static final /* enum */ HugeType COUNTER = new HugeType(50, "C");
    public static final /* enum */ HugeType VERTEX = new HugeType(101, "V");
    public static final /* enum */ HugeType SYS_PROPERTY = new HugeType(102, "S");
    public static final /* enum */ HugeType PROPERTY = new HugeType(103, "U");
    public static final /* enum */ HugeType AGGR_PROPERTY_V = new HugeType(104, "VP");
    public static final /* enum */ HugeType AGGR_PROPERTY_E = new HugeType(105, "EP");
    public static final /* enum */ HugeType OLAP = new HugeType(106, "AP");
    public static final /* enum */ HugeType EDGE = new HugeType(120, "E");
    public static final /* enum */ HugeType EDGE_OUT = new HugeType(130, "O");
    public static final /* enum */ HugeType EDGE_IN = new HugeType(140, "I");
    public static final /* enum */ HugeType SECONDARY_INDEX = new HugeType(150, "SI");
    public static final /* enum */ HugeType VERTEX_LABEL_INDEX = new HugeType(151, "VI");
    public static final /* enum */ HugeType EDGE_LABEL_INDEX = new HugeType(152, "EI");
    public static final /* enum */ HugeType RANGE_INT_INDEX = new HugeType(160, "II");
    public static final /* enum */ HugeType RANGE_FLOAT_INDEX = new HugeType(161, "FI");
    public static final /* enum */ HugeType RANGE_LONG_INDEX = new HugeType(162, "LI");
    public static final /* enum */ HugeType RANGE_DOUBLE_INDEX = new HugeType(163, "DI");
    public static final /* enum */ HugeType SEARCH_INDEX = new HugeType(170, "AI");
    public static final /* enum */ HugeType SHARD_INDEX = new HugeType(175, "HI");
    public static final /* enum */ HugeType UNIQUE_INDEX = new HugeType(178, "UI");
    public static final /* enum */ HugeType TASK = new HugeType(180, "TASK");
    public static final /* enum */ HugeType SERVER = new HugeType(181, "SERVER");
    public static final /* enum */ HugeType SYS_SCHEMA = new HugeType(250, "SS");
    public static final /* enum */ HugeType MAX_TYPE = new HugeType(255, "~");
    private byte type = 0;
    private String name;
    private static final Map<String, HugeType> ALL_NAME;
    private static final /* synthetic */ HugeType[] $VALUES;

    public static HugeType[] values() {
        return (HugeType[])$VALUES.clone();
    }

    public static HugeType valueOf(String name) {
        return Enum.valueOf(HugeType.class, name);
    }

    private HugeType(int type, String name) {
        assert (type < 256);
        this.type = (byte)type;
        this.name = name;
    }

    @Override
    public byte code() {
        return this.type;
    }

    public String string() {
        return this.name;
    }

    public String readableName() {
        return this.name().replace('_', ' ').toLowerCase();
    }

    public boolean isSchema() {
        return this == VERTEX_LABEL || this == EDGE_LABEL || this == PROPERTY_KEY || this == INDEX_LABEL;
    }

    public boolean isGraph() {
        return this.isVertex() || this.isEdge();
    }

    public boolean isVertex() {
        return this == VERTEX || this == TASK || this == SERVER;
    }

    public boolean isEdge() {
        return this == EDGE || this == EDGE_OUT || this == EDGE_IN;
    }

    public boolean isIndex() {
        return this == VERTEX_LABEL_INDEX || this == EDGE_LABEL_INDEX || this == SECONDARY_INDEX || this == SEARCH_INDEX || this == RANGE_INT_INDEX || this == RANGE_FLOAT_INDEX || this == RANGE_LONG_INDEX || this == RANGE_DOUBLE_INDEX || this == SHARD_INDEX || this == UNIQUE_INDEX;
    }

    public boolean isStringIndex() {
        return this == VERTEX_LABEL_INDEX || this == EDGE_LABEL_INDEX || this == SECONDARY_INDEX || this == SEARCH_INDEX || this == SHARD_INDEX || this == UNIQUE_INDEX;
    }

    public boolean isNumericIndex() {
        return this == RANGE_INT_INDEX || this == RANGE_FLOAT_INDEX || this == RANGE_LONG_INDEX || this == RANGE_DOUBLE_INDEX || this == SHARD_INDEX;
    }

    public boolean isSecondaryIndex() {
        return this == VERTEX_LABEL_INDEX || this == EDGE_LABEL_INDEX || this == SECONDARY_INDEX;
    }

    public boolean isSearchIndex() {
        return this == SEARCH_INDEX;
    }

    public boolean isRangeIndex() {
        return this == RANGE_INT_INDEX || this == RANGE_FLOAT_INDEX || this == RANGE_LONG_INDEX || this == RANGE_DOUBLE_INDEX;
    }

    public boolean isRange4Index() {
        return this == RANGE_INT_INDEX || this == RANGE_FLOAT_INDEX;
    }

    public boolean isRange8Index() {
        return this == RANGE_LONG_INDEX || this == RANGE_DOUBLE_INDEX;
    }

    public boolean isShardIndex() {
        return this == SHARD_INDEX;
    }

    public boolean isUniqueIndex() {
        return this == UNIQUE_INDEX;
    }

    public boolean isVertexAggregateProperty() {
        return this == AGGR_PROPERTY_V;
    }

    public boolean isEdgeAggregateProperty() {
        return this == AGGR_PROPERTY_E;
    }

    public boolean isAggregateProperty() {
        return this.isVertexAggregateProperty() || this.isEdgeAggregateProperty();
    }

    public static HugeType fromString(String type) {
        return ALL_NAME.get(type);
    }

    public static HugeType fromCode(byte code) {
        return SerialEnum.fromCode(HugeType.class, code);
    }

    public boolean isLabelIndex() {
        return this == VERTEX_LABEL_INDEX || this == EDGE_LABEL_INDEX;
    }

    static {
        $VALUES = new HugeType[]{UNKNOWN, VERTEX_LABEL, EDGE_LABEL, PROPERTY_KEY, INDEX_LABEL, META, COUNTER, VERTEX, SYS_PROPERTY, PROPERTY, AGGR_PROPERTY_V, AGGR_PROPERTY_E, OLAP, EDGE, EDGE_OUT, EDGE_IN, SECONDARY_INDEX, VERTEX_LABEL_INDEX, EDGE_LABEL_INDEX, RANGE_INT_INDEX, RANGE_FLOAT_INDEX, RANGE_LONG_INDEX, RANGE_DOUBLE_INDEX, SEARCH_INDEX, SHARD_INDEX, UNIQUE_INDEX, TASK, SERVER, SYS_SCHEMA, MAX_TYPE};
        ALL_NAME = new HashMap<String, HugeType>();
        SerialEnum.register(HugeType.class);
        for (HugeType type : HugeType.values()) {
            ALL_NAME.put(type.name, type);
        }
    }
}

