/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import org.apache.hugegraph.backend.store.BackendStore;

public interface BackendSession {
    public void open();

    public void close();

    public boolean opened();

    public boolean closed();

    public Object commit();

    public void rollback();

    public boolean hasChanges();

    public int attach();

    public int detach();

    public long created();

    public long updated();

    public void update();

    default public void reconnectIfNeeded() {
    }

    default public void reset() {
    }

    public static abstract class AbstractBackendSession
    implements BackendSession {
        protected boolean opened = true;
        private int refs = 1;
        private BackendStore.TxState txState = BackendStore.TxState.CLEAN;
        private final long created;
        private long updated = this.created = System.currentTimeMillis();

        @Override
        public long created() {
            return this.created;
        }

        @Override
        public long updated() {
            return this.updated;
        }

        @Override
        public void update() {
            this.updated = System.currentTimeMillis();
        }

        @Override
        public boolean opened() {
            return this.opened;
        }

        @Override
        public boolean closed() {
            return !this.opened;
        }

        @Override
        public int attach() {
            return ++this.refs;
        }

        @Override
        public int detach() {
            return --this.refs;
        }

        public boolean closeable() {
            return this.refs <= 0;
        }

        public BackendStore.TxState txState() {
            return this.txState;
        }

        public void txState(BackendStore.TxState state) {
            this.txState = state;
        }
    }
}

