/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.iterator.WrappedIterator;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.Idfiable;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.StringEncoding;

public interface BackendEntry
extends Idfiable {
    public HugeType type();

    @Override
    public Id id();

    public Id originId();

    public Id subId();

    public long ttl();

    public int columnsSize();

    public Collection<BackendColumn> columns();

    public void columns(Collection<BackendColumn> var1);

    public void columns(BackendColumn var1);

    public void merge(BackendEntry var1);

    public boolean mergeable(BackendEntry var1);

    public void clear();

    default public boolean belongToMe(BackendColumn column) {
        return Bytes.prefixWith((byte[])column.name, (byte[])this.id().asBytes());
    }

    default public boolean olap() {
        return false;
    }

    public static interface BackendColumnIterator
    extends BackendIterator<BackendColumn> {
        public static final BackendColumnIterator EMPTY = new EmptyIterator();

        public static BackendColumnIterator empty() {
            return EMPTY;
        }

        public static BackendColumnIterator iterator(BackendColumn element) {
            return new OneColumnIterator(element);
        }

        public static BackendColumnIterator wrap(Iterator<BackendColumn> iter) {
            return new BackendColumnIteratorWrapper(iter);
        }

        public static final class BackendColumnIteratorWrapper
        implements BackendColumnIterator {
            private final Iterator<BackendColumn> iter;

            public BackendColumnIteratorWrapper(Iterator<BackendColumn> iter) {
                E.checkNotNull(iter, (String)"iter");
                this.iter = iter;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public BackendColumn next() {
                return this.iter.next();
            }

            @Override
            public void close() {
                WrappedIterator.close(this.iter);
            }

            @Override
            public byte[] position() {
                return null;
            }
        }

        public static final class OneColumnIterator
        implements BackendColumnIterator {
            private BackendColumn element;

            public OneColumnIterator(BackendColumn element) {
                assert (element != null);
                this.element = element;
            }

            @Override
            public boolean hasNext() {
                return this.element != null;
            }

            @Override
            public BackendColumn next() {
                if (this.element == null) {
                    throw new NoSuchElementException();
                }
                BackendColumn result = this.element;
                this.element = null;
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public byte[] position() {
                return null;
            }
        }

        public static final class EmptyIterator
        implements BackendColumnIterator {
            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public BackendColumn next() {
                throw new NoSuchElementException();
            }

            @Override
            public void close() {
            }

            @Override
            public byte[] position() {
                return null;
            }
        }
    }

    public static interface BackendIterator<T>
    extends Iterator<T>,
    AutoCloseable {
        @Override
        public void close();

        public byte[] position();
    }

    public static class BackendColumn
    implements Comparable<BackendColumn> {
        public byte[] name;
        public byte[] value;

        public static BackendColumn of(byte[] name, byte[] value) {
            BackendColumn col = new BackendColumn();
            col.name = name;
            col.value = value;
            return col;
        }

        public String toString() {
            return String.format("%s=%s", StringEncoding.decode(this.name), StringEncoding.decode(this.value));
        }

        @Override
        public int compareTo(BackendColumn other) {
            if (other == null) {
                return 1;
            }
            return Bytes.compare((byte[])this.name, (byte[])other.name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BackendColumn)) {
                return false;
            }
            BackendColumn other = (BackendColumn)obj;
            return Bytes.equals((byte[])this.name, (byte[])other.name) && Bytes.equals((byte[])this.value, (byte[])other.value);
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.value.hashCode();
        }
    }
}

