/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.HugeTarget;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.Nameable;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public abstract class SchemaDefine {
    protected final HugeGraphParams graph;
    protected final String label;

    public SchemaDefine(HugeGraphParams graph, String label) {
        this.graph = graph;
        this.label = label;
    }

    public abstract void initSchemaIfNeeded();

    protected SchemaManager schema() {
        return this.graph.graph().schema();
    }

    protected boolean existVertexLabel(String label) {
        return this.graph.graph().existsVertexLabel(label);
    }

    protected boolean existEdgeLabel(String label) {
        return this.graph.graph().existsEdgeLabel(label);
    }

    protected String createPropertyKey(String name) {
        return this.createPropertyKey(name, DataType.TEXT);
    }

    protected String createPropertyKey(String name, DataType dataType) {
        return this.createPropertyKey(name, dataType, Cardinality.SINGLE);
    }

    protected String createPropertyKey(String name, DataType dataType, Cardinality cardinality) {
        SchemaManager schema = this.schema();
        PropertyKey propertyKey = (PropertyKey)schema.propertyKey(name).dataType(dataType).cardinality(cardinality).build();
        this.graph.schemaTransaction().addPropertyKey(propertyKey);
        return name;
    }

    protected String[] initProperties(List<String> props) {
        String label = this.label;
        props.add(this.createPropertyKey(SchemaDefine.hideField(label, "create"), DataType.DATE));
        props.add(this.createPropertyKey(SchemaDefine.hideField(label, "update"), DataType.DATE));
        props.add(this.createPropertyKey(SchemaDefine.hideField(label, "creator")));
        return props.toArray(new String[0]);
    }

    protected IndexLabel createRangeIndex(VertexLabel label, String field) {
        SchemaManager schema = this.schema();
        String name = Graph.Hidden.hide((String)(label + "-index-by-" + field));
        IndexLabel indexLabel = (IndexLabel)schema.indexLabel(name).range().on(HugeType.VERTEX_LABEL, this.label).by(field).build();
        this.graph.schemaTransaction().addIndexLabel(label, indexLabel);
        return indexLabel;
    }

    protected static String hideField(String label, String key) {
        return label + "_" + key;
    }

    protected static String unhideField(String label, String key) {
        return Graph.Hidden.unHide((String)label) + "_" + key;
    }

    public static abstract class Relationship
    extends AuthElement {
        private static final long serialVersionUID = -1406157381685832493L;

        public abstract String sourceLabel();

        public abstract String targetLabel();

        public abstract Id source();

        public abstract Id target();

        public void setId() {
            this.id(IdGenerator.of(this.source().asString() + "->" + this.target().asString()));
        }

        public static <T extends Relationship> T fromMap(Map<String, Object> map, T entity) {
            for (Map.Entry<String, Object> item : map.entrySet()) {
                entity.property(Graph.Hidden.hide((String)item.getKey()), item.getValue());
            }
            entity.setId();
            return entity;
        }

        public static <T extends Relationship> T fromEdge(Edge edge, T relationship) {
            E.checkArgument((boolean)edge.label().equals(relationship.label()), (String)"Illegal edge label '%s' for relationship '%s'", (Object[])new Object[]{edge.label(), relationship.label()});
            relationship.id((Id)edge.id());
            Iterator iter = edge.properties(new String[0]);
            while (iter.hasNext()) {
                Property prop = (Property)iter.next();
                relationship.property(prop.key(), prop.value());
            }
            return relationship;
        }

        @Override
        public String idString() {
            String label = Graph.Hidden.unHide((String)this.label());
            StringBuilder sb = new StringBuilder(label.length() + this.source().length() + this.target().length() + 4);
            sb.append(label).append("(").append(this.source()).append("->").append(this.target()).append(")");
            return sb.toString();
        }
    }

    public static abstract class Entity
    extends AuthElement
    implements Nameable {
        private static final long serialVersionUID = 4113319546914811762L;

        public static <T extends Entity> T fromMap(Map<String, Object> map, T entity) {
            for (Map.Entry<String, Object> item : map.entrySet()) {
                entity.property(Graph.Hidden.hide((String)item.getKey()), item.getValue());
            }
            entity.id(IdGenerator.of(entity.name()));
            return entity;
        }

        public static <T extends Entity> T fromVertex(Vertex vertex, T entity) {
            E.checkArgument((boolean)vertex.label().equals(entity.label()), (String)"Illegal vertex label '%s' for entity '%s'", (Object[])new Object[]{vertex.label(), entity.label()});
            entity.id((Id)vertex.id());
            Iterator iter = vertex.properties(new String[0]);
            while (iter.hasNext()) {
                VertexProperty prop = (VertexProperty)iter.next();
                entity.property(prop.key(), prop.value());
            }
            return entity;
        }

        @Override
        public String idString() {
            String label = Graph.Hidden.unHide((String)this.label());
            String name = this.name();
            StringBuilder sb = new StringBuilder(label.length() + name.length() + 2);
            sb.append(label).append("(").append(name).append(")");
            return sb.toString();
        }
    }

    public static abstract class AuthElement
    implements Serializable {
        private static final long serialVersionUID = 8746691160192814973L;
        protected static final String CREATE = "create";
        protected static final String UPDATE = "update";
        protected static final String CREATOR = "creator";
        protected Id id;
        protected Date create;
        protected Date update;
        protected String creator;

        public AuthElement() {
            this.update = this.create = new Date();
        }

        public Id id() {
            return this.id;
        }

        public void id(Id id) {
            this.id = id;
        }

        public String idString() {
            return Graph.Hidden.unHide((String)this.label()) + "(" + this.id + ")";
        }

        public Date create() {
            return this.create;
        }

        public void create(Date create) {
            this.create = create;
        }

        public Date update() {
            return this.update;
        }

        public void update(Date update) {
            this.update = update;
        }

        public void onUpdate() {
            this.update = new Date();
        }

        public String creator() {
            return this.creator;
        }

        public void creator(String creator) {
            this.creator = creator;
        }

        protected Map<String, Object> asMap(Map<String, Object> map) {
            E.checkState((this.create != null ? 1 : 0) != 0, (String)"Property %s time can't be null", (Object[])new Object[]{CREATE});
            E.checkState((this.update != null ? 1 : 0) != 0, (String)"Property %s time can't be null", (Object[])new Object[]{UPDATE});
            E.checkState((this.creator != null ? 1 : 0) != 0, (String)"Property %s can't be null", (Object[])new Object[]{CREATOR});
            if (this.id != null) {
                map.put(Graph.Hidden.unHide((String)HugeTarget.P.ID), this.id);
            }
            map.put(SchemaDefine.unhideField(this.label(), CREATE), this.create);
            map.put(SchemaDefine.unhideField(this.label(), UPDATE), this.update);
            map.put(SchemaDefine.unhideField(this.label(), CREATOR), this.creator);
            return map;
        }

        protected boolean property(String key, Object value) {
            E.checkNotNull((Object)key, (String)"property key");
            if (key.equals(SchemaDefine.hideField(this.label(), CREATE))) {
                this.create = (Date)value;
                return true;
            }
            if (key.equals(SchemaDefine.hideField(this.label(), UPDATE))) {
                this.update = (Date)value;
                return true;
            }
            if (key.equals(SchemaDefine.hideField(this.label(), CREATOR))) {
                this.creator = (String)value;
                return true;
            }
            return false;
        }

        protected Object[] asArray(List<Object> list) {
            E.checkState((this.create != null ? 1 : 0) != 0, (String)"Property %s time can't be null", (Object[])new Object[]{CREATE});
            E.checkState((this.update != null ? 1 : 0) != 0, (String)"Property %s time can't be null", (Object[])new Object[]{UPDATE});
            E.checkState((this.creator != null ? 1 : 0) != 0, (String)"Property %s can't be null", (Object[])new Object[]{CREATOR});
            list.add(SchemaDefine.hideField(this.label(), CREATE));
            list.add(this.create);
            list.add(SchemaDefine.hideField(this.label(), UPDATE));
            list.add(this.update);
            list.add(SchemaDefine.hideField(this.label(), CREATOR));
            list.add(this.creator);
            return list.toArray();
        }

        public abstract ResourceType type();

        public abstract String label();

        public abstract Map<String, Object> asMap();

        protected abstract Object[] asArray();
    }
}

