/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.grpc.common.Key;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.common.ResCode;
import org.apache.hugegraph.store.grpc.common.ResStatus;
import org.apache.hugegraph.store.grpc.session.Agg;
import org.apache.hugegraph.store.grpc.session.BatchGetReq;
import org.apache.hugegraph.store.grpc.session.BatchReq;
import org.apache.hugegraph.store.grpc.session.BatchWriteReq;
import org.apache.hugegraph.store.grpc.session.CleanReq;
import org.apache.hugegraph.store.grpc.session.FeedbackRes;
import org.apache.hugegraph.store.grpc.session.GetReq;
import org.apache.hugegraph.store.grpc.session.GraphReq;
import org.apache.hugegraph.store.grpc.session.HgStoreSessionGrpc;
import org.apache.hugegraph.store.grpc.session.KeyValueResponse;
import org.apache.hugegraph.store.grpc.session.TableReq;
import org.apache.hugegraph.store.grpc.session.ValueResponse;
import org.apache.hugegraph.store.grpc.stream.ScanStreamReq;
import org.apache.hugegraph.store.meta.Graph;
import org.apache.hugegraph.store.meta.GraphManager;
import org.apache.hugegraph.store.node.AppConfig;
import org.apache.hugegraph.store.node.grpc.BatchGrpcClosure;
import org.apache.hugegraph.store.node.grpc.GrpcClosure;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.store.node.grpc.HgStoreSessionImpl;
import org.apache.hugegraph.store.node.grpc.HgStoreWrapperEx;
import org.apache.hugegraph.store.node.util.HgGrpc;
import org.apache.hugegraph.store.node.util.HgStoreNodeUtil;
import org.apache.hugegraph.store.pd.PdProvider;
import org.apache.hugegraph.store.raft.RaftClosure;
import org.apache.hugegraph.store.term.HgPair;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@GRpcService
public class HgStoreSessionImpl
extends HgStoreSessionGrpc.HgStoreSessionImplBase {
    private static final Logger log = LoggerFactory.getLogger(HgStoreSessionImpl.class);
    @Autowired
    private AppConfig appConfig;
    @Autowired
    private HgStoreNodeService storeService;
    private HgStoreWrapperEx wrapper;
    private PdProvider pdProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HgStoreWrapperEx getWrapper() {
        if (this.wrapper == null) {
            HgStoreSessionImpl hgStoreSessionImpl = this;
            synchronized (hgStoreSessionImpl) {
                if (this.wrapper == null) {
                    this.wrapper = new HgStoreWrapperEx(this.storeService.getStoreEngine().getBusinessHandler());
                }
            }
        }
        return this.wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdProvider getPD() {
        if (this.pdProvider == null) {
            HgStoreSessionImpl hgStoreSessionImpl = this;
            synchronized (hgStoreSessionImpl) {
                if (this.pdProvider == null) {
                    this.pdProvider = this.storeService.getStoreEngine().getPdProvider();
                }
            }
        }
        return this.pdProvider;
    }

    public void get2(GetReq request, StreamObserver<FeedbackRes> responseObserver) {
        String graph = request.getHeader().getGraph();
        String table = request.getTk().getTable();
        byte[] key = request.getTk().getKey().toByteArray();
        int code = request.getTk().getCode();
        byte[] value = this.getWrapper().doGet(graph, code, table, key);
        FeedbackRes.Builder builder = FeedbackRes.newBuilder();
        FeedbackRes res = null;
        res = value != null ? builder.setStatus(HgGrpc.success()).setValueResponse(ValueResponse.newBuilder().setValue(ByteString.copyFrom((byte[])value))).build() : builder.setStatus(HgGrpc.success()).setStatus(HgGrpc.not()).build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
    }

    public void clean(CleanReq request, StreamObserver<FeedbackRes> responseObserver) {
        String graph = request.getHeader().getGraph();
        int partition = request.getPartition();
        BatchGrpcClosure closure = new BatchGrpcClosure(1);
        this.storeService.addRaftTask((byte)21, graph, Integer.valueOf(partition), (GeneratedMessageV3)request, closure.newRaftClosure());
        closure.waitFinish(responseObserver, r -> closure.selectError(r), (long)this.appConfig.getRaft().getRpcTimeOut());
    }

    public void doClean(int partId, CleanReq request, RaftClosure response) {
        String graph = request.getHeader().getGraph();
        FeedbackRes.Builder builder = FeedbackRes.newBuilder();
        try {
            if (this.getWrapper().doClean(graph, partId)) {
                builder.setStatus(HgGrpc.success());
            } else {
                builder.setStatus(HgGrpc.not());
            }
        }
        catch (Throwable t) {
            String msg = "Failed to doClean, graph: " + graph + "; partitionId = " + partId;
            log.error(msg, t);
            builder.setStatus(HgGrpc.fail((String)msg));
        }
        GrpcClosure.setResult((RaftClosure)response, (Object)builder.build());
    }

    public void batchGet2(BatchGetReq request, StreamObserver<FeedbackRes> responseObserver) {
        String graph = request.getHeader().getGraph();
        String table = request.getTable();
        FeedbackRes.Builder builder = FeedbackRes.newBuilder();
        List keyList = request.getKeyList();
        if (keyList == null || keyList.isEmpty()) {
            builder.setStatus(HgGrpc.fail((String)"keys is empty"));
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
            return;
        }
        KeyValueResponse.Builder keyValueBuilder = KeyValueResponse.newBuilder();
        int max = keyList.size() - 1;
        AtomicInteger count = new AtomicInteger(-1);
        Kv.Builder kvBuilder = Kv.newBuilder();
        this.getWrapper().batchGet(graph, table, () -> {
            if (count.getAndAdd(1) == max) {
                return null;
            }
            Key key = (Key)keyList.get(count.get());
            if (log.isDebugEnabled()) {
                log.debug("batch-getMetric: " + HgStoreNodeUtil.toStr((byte[])key.getKey().toByteArray()));
            }
            return HgGrpc.toHgPair((Key)key);
        }, pair -> {
            if (pair.getValue() == null || pair.getKey() == null) {
                return;
            }
            keyValueBuilder.addKv(HgGrpc.toKv((HgPair)pair, (Kv.Builder)kvBuilder));
        });
        builder.setKeyValueResponse(keyValueBuilder.build());
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void batch(BatchReq request, StreamObserver<FeedbackRes> observer) {
        String graph = request.getHeader().getGraph();
        List list = request.getWriteReq().getEntryList();
        PdProvider pd = this.getPD();
        try {
            GraphManager graphManager = pd.getGraphManager();
            Graph managerGraph = graphManager.getGraph(graph);
            if (managerGraph != null && graph.endsWith("/g")) {
                Metapb.GraphMode graphMode;
                Metapb.GraphState graphState;
                Metapb.Graph g = managerGraph.getProtoObj();
                if (g == null || g.getGraphState() == null) {
                    g = pd.getPDClient().getGraphWithOutException(graph);
                    managerGraph.setGraph(g);
                }
                if (g != null && (graphState = g.getGraphState()) != null && (graphMode = graphState.getMode()) != null && graphMode.getNumber() == 1) {
                    Metapb.Graph pdGraph = pd.getPDClient().getGraph(graph);
                    Metapb.GraphState pdGraphState = pdGraph.getGraphState();
                    if (pdGraphState != null && pdGraphState.getMode() != null && pdGraphState.getMode().getNumber() == 1) {
                        throw new PDException(-1, "the graph space size has reached the threshold");
                    }
                    managerGraph.setProtoObj(pdGraph);
                }
            }
        }
        catch (PDException e) {
            ResStatus status = ResStatus.newBuilder().setCode(ResCode.RES_CODE_EXCESS).setMsg(e.getMessage()).build();
            FeedbackRes feedbackRes = FeedbackRes.newBuilder().setStatus(status).build();
            observer.onNext((Object)feedbackRes);
            observer.onCompleted();
            return;
        }
        HashMap<Integer, List> groups = new HashMap<Integer, List>();
        list.forEach(entry -> {
            Key startKey = entry.getStartKey();
            if (startKey.getCode() == -1) {
                List ids = this.storeService.getGraphLeaderPartitionIds(graph);
                ids.forEach(id -> {
                    if (!groups.containsKey(id)) {
                        groups.put((Integer)id, new LinkedList());
                    }
                    ((List)groups.get(id)).add(entry);
                });
            } else {
                Integer partitionId = pd.getPartitionByCode(graph, startKey.getCode()).getId();
                if (!groups.containsKey(partitionId)) {
                    groups.put(partitionId, new LinkedList());
                }
                ((List)groups.get(partitionId)).add(entry);
            }
        });
        BatchGrpcClosure closure = new BatchGrpcClosure(groups.size());
        groups.forEach((partition, entries) -> this.storeService.addRaftTask((byte)18, graph, partition, (GeneratedMessageV3)BatchReq.newBuilder().setHeader(request.getHeader()).setWriteReq(BatchWriteReq.newBuilder().addAllEntry((Iterable)entries)).build(), closure.newRaftClosure()));
        if (!graph.isEmpty()) {
            log.debug(" batch: waiting raft...");
            closure.waitFinish(observer, r -> closure.selectError(r), (long)this.appConfig.getRaft().getRpcTimeOut());
            log.debug(" batch: ended waiting");
        } else {
            log.info(" batch: there is none of raft leader, graph = {}.", (Object)request.getHeader().getGraph());
            observer.onNext((Object)FeedbackRes.newBuilder().setStatus(HgGrpc.success()).build());
            observer.onCompleted();
        }
    }

    public void doBatch(int partId, BatchReq request, RaftClosure response) {
        String graph = request.getHeader().getGraph();
        String batchId = request.getBatchId();
        FeedbackRes.Builder builder = FeedbackRes.newBuilder();
        List entries = request.getWriteReq().getEntryList();
        try {
            this.getWrapper().doBatch(graph, partId, entries);
            builder.setStatus(HgGrpc.success());
        }
        catch (Throwable t) {
            String msg = "Failed to doBatch, graph: " + graph + "; batchId= " + batchId;
            log.error(msg, t);
            builder.setStatus(HgGrpc.fail((String)msg));
        }
        GrpcClosure.setResult((RaftClosure)response, (Object)builder.build());
    }

    public void table(TableReq request, StreamObserver<FeedbackRes> observer) {
        if (log.isDebugEnabled()) {
            log.debug("table: method = {}, graph = {}, table = {}", new Object[]{request.getMethod().name(), request.getHeader().getGraph(), request.getTableName()});
        }
        String graph = request.getHeader().getGraph();
        List ids = this.storeService.getGraphLeaderPartitionIds(graph);
        HashMap<Integer, TableReq> groups = new HashMap<Integer, TableReq>();
        ids.forEach(id -> groups.put((Integer)id, request));
        BatchGrpcClosure closure = new BatchGrpcClosure(groups.size());
        groups.forEach((partition, entries) -> this.storeService.addRaftTask((byte)19, graph, partition, (GeneratedMessageV3)TableReq.newBuilder((TableReq)request).build(), closure.newRaftClosure()));
        if (!groups.isEmpty()) {
            closure.waitFinish(observer, r -> closure.selectError(r), (long)this.appConfig.getRaft().getRpcTimeOut());
        } else {
            ResStatus status = null;
            switch (1.$SwitchMap$org$apache$hugegraph$store$grpc$common$TableMethod[request.getMethod().ordinal()]) {
                case 1: {
                    status = HgGrpc.not();
                    break;
                }
                default: {
                    status = HgGrpc.success();
                }
            }
            observer.onNext((Object)FeedbackRes.newBuilder().setStatus(status).build());
            observer.onCompleted();
        }
    }

    public void doTable(int partId, TableReq request, RaftClosure response) {
        if (log.isDebugEnabled()) {
            log.debug(" - doTable[{}]: graph = {}, table = {}", new Object[]{request.getMethod().name(), request.getHeader().getGraph(), request.getTableName()});
        }
        FeedbackRes.Builder builder = FeedbackRes.newBuilder();
        try {
            log.debug(" - starting wrapper:doTable ");
            if (this.getWrapper().doTable(partId, request.getMethod(), request.getHeader().getGraph(), request.getTableName())) {
                builder.setStatus(HgGrpc.success());
            } else {
                builder.setStatus(HgGrpc.not());
            }
            log.debug(" - ended wrapper:doTable ");
        }
        catch (Throwable t) {
            String msg = "Failed to invoke doTable[ " + request.getMethod().name() + " ], graph=" + request.getHeader().getGraph() + " , table=" + request.getTableName();
            log.error(msg, t);
            builder.setStatus(HgGrpc.fail((String)msg));
        }
        log.debug(" - starting GrpcClosure:setResult ");
        GrpcClosure.setResult((RaftClosure)response, (Object)builder.build());
        log.debug(" - ended GrpcClosure:setResult ");
    }

    public void graph(GraphReq request, StreamObserver<FeedbackRes> observer) {
        if (log.isDebugEnabled()) {
            log.debug("graph: method = {}, graph = {}, table = {}", new Object[]{request.getMethod().name(), request.getHeader().getGraph(), request.getGraphName()});
        }
        String graph = request.getHeader().getGraph();
        List ids = this.storeService.getGraphLeaderPartitionIds(graph);
        HashMap<Integer, GraphReq> groups = new HashMap<Integer, GraphReq>();
        ids.forEach(id -> groups.put((Integer)id, request));
        BatchGrpcClosure closure = new BatchGrpcClosure(groups.size());
        groups.forEach((partition, entries) -> this.storeService.addRaftTask((byte)20, graph, partition, (GeneratedMessageV3)GraphReq.newBuilder((GraphReq)request).build(), closure.newRaftClosure()));
        if (!groups.isEmpty()) {
            closure.waitFinish(observer, r -> closure.selectError(r), (long)this.appConfig.getRaft().getRpcTimeOut());
        } else {
            observer.onNext((Object)FeedbackRes.newBuilder().setStatus(HgGrpc.success()).build());
            observer.onCompleted();
        }
    }

    public void doGraph(int partId, GraphReq request, RaftClosure response) {
        if (log.isDebugEnabled()) {
            log.debug(" - doGraph[{}]: graph = {}, table = {}", new Object[]{request.getMethod().name(), request.getHeader().getGraph(), request.getGraphName()});
        }
        FeedbackRes.Builder builder = FeedbackRes.newBuilder();
        try {
            if (this.getWrapper().doGraph(partId, request.getMethod(), request.getHeader().getGraph())) {
                builder.setStatus(HgGrpc.success());
            } else {
                builder.setStatus(HgGrpc.not());
            }
        }
        catch (Throwable t) {
            String msg = "Failed to invoke doGraph[ " + request.getMethod().name() + " ], graph=" + request.getHeader().getGraph();
            log.error(msg, t);
            builder.setStatus(HgGrpc.fail((String)msg));
        }
        GrpcClosure.setResult((RaftClosure)response, (Object)builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count(ScanStreamReq request, StreamObserver<Agg> observer) {
        Object it = null;
        try {
            BusinessHandler handler = this.storeService.getStoreEngine().getBusinessHandler();
            long count = handler.count(request.getHeader().getGraph(), request.getTable());
            observer.onNext((Object)Agg.newBuilder().setCount(count).build());
            observer.onCompleted();
        }
        catch (Exception e) {
            observer.onError((Throwable)e);
        }
        finally {
            if (it != null) {
                try {
                    it.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

