/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.contribs.mx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.hadoop.hbase.shaded.contribs.mx.LongCounter;
import org.apache.hadoop.hbase.shaded.contribs.mx.S3BucketMx;
import org.apache.hadoop.hbase.shaded.contribs.mx.S3ObjectMxMBean;
import org.apache.hadoop.hbase.shaded.contribs.mx.S3ServiceMx;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.StorageObject;

public class S3ObjectMx
implements S3ObjectMxMBean {
    public static final boolean isEnabled = "true".equals(System.getProperty("jets3t.object.mx"));
    private static Map objects = Collections.synchronizedMap(new HashMap());
    private static final int TOTAL = 0;
    private static final int GET = 1;
    private static final int HEAD = 2;
    private static final int PUT = 3;
    private static final int DELETE = 4;
    private static final int COPY = 5;
    private static final int MAX = 6;
    private final LongCounter[] counters = new LongCounter[6];

    private S3ObjectMx() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new LongCounter();
        }
    }

    public long getTotalRequests() {
        return this.counters[0].getValue();
    }

    public long getTotalGetRequests() {
        return this.counters[1].getValue();
    }

    public long getTotalHeadRequests() {
        return this.counters[2].getValue();
    }

    public long getTotalPutRequests() {
        return this.counters[3].getValue();
    }

    public long getTotalDeleteRequests() {
        return this.counters[4].getValue();
    }

    public long getTotalCopyRequests() {
        return this.counters[5].getValue();
    }

    public static void registerMBeans(String bucketName, StorageObject[] objects) {
        if (!isEnabled) {
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            S3ObjectMx.getInstance(bucketName, objects[i].getKey());
        }
    }

    private static S3ObjectMx getInstance(String bucketName, String key) {
        String props = "Type=S3Object,Bucket=" + bucketName + "," + "Name=" + key;
        S3ObjectMx object = (S3ObjectMx)objects.get(props);
        if (object == null) {
            object = new S3ObjectMx();
            objects.put(props, object);
            ObjectName name = S3ServiceMx.getObjectName(props);
            try {
                S3ServiceMx.registerMBean(object, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public static void increment(int type, String bucketName, String key) {
        if (isEnabled) {
            S3ObjectMx object = S3ObjectMx.getInstance(bucketName, key);
            object.counters[0].increment();
            object.counters[type].increment();
        }
    }

    public static void get(String bucketName, String key) {
        S3ObjectMx.increment(1, bucketName, key);
        S3BucketMx.o_get(bucketName);
    }

    public static void head(String bucketName, String key) {
        S3ObjectMx.increment(2, bucketName, key);
        S3BucketMx.o_head(bucketName);
    }

    public static void put(String bucketName, String key) {
        S3ObjectMx.increment(3, bucketName, key);
        S3BucketMx.o_put(bucketName);
    }

    public static void delete(String bucketName, String key) {
        S3ObjectMx.increment(4, bucketName, key);
        S3BucketMx.o_delete(bucketName);
    }

    public static void copy(String bucketName, String key) {
        S3ObjectMx.increment(5, bucketName, key);
        S3BucketMx.o_copy(bucketName);
    }
}

