/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.Role;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.RolesCache;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Roles {
    private static final Logger logger = LoggerFactory.getLogger(Roles.class);
    private static final Role NO_ROLE = new Role("", false, false, Collections.emptyMap(), Collections.emptySet());
    private static RolesCache cache;

    @VisibleForTesting
    public static void initRolesCache(IRoleManager roleManager, BooleanSupplier enableCache) {
        if (cache != null) {
            cache.unregisterMBean();
        }
        cache = new RolesCache(roleManager, enableCache);
    }

    @VisibleForTesting
    public static void clearCache() {
        cache.invalidate();
    }

    public static Set<RoleResource> getRoles(RoleResource primaryRole) {
        return cache.getRoleResources(primaryRole);
    }

    public static Set<Role> getRoleDetails(RoleResource primaryRole) {
        return cache.getRoles(primaryRole);
    }

    public static boolean hasSuperuserStatus(RoleResource role) {
        try {
            for (Role r : Roles.getRoleDetails(role)) {
                if (!r.isSuper) continue;
                return true;
            }
            return false;
        }
        catch (RequestExecutionException e) {
            logger.debug("Failed to authorize {} for super-user permission", (Object)role.getRoleName());
            throw new UnauthorizedException("Unable to perform authorization of super-user permission: " + e.getMessage(), e);
        }
    }

    public static boolean canLogin(RoleResource role) {
        try {
            for (Role r : Roles.getRoleDetails(role)) {
                if (!r.resource.equals(role)) continue;
                return r.canLogin;
            }
            return false;
        }
        catch (RequestExecutionException e) {
            logger.debug("Failed to authorize {} for login permission", (Object)role.getRoleName());
            throw new UnauthorizedException("Unable to perform authorization of login permission: " + e.getMessage(), e);
        }
    }

    public static Map<String, String> getOptions(RoleResource role) {
        for (Role r : Roles.getRoleDetails(role)) {
            if (!r.resource.equals(role)) continue;
            return r.options;
        }
        return Roles.NO_ROLE.options;
    }

    public static Role nullRole() {
        return NO_ROLE;
    }

    public static boolean isNullRole(Role role) {
        return NO_ROLE.equals(role);
    }

    public static Role fromRoleResource(RoleResource resource, IRoleManager roleManager) {
        return new Role(resource.getName(), roleManager.isSuper(resource), roleManager.canLogin(resource), roleManager.getCustomOptions(resource), roleManager.getRoles(resource, false).stream().map(RoleResource::getRoleName).collect(Collectors.toSet()));
    }

    static {
        Roles.initRolesCache(DatabaseDescriptor.getRoleManager(), () -> DatabaseDescriptor.getAuthenticator().requireAuthentication());
    }
}

