/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.watch;

import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.watch.NodeEventType;
import org.apache.hugegraph.pd.grpc.watch.WatchCreateRequest;
import org.apache.hugegraph.pd.grpc.watch.WatchRequest;
import org.apache.hugegraph.pd.grpc.watch.WatchResponse;
import org.apache.hugegraph.pd.grpc.watch.WatchType;
import org.apache.hugegraph.pd.watch.AbstractWatchSubject;
import org.apache.hugegraph.pd.watch.NodeChangeSubject;
import org.apache.hugegraph.pd.watch.PDWatchSubject;
import org.apache.hugegraph.pd.watch.PartitionChangeSubject;
import org.apache.hugegraph.pd.watch.ShardGroupChangeSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class PDWatchSubject
implements StreamObserver<WatchRequest> {
    private static final Logger log = LoggerFactory.getLogger(PDWatchSubject.class);
    public static final Map<String, AbstractWatchSubject> subjectHolder = new ConcurrentHashMap();
    private static final byte[] lock = new byte[0];
    private final StreamObserver<WatchResponse> responseObserver;
    private AbstractWatchSubject subject;
    private Long watcherId;

    private PDWatchSubject(StreamObserver<WatchResponse> responseObserver) {
        this.responseObserver = responseObserver;
    }

    public static StreamObserver<WatchRequest> addObserver(StreamObserver<WatchResponse> responseObserver) {
        HgAssert.isArgumentNotNull(responseObserver, (String)"responseObserver");
        return new PDWatchSubject(responseObserver);
    }

    public static void notifyPartitionChange(ChangeType changeType, String graph, int partitionId) {
        ((PartitionChangeSubject)subjectHolder.get(WatchType.WATCH_TYPE_PARTITION_CHANGE.name())).notifyWatcher(changeType.getGrpcType(), graph, partitionId);
    }

    public static void notifyShardGroupChange(ChangeType changeType, int groupId, Metapb.ShardGroup group) {
        ((ShardGroupChangeSubject)subjectHolder.get(WatchType.WATCH_TYPE_SHARD_GROUP_CHANGE.name())).notifyWatcher(changeType.getGrpcType(), groupId, group);
    }

    public static void notifyNodeChange(NodeEventType changeType, String graph, long nodeId) {
        ((NodeChangeSubject)subjectHolder.get(WatchType.WATCH_TYPE_STORE_NODE_CHANGE.name())).notifyWatcher(changeType, graph, nodeId);
    }

    public static void notifyChange(WatchType type, WatchResponse.Builder builder) {
        ((AbstractWatchSubject)subjectHolder.get(type.name())).notifyWatcher(builder);
    }

    public static void notifyError(int code, String message) {
        subjectHolder.forEach((k, v) -> v.notifyError(code, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long createWatcherId() {
        byte[] byArray = lock;
        synchronized (lock) {
            Thread.yield();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                log.error("Failed to sleep", (Throwable)e);
            }
            return System.currentTimeMillis();
        }
    }

    private void cancelWatcher() {
        if (this.subject == null) {
            this.responseObserver.onError((Throwable)new Exception("Invoke cancel-watch before create-watch."));
            return;
        }
        this.subject.removeObserver(this.watcherId, this.responseObserver);
    }

    private WatchType getWatchType(WatchCreateRequest request) {
        WatchType watchType = request.getWatchType();
        if (watchType.equals((Object)WatchType.WATCH_TYPE_UNKNOWN)) {
            this.responseObserver.onError((Throwable)new Exception("unknown watch type."));
            return null;
        }
        return watchType;
    }

    private AbstractWatchSubject getSubject(WatchType watchType) {
        AbstractWatchSubject subject = (AbstractWatchSubject)subjectHolder.get(watchType.name());
        if (subject == null) {
            this.responseObserver.onError((Throwable)new Exception("Unsupported watch-type: " + watchType.name()));
            return null;
        }
        return subject;
    }

    private void addWatcher(WatchCreateRequest request) {
        if (this.subject != null) {
            return;
        }
        WatchType watchType = this.getWatchType(request);
        if (watchType == null) {
            return;
        }
        this.subject = this.getSubject(watchType);
        this.watcherId = PDWatchSubject.createWatcherId();
        this.subject.addObserver(this.watcherId, this.responseObserver);
    }

    public void onNext(WatchRequest watchRequest) {
        if (watchRequest.hasCreateRequest()) {
            this.addWatcher(watchRequest.getCreateRequest());
            return;
        }
        if (watchRequest.hasCancelRequest()) {
            this.cancelWatcher();
        }
    }

    public void onError(Throwable throwable) {
        this.cancelWatcher();
    }

    public void onCompleted() {
        this.cancelWatcher();
    }

    static {
        subjectHolder.put(WatchType.WATCH_TYPE_PARTITION_CHANGE.name(), new PartitionChangeSubject());
        subjectHolder.put(WatchType.WATCH_TYPE_STORE_NODE_CHANGE.name(), new NodeChangeSubject());
        subjectHolder.put(WatchType.WATCH_TYPE_GRAPH_CHANGE.name(), new NodeChangeSubject());
        subjectHolder.put(WatchType.WATCH_TYPE_SHARD_GROUP_CHANGE.name(), new ShardGroupChangeSubject());
    }
}

