/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.hugegraph.pd.client.AbstractClientStubProxy;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.PDGrpc;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    private static final ConcurrentHashMap<String, ManagedChannel> chs = new ConcurrentHashMap();
    public static Pdpb.ResponseHeader okHeader = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setType(Pdpb.ErrorType.OK)).build();
    protected final Pdpb.RequestHeader header;
    protected final AbstractClientStubProxy stubProxy;
    protected final PDConfig config;
    protected ManagedChannel channel = null;
    protected volatile ConcurrentMap<String, AbstractBlockingStub> stubs = null;

    protected AbstractClient(PDConfig config) {
        String[] hosts = config.getServerHost().split(",");
        this.stubProxy = new AbstractClientStubProxy(hosts);
        this.header = Pdpb.RequestHeader.getDefaultInstance();
        this.config = config;
    }

    public static Pdpb.ResponseHeader newErrorHeader(int errorCode, String errorMsg) {
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setTypeValue(errorCode).setMessage(errorMsg)).build();
        return header;
    }

    protected static void handleErrors(Pdpb.ResponseHeader header) throws PDException {
        if (header.hasError() && header.getError().getType() != Pdpb.ErrorType.OK) {
            throw new PDException(header.getError().getTypeValue(), String.format("PD request error, error code = %d, msg = %s", header.getError().getTypeValue(), header.getError().getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBlockingStub getBlockingStub() throws PDException {
        if (this.stubProxy.getBlockingStub() == null) {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                String host;
                if (this.stubProxy.getBlockingStub() == null && (host = this.resetStub()).isEmpty()) {
                    throw new PDException(104, "PD unreachable, pd.peers=" + this.config.getServerHost());
                }
            }
        }
        return (AbstractBlockingStub)this.stubProxy.getBlockingStub().withDeadlineAfter(this.config.getGrpcTimeOut(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractStub getStub() throws PDException {
        if (this.stubProxy.getStub() == null) {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                String host;
                if (this.stubProxy.getStub() == null && (host = this.resetStub()).isEmpty()) {
                    throw new PDException(104, "PD unreachable, pd.peers=" + this.config.getServerHost());
                }
            }
        }
        return this.stubProxy.getStub();
    }

    protected abstract AbstractStub createStub();

    protected abstract AbstractBlockingStub createBlockingStub();

    private String resetStub() {
        String leaderHost = "";
        for (int i = 0; i < this.stubProxy.getHostCount(); ++i) {
            String host = this.stubProxy.nextHost();
            this.channel = ManagedChannelBuilder.forTarget((String)host).usePlaintext().build();
            PDGrpc.PDBlockingStub blockingStub = (PDGrpc.PDBlockingStub)PDGrpc.newBlockingStub((Channel)this.channel).withDeadlineAfter(this.config.getGrpcTimeOut(), TimeUnit.MILLISECONDS);
            try {
                Pdpb.GetMembersRequest request = Pdpb.GetMembersRequest.newBuilder().setHeader(this.header).build();
                Pdpb.GetMembersResponse members = blockingStub.getMembers(request);
                Metapb.Member leader = members.getLeader();
                leaderHost = leader.getGrpcUrl();
                this.close();
                this.channel = ManagedChannelBuilder.forTarget((String)leaderHost).usePlaintext().build();
                this.stubProxy.setBlockingStub(this.createBlockingStub());
                this.stubProxy.setStub(this.createStub());
                log.info("PDClient connect to host = {} success", (Object)leaderHost);
                break;
            }
            catch (Exception e) {
                log.error("PDClient connect to {} exception {}, {}", new Object[]{host, e.getMessage(), e.getCause() != null ? e.getCause().getMessage() : ""});
                continue;
            }
        }
        return leaderHost;
    }

    protected <ReqT, RespT, StubT extends AbstractBlockingStub<StubT>> RespT blockingUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT req) throws PDException {
        return this.blockingUnaryCall(method, req, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ReqT, RespT, StubT extends AbstractBlockingStub<StubT>> RespT blockingUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT req, int retry) throws PDException {
        AbstractBlockingStub stub = this.getBlockingStub();
        try {
            Object resp = ClientCalls.blockingUnaryCall((Channel)stub.getChannel(), method, (CallOptions)stub.getCallOptions(), req);
            return (RespT)resp;
        }
        catch (Exception e) {
            log.error(method.getFullMethodName() + " exception, {}", (Object)e.getMessage());
            if (e instanceof StatusRuntimeException && retry < this.stubProxy.getHostCount()) {
                AbstractClient abstractClient = this;
                synchronized (abstractClient) {
                    this.stubProxy.setBlockingStub(null);
                }
                return this.blockingUnaryCall(method, req, ++retry);
            }
            return null;
        }
    }

    private AbstractBlockingStub getConcurrentBlockingStub(String address) {
        AbstractBlockingStub stub = (AbstractBlockingStub)this.stubs.get(address);
        if (stub != null) {
            return stub;
        }
        ManagedChannel ch = ManagedChannelBuilder.forTarget((String)address).usePlaintext().build();
        PDGrpc.PDBlockingStub blockingStub = (PDGrpc.PDBlockingStub)PDGrpc.newBlockingStub((Channel)ch).withDeadlineAfter(this.config.getGrpcTimeOut(), TimeUnit.MILLISECONDS);
        this.stubs.put(address, (AbstractBlockingStub)blockingStub);
        return blockingStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ReqT, RespT> KVPair<Boolean, RespT> concurrentBlockingUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT req, Predicate<RespT> predicate) {
        AtomicReference response;
        Stream<Object> respTStream;
        boolean result;
        LinkedList<String> hostList = this.stubProxy.getHostList();
        if (this.stubs == null) {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                if (this.stubs == null) {
                    this.stubs = new ConcurrentHashMap<String, AbstractBlockingStub>(hostList.size());
                }
            }
        }
        KVPair pair = (result = (respTStream = hostList.parallelStream().map(address -> {
            AbstractBlockingStub stub = this.getConcurrentBlockingStub((String)address);
            Object resp = ClientCalls.blockingUnaryCall((Channel)stub.getChannel(), (MethodDescriptor)method, (CallOptions)stub.getCallOptions(), (Object)req);
            return resp;
        })).anyMatch(arg_0 -> AbstractClient.lambda$concurrentBlockingUnaryCall$1(response = new AtomicReference(), predicate, arg_0))) ? new KVPair((Object)true, null) : new KVPair((Object)false, response.get());
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ReqT, RespT> void streamingCall(MethodDescriptor<ReqT, RespT> method, ReqT request, StreamObserver<RespT> responseObserver, int retry) throws PDException {
        AbstractStub stub = this.getStub();
        try {
            ClientCall call = stub.getChannel().newCall(method, stub.getCallOptions());
            ClientCalls.asyncServerStreamingCall((ClientCall)call, request, responseObserver);
        }
        catch (Exception e) {
            if (e instanceof StatusRuntimeException && retry < this.stubProxy.getHostCount()) {
                AbstractClient abstractClient = this;
                synchronized (abstractClient) {
                    this.stubProxy.setStub(null);
                }
                this.streamingCall(method, request, responseObserver, ++retry);
                return;
            }
            log.error("rpc call with exception, {}", (Object)e.getMessage());
        }
    }

    @Override
    public void close() {
        this.closeChannel(this.channel);
        if (this.stubs != null) {
            for (AbstractBlockingStub stub : this.stubs.values()) {
                this.closeChannel((ManagedChannel)stub.getChannel());
            }
        }
    }

    private void closeChannel(ManagedChannel channel) {
        try {
            while (channel != null && !channel.shutdownNow().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (Exception e) {
            log.info("Close channel with error : ", (Throwable)e);
        }
    }

    private static /* synthetic */ boolean lambda$concurrentBlockingUnaryCall$1(AtomicReference response, Predicate predicate, Object r) {
        response.set(r);
        return predicate.test(r);
    }
}

