/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;

public final class MapReducePool {
    private final LinkedBlockingQueue<MapReduce<?, ?, ?, ?, ?>> pool;
    private static final int TIMEOUT_MS = 2500;

    public MapReducePool(MapReduce mapReduce, int poolSize) {
        this.pool = new LinkedBlockingQueue(poolSize);
        while (this.pool.remainingCapacity() > 0) {
            this.pool.add(mapReduce.clone());
        }
    }

    public MapReduce take() {
        try {
            return this.pool.poll(2500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void offer(MapReduce<?, ?, ?, ?, ?> mapReduce) {
        try {
            this.pool.offer(mapReduce, 2500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

