/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jets3t.service;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.shaded.org.apache.http.client.CredentialsProvider;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.Constants;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.Jets3tProperties;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.MultipartUploadChunk;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.S3ServiceException;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.ServiceException;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.AccessControlList;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.GrantAndPermission;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.GroupGrantee;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.Permission;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest.httpclient.RestStorageService;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.MultipartCompleted;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.MultipartPart;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.MultipartUpload;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.MultipleDeleteResult;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.NotificationConfig;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3Bucket;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3BucketLoggingStatus;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3BucketVersioningStatus;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3Object;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.StorageBucket;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.StorageObject;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.WebsiteConfig;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.container.ObjectKeyAndVersion;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.mx.MxDelegate;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.security.AWSDevPayCredentials;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.security.ProviderCredentials;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.utils.MultipartUtils;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.utils.RestUtils;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.utils.ServiceUtils;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.utils.signedurl.SignedUrlHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class S3Service
extends RestStorageService
implements SignedUrlHandler {
    private static final Log log = LogFactory.getLog(S3Service.class);

    protected S3Service(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) {
        super(credentials, invokingApplicationDescription, credentialsProvider, jets3tProperties);
    }

    protected S3Service(ProviderCredentials credentials, String invokingApplicationDescription, Jets3tProperties jets3tProperties) {
        super(credentials, invokingApplicationDescription, null, jets3tProperties);
    }

    protected S3Service(ProviderCredentials credentials, String invokingApplicationDescription) {
        this(credentials, invokingApplicationDescription, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    protected S3Service(ProviderCredentials credentials) {
        this(credentials, null);
    }

    @Deprecated
    public ProviderCredentials getAWSCredentials() {
        return this.credentials;
    }

    public String createUnsignedObjectUrl(String bucketName, String objectKey, boolean isVirtualHost, boolean isHttps, boolean isDnsBucketNamingDisabled) throws S3ServiceException {
        String signedGETUrl = this.createSignedUrl("GET", bucketName, objectKey, null, null, 0L, isVirtualHost, isHttps, isDnsBucketNamingDisabled);
        return signedGETUrl.split("\\?")[0];
    }

    public String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map<String, Object> headersMap, long secondsSinceEpoch, boolean isVirtualHost, boolean isHttps, boolean isDnsBucketNamingDisabled) throws S3ServiceException {
        try {
            String hostname;
            String s3Endpoint = this.getEndpoint();
            String uriPath = "";
            String string = hostname = isVirtualHost ? bucketName : ServiceUtils.generateS3HostnameForBucket(bucketName, isDnsBucketNamingDisabled, s3Endpoint);
            if (headersMap == null) {
                headersMap = new HashMap<String, Object>();
            }
            String virtualBucketPath = "";
            if (!s3Endpoint.equals(hostname)) {
                int subdomainOffset = hostname.lastIndexOf("." + s3Endpoint);
                virtualBucketPath = subdomainOffset > 0 ? hostname.substring(0, subdomainOffset) + "/" : hostname + "/";
                uriPath = objectKey != null ? RestUtils.encodeUrlPath(objectKey, "/") : "";
            } else {
                uriPath = bucketName + (objectKey != null ? "/" + RestUtils.encodeUrlPath(objectKey, "/") : "");
            }
            uriPath = specialParamName != null ? uriPath + "?" + specialParamName + "&" : uriPath + "?";
            if (this.credentials instanceof AWSDevPayCredentials) {
                AWSDevPayCredentials devPayCredentials = (AWSDevPayCredentials)this.credentials;
                if (devPayCredentials.getProductToken() != null) {
                    String securityToken = devPayCredentials.getUserToken() + "," + devPayCredentials.getProductToken();
                    headersMap.put("x-amz-security-token", securityToken);
                } else {
                    headersMap.put("x-amz-security-token", devPayCredentials.getUserToken());
                }
                uriPath = uriPath + "x-amz-security-token=" + RestUtils.encodeUrlString((String)headersMap.get("x-amz-security-token")) + "&";
            }
            uriPath = uriPath + "AWSAccessKeyId=" + this.credentials.getAccessKey();
            uriPath = uriPath + "&Expires=" + secondsSinceEpoch;
            if (specialParamName != null && specialParamName.toLowerCase().indexOf("x-amz-request-payer=requester") >= 0) {
                String[] requesterPaysHeaderAndValue = "x-amz-request-payer=requester".split("=");
                headersMap.put(requesterPaysHeaderAndValue[0], requesterPaysHeaderAndValue[1]);
            }
            String serviceEndpointVirtualPath = this.getVirtualPath();
            String canonicalString = RestUtils.makeServiceCanonicalString(method, serviceEndpointVirtualPath + "/" + virtualBucketPath + uriPath, this.renameMetadataKeys(headersMap), String.valueOf(secondsSinceEpoch), this.getRestHeaderPrefix(), this.getResourceParameterNames());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signing canonical string:\n" + canonicalString));
            }
            String signedCanonical = ServiceUtils.signWithHmacSha1(this.credentials.getSecretKey(), canonicalString);
            String encodedCanonical = RestUtils.encodeUrlString(signedCanonical);
            uriPath = uriPath + "&Signature=" + encodedCanonical;
            if (isHttps) {
                int httpsPort = this.getHttpsPort();
                return "https://" + hostname + (httpsPort != 443 ? ":" + httpsPort : "") + serviceEndpointVirtualPath + "/" + uriPath;
            }
            int httpPort = this.getHttpPort();
            return "http://" + hostname + (httpPort != 80 ? ":" + httpPort : "") + serviceEndpointVirtualPath + "/" + uriPath;
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException(e);
        }
    }

    public String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map<String, Object> headersMap, long secondsSinceEpoch, boolean isVirtualHost) throws S3ServiceException {
        boolean isHttps = this.isHttpsOnly();
        boolean disableDnsBuckets = this.getDisableDnsBuckets();
        return this.createSignedUrl(method, bucketName, objectKey, specialParamName, headersMap, secondsSinceEpoch, isVirtualHost, isHttps, disableDnsBuckets);
    }

    public String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map<String, Object> headersMap, long secondsSinceEpoch) throws S3ServiceException {
        return this.createSignedUrl(method, bucketName, objectKey, specialParamName, headersMap, secondsSinceEpoch, false);
    }

    public String createSignedGetUrl(String bucketName, String objectKey, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return this.createSignedUrl("GET", bucketName, objectKey, null, null, secondsSinceEpoch, isVirtualHost);
    }

    public String createSignedGetUrl(String bucketName, String objectKey, Date expiryTime) throws S3ServiceException {
        return this.createSignedGetUrl(bucketName, objectKey, expiryTime, false);
    }

    public String createSignedPutUrl(String bucketName, String objectKey, Map<String, Object> headersMap, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return this.createSignedUrl("PUT", bucketName, objectKey, null, headersMap, secondsSinceEpoch, isVirtualHost);
    }

    public String createSignedPutUrl(String bucketName, String objectKey, Map<String, Object> headersMap, Date expiryTime) throws S3ServiceException {
        return this.createSignedPutUrl(bucketName, objectKey, headersMap, expiryTime, false);
    }

    public String createSignedDeleteUrl(String bucketName, String objectKey, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return this.createSignedUrl("DELETE", bucketName, objectKey, null, null, secondsSinceEpoch, isVirtualHost);
    }

    public String createSignedDeleteUrl(String bucketName, String objectKey, Date expiryTime) throws S3ServiceException {
        return this.createSignedDeleteUrl(bucketName, objectKey, expiryTime, false);
    }

    public String createSignedHeadUrl(String bucketName, String objectKey, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return this.createSignedUrl("HEAD", bucketName, objectKey, null, null, secondsSinceEpoch, isVirtualHost);
    }

    public String createSignedHeadUrl(String bucketName, String objectKey, Date expiryTime) throws S3ServiceException {
        return this.createSignedHeadUrl(bucketName, objectKey, expiryTime, false);
    }

    @Deprecated
    public static String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map<String, Object> headersMap, ProviderCredentials credentials, long secondsSinceEpoch, boolean isVirtualHost, boolean isHttps, boolean isDnsBucketNamingDisabled) throws S3ServiceException {
        RestS3Service s3Service = new RestS3Service(credentials);
        return s3Service.createSignedUrl(method, bucketName, objectKey, specialParamName, headersMap, secondsSinceEpoch, isVirtualHost, isHttps, isDnsBucketNamingDisabled);
    }

    @Deprecated
    public String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map<String, Object> headersMap, ProviderCredentials credentials, long secondsSinceEpoch, boolean isVirtualHost) throws S3ServiceException {
        boolean isHttps = this.getHttpsOnly();
        boolean disableDnsBuckets = this.getDisableDnsBuckets();
        return S3Service.createSignedUrl(method, bucketName, objectKey, specialParamName, headersMap, credentials, secondsSinceEpoch, isVirtualHost, isHttps, disableDnsBuckets);
    }

    @Deprecated
    public String createSignedUrl(String method, String bucketName, String objectKey, String specialParamName, Map<String, Object> headersMap, ProviderCredentials credentials, long secondsSinceEpoch) throws S3ServiceException {
        return this.createSignedUrl(method, bucketName, objectKey, specialParamName, headersMap, credentials, secondsSinceEpoch, false);
    }

    @Deprecated
    public String createSignedGetUrl(String bucketName, String objectKey, ProviderCredentials credentials, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return this.createSignedUrl("GET", bucketName, objectKey, null, null, credentials, secondsSinceEpoch, isVirtualHost);
    }

    @Deprecated
    public String createSignedGetUrl(String bucketName, String objectKey, ProviderCredentials credentials, Date expiryTime) throws S3ServiceException {
        return this.createSignedGetUrl(bucketName, objectKey, credentials, expiryTime, false);
    }

    @Deprecated
    public String createSignedPutUrl(String bucketName, String objectKey, Map<String, Object> headersMap, ProviderCredentials credentials, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return this.createSignedUrl("PUT", bucketName, objectKey, null, headersMap, credentials, secondsSinceEpoch, isVirtualHost);
    }

    @Deprecated
    public String createSignedPutUrl(String bucketName, String objectKey, Map<String, Object> headersMap, ProviderCredentials credentials, Date expiryTime) throws S3ServiceException {
        return this.createSignedPutUrl(bucketName, objectKey, headersMap, credentials, expiryTime, false);
    }

    @Deprecated
    public String createSignedDeleteUrl(String bucketName, String objectKey, ProviderCredentials credentials, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return this.createSignedUrl("DELETE", bucketName, objectKey, null, null, credentials, secondsSinceEpoch, isVirtualHost);
    }

    @Deprecated
    public String createSignedDeleteUrl(String bucketName, String objectKey, ProviderCredentials credentials, Date expiryTime) throws S3ServiceException {
        return this.createSignedDeleteUrl(bucketName, objectKey, credentials, expiryTime, false);
    }

    @Deprecated
    public String createSignedHeadUrl(String bucketName, String objectKey, ProviderCredentials credentials, Date expiryTime, boolean isVirtualHost) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return this.createSignedUrl("HEAD", bucketName, objectKey, null, null, credentials, secondsSinceEpoch, isVirtualHost);
    }

    @Deprecated
    public String createSignedHeadUrl(String bucketName, String objectKey, ProviderCredentials credentials, Date expiryTime) throws S3ServiceException {
        return this.createSignedHeadUrl(bucketName, objectKey, credentials, expiryTime, false);
    }

    public String createTorrentUrl(String bucketName, String objectKey) {
        String s3Endpoint = this.getEndpoint();
        String serviceEndpointVirtualPath = this.getVirtualPath();
        int httpPort = this.getHttpPort();
        boolean disableDnsBuckets = this.getDisableDnsBuckets();
        try {
            String bucketNameInPath = !disableDnsBuckets && ServiceUtils.isBucketNameValidDNSName(bucketName) ? "" : RestUtils.encodeUrlString(bucketName) + "/";
            String urlPath = RestUtils.encodeUrlPath(serviceEndpointVirtualPath, "/") + "/" + bucketNameInPath + RestUtils.encodeUrlPath(objectKey, "/");
            return "http://" + ServiceUtils.generateS3HostnameForBucket(bucketName, disableDnsBuckets, s3Endpoint) + (httpPort != 80 ? ":" + httpPort : "") + urlPath + "?torrent";
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public static String generatePostPolicyCondition(String operation, String name, String value) {
        return "[\"" + operation + "\", \"$" + name + "\", \"" + value + "\"]";
    }

    public static String generatePostPolicyCondition_AllowAnyValue(String name) {
        return "[\"starts-with\", \"$" + name + "\", \"\"]";
    }

    public static String generatePostPolicyCondition_Equality(String name, String value) {
        return "{\"" + name + "\": \"" + value + "\"}";
    }

    public static String generatePostPolicyCondition_Equality(String name, String[] values) {
        return "{\"" + name + "\": \"" + ServiceUtils.join(values, ",") + "\"}";
    }

    public static String generatePostPolicyCondition_Equality(String name, List<String> values) {
        return "{\"" + name + "\": \"" + ServiceUtils.join(values, ",") + "\"}";
    }

    public static String generatePostPolicyCondition_Range(int min, int max) {
        return "[\"content-length-range\", " + min + ", " + max + "]";
    }

    public static String buildPostForm(String bucketName, String key) throws S3ServiceException, UnsupportedEncodingException {
        return S3Service.buildPostForm(bucketName, key, null, null, null, null, null, true);
    }

    public static String buildPostForm(String bucketName, String key, ProviderCredentials credentials, Date expiration, String[] conditions, String[] inputFields, String textInput, boolean isSecureHttp) throws S3ServiceException, UnsupportedEncodingException {
        return S3Service.buildPostForm(bucketName, key, credentials, expiration, conditions, inputFields, textInput, isSecureHttp, false, "Upload to Amazon S3");
    }

    public static String buildPostForm(String bucketName, String key, ProviderCredentials credentials, Date expiration, String[] conditions, String[] inputFields, String textInput, boolean isSecureHttp, boolean usePathStyleUrl, String submitButtonName) throws S3ServiceException, UnsupportedEncodingException {
        ArrayList<String> myInputFields = new ArrayList<String>();
        if (expiration != null || conditions != null) {
            String signature;
            String policyDocument = "{\"expiration\": \"" + ServiceUtils.formatIso8601Date(expiration) + "\", \"conditions\": [" + ServiceUtils.join(conditions, ",") + "]}";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy document for POST form:\n" + policyDocument));
            }
            String policyB64 = ServiceUtils.toBase64(policyDocument.getBytes(Constants.DEFAULT_ENCODING));
            myInputFields.add("<input type=\"hidden\" name=\"policy\" value=\"" + policyB64 + "\">");
            myInputFields.add("<input type=\"hidden\" name=\"AWSAccessKeyId\" value=\"" + credentials.getAccessKey() + "\">");
            try {
                signature = ServiceUtils.signWithHmacSha1(credentials.getSecretKey(), policyB64);
            }
            catch (ServiceException se) {
                throw new S3ServiceException(se);
            }
            myInputFields.add("<input type=\"hidden\" name=\"signature\" value=\"" + signature + "\">");
        }
        if (inputFields != null) {
            myInputFields.addAll(Arrays.asList(inputFields));
        }
        if (textInput != null) {
            myInputFields.add(textInput);
        } else {
            myInputFields.add("<input name=\"file\" type=\"file\">");
        }
        String url = null;
        url = usePathStyleUrl ? "http" + (isSecureHttp ? "s" : "") + "://s3.amazonaws.com/" + bucketName : "http" + (isSecureHttp ? "s" : "") + "://" + bucketName + ".s3.amazonaws.com/";
        String form = "<form action=\"" + url + "\" method=\"post\" " + "enctype=\"multipart/form-data\">\n" + "<input type=\"hidden\" name=\"key\" value=\"" + key + "\">\n" + ServiceUtils.join(myInputFields, "\n") + "\n<br>\n" + "<input type=\"submit\" value=\"" + submitButtonName + "\">\n" + "</form>";
        if (log.isDebugEnabled()) {
            log.debug((Object)("POST Form:\n" + form));
        }
        return form;
    }

    public S3Bucket[] listAllBuckets() throws S3ServiceException {
        try {
            StorageBucket[] buckets = super.listAllBuckets();
            return S3Bucket.cast(buckets);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    public S3Object getObject(String bucketName, String objectKey) throws S3ServiceException {
        try {
            return (S3Object)super.getObject(bucketName, objectKey);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Deprecated
    public S3Object[] listObjects(S3Bucket bucket) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "listObjects");
            return this.listObjects(bucket, null, null, 1000L);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object[] listObjects(String bucketName) throws S3ServiceException {
        try {
            return S3Object.cast(super.listObjects(bucketName));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object[] listObjects(String bucketName, String prefix, String delimiter, long maxListingLength) throws S3ServiceException {
        try {
            return S3Object.cast(super.listObjects(bucketName, prefix, delimiter, maxListingLength));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Deprecated
    public S3Object[] listObjects(S3Bucket bucket, String prefix, String delimiter) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "listObjects");
            return this.listObjects(bucket, prefix, delimiter, 1000L);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object[] listObjects(String bucketName, String prefix, String delimiter) throws S3ServiceException {
        try {
            return S3Object.cast(super.listObjects(bucketName, prefix, delimiter));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    public S3Bucket createBucket(String bucketName) throws S3ServiceException {
        try {
            return this.createBucket(bucketName, this.jets3tProperties.getStringProperty("s3service.default-bucket-location", "US"), null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    public S3Bucket getOrCreateBucket(String bucketName) throws S3ServiceException {
        try {
            return this.getOrCreateBucket(bucketName, this.jets3tProperties.getStringProperty("s3service.default-bucket-location", "US"));
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Bucket createBucket(String bucketName, String location, AccessControlList acl) throws S3ServiceException {
        try {
            this.assertAuthenticatedConnection("createBucket");
            return (S3Bucket)this.createBucketImpl(bucketName, location, acl);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Bucket createBucket(String bucketName, String location) throws S3ServiceException {
        try {
            this.assertAuthenticatedConnection("createBucket");
            return (S3Bucket)this.createBucketImpl(bucketName, location, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Deprecated
    public S3Object getObject(S3Bucket bucket, String objectKey) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "getObject");
            return this.getObject(bucket, objectKey, null, null, null, null, null, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object getVersionedObject(String versionId, String bucketName, String objectKey) throws S3ServiceException {
        try {
            MxDelegate.getInstance().registerStorageObjectGetEvent(bucketName, objectKey);
            return (S3Object)this.getObjectImpl(bucketName, objectKey, null, null, null, null, null, null, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Deprecated
    public S3Object getObjectDetails(S3Bucket bucket, String objectKey) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "getObjectDetails");
            return this.getObjectDetails(bucket, objectKey, null, null, null, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object getVersionedObjectDetails(String versionId, String bucketName, String objectKey) throws S3ServiceException {
        try {
            MxDelegate.getInstance().registerStorageObjectHeadEvent(bucketName, objectKey);
            return (S3Object)this.getObjectDetailsImpl(bucketName, objectKey, null, null, null, null, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Deprecated
    public S3Object[] listObjects(S3Bucket bucket, String prefix, String delimiter, long maxListingLength) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "List objects in bucket");
            return this.listObjects(bucket.getName(), prefix, delimiter, maxListingLength);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public BaseVersionOrDeleteMarker[] listVersionedObjects(String bucketName, String prefix, String delimiter) throws S3ServiceException {
        return this.listVersionedObjectsImpl(bucketName, prefix, delimiter, null, null, 1000L);
    }

    public BaseVersionOrDeleteMarker[] getObjectVersions(String bucketName, String objectKey) throws S3ServiceException {
        BaseVersionOrDeleteMarker[] matchesForNamePrefix = this.listVersionedObjectsImpl(bucketName, objectKey, null, null, null, 1000L);
        int exactMatchCount = 0;
        for (int i = 0; i < matchesForNamePrefix.length && i <= exactMatchCount; ++i) {
            if (!matchesForNamePrefix[i].getKey().equals(objectKey)) continue;
            ++exactMatchCount;
        }
        BaseVersionOrDeleteMarker[] exactMatches = new BaseVersionOrDeleteMarker[exactMatchCount];
        System.arraycopy(matchesForNamePrefix, 0, exactMatches, 0, exactMatchCount);
        return exactMatches;
    }

    public VersionOrDeleteMarkersChunk listVersionedObjectsChunked(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, String priorLastVersionId, boolean completeListing) throws S3ServiceException {
        return this.listVersionedObjectsChunkedImpl(bucketName, prefix, delimiter, maxListingLength, priorLastKey, priorLastVersionId, completeListing);
    }

    public S3Bucket createBucket(S3Bucket bucket) throws S3ServiceException {
        try {
            this.assertAuthenticatedConnection("Create Bucket");
            this.assertValidBucket(bucket, "Create Bucket");
            return (S3Bucket)this.createBucketImpl(bucket.getName(), bucket.getLocation(), bucket.getAcl());
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    public S3Bucket getBucket(String bucketName) throws S3ServiceException {
        try {
            return (S3Bucket)super.getBucket(bucketName);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Bucket getOrCreateBucket(String bucketName, String location) throws S3ServiceException {
        try {
            this.assertAuthenticatedConnection("Get or Create Bucket with location");
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
        S3Bucket bucket = this.getBucket(bucketName);
        if (bucket == null) {
            bucket = this.createBucket(new S3Bucket(bucketName, location));
        }
        return bucket;
    }

    @Deprecated
    public void deleteBucket(S3Bucket bucket) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Delete bucket");
            this.deleteBucketImpl(bucket.getName());
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void enableBucketVersioning(String bucketName) throws S3ServiceException {
        this.updateBucketVersioningStatusImpl(bucketName, true, false, null, null);
    }

    public void enableBucketVersioningAndMFA(String bucketName) throws S3ServiceException {
        this.updateBucketVersioningStatusImpl(bucketName, true, true, null, null);
    }

    public void enableBucketVersioningWithMFA(String bucketName, String multiFactorSerialNumber, String multiFactorAuthCode) throws S3ServiceException {
        this.updateBucketVersioningStatusImpl(bucketName, true, true, multiFactorSerialNumber, multiFactorAuthCode);
    }

    public void disableMFAForVersionedBucket(String bucketName, String multiFactorSerialNumber, String multiFactorAuthCode) throws S3ServiceException {
        this.updateBucketVersioningStatusImpl(bucketName, true, false, multiFactorSerialNumber, multiFactorAuthCode);
    }

    public void suspendBucketVersioning(String bucketName) throws S3ServiceException {
        this.updateBucketVersioningStatusImpl(bucketName, false, false, null, null);
    }

    public void suspendBucketVersioningWithMFA(String bucketName, String multiFactorSerialNumber, String multiFactorAuthCode) throws S3ServiceException {
        this.updateBucketVersioningStatusImpl(bucketName, false, false, multiFactorSerialNumber, multiFactorAuthCode);
    }

    public S3BucketVersioningStatus getBucketVersioningStatus(String bucketName) throws S3ServiceException {
        return this.getBucketVersioningStatusImpl(bucketName);
    }

    public S3Object putObject(String bucketName, S3Object object) throws S3ServiceException {
        try {
            return (S3Object)super.putObject(bucketName, object);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public Map<String, Object> copyVersionedObject(String versionId, String sourceBucketName, String sourceObjectKey, String destinationBucketName, S3Object destinationObject, boolean replaceMetadata, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        try {
            this.assertAuthenticatedConnection("copyVersionedObject");
            Map<String, Object> destinationMetadata = replaceMetadata ? destinationObject.getModifiableMetadata() : null;
            MxDelegate.getInstance().registerStorageObjectCopyEvent(sourceBucketName, sourceObjectKey);
            return this.copyObjectImpl(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject.getKey(), destinationObject.getAcl(), destinationMetadata, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, versionId, destinationObject.getStorageClass(), destinationObject.getServerSideEncryptionAlgorithm());
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public Map<String, Object> copyVersionedObject(String versionId, String sourceBucketName, String sourceObjectKey, String destinationBucketName, S3Object destinationObject, boolean replaceMetadata) throws S3ServiceException {
        return this.copyVersionedObject(versionId, sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject, replaceMetadata, null, null, null, null);
    }

    public S3Object putObject(S3Bucket bucket, S3Object object) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Create Object in bucket");
            return this.putObject(bucket.getName(), object);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void deleteObject(S3Bucket bucket, String objectKey) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "deleteObject");
            this.assertValidObject(objectKey, "deleteObject");
            this.deleteObject(bucket.getName(), objectKey);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void deleteVersionedObjectWithMFA(String versionId, String multiFactorSerialNumber, String multiFactorAuthCode, String bucketName, String objectKey) throws S3ServiceException {
        try {
            this.assertValidObject(objectKey, "deleteVersionedObjectWithMFA");
            MxDelegate.getInstance().registerStorageObjectDeleteEvent(bucketName, objectKey);
            this.deleteObjectImpl(bucketName, objectKey, versionId, multiFactorSerialNumber, multiFactorAuthCode);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void deleteVersionedObject(String versionId, String bucketName, String objectKey) throws S3ServiceException {
        try {
            this.assertValidObject(objectKey, "deleteVersionedObject");
            MxDelegate.getInstance().registerStorageObjectDeleteEvent(bucketName, objectKey);
            this.deleteObjectImpl(bucketName, objectKey, versionId, null, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public MultipleDeleteResult deleteMultipleObjects(String bucketName, String[] keys) throws S3ServiceException {
        ObjectKeyAndVersion[] objectKeyAndVersion = new ObjectKeyAndVersion[keys.length];
        int i = 0;
        for (String key : keys) {
            objectKeyAndVersion[i++] = new ObjectKeyAndVersion(key);
        }
        return this.deleteMultipleObjects(bucketName, objectKeyAndVersion, false);
    }

    public MultipleDeleteResult deleteMultipleObjects(String bucketName, ObjectKeyAndVersion[] objectNameAndVersions) throws S3ServiceException {
        return this.deleteMultipleObjects(bucketName, objectNameAndVersions, false);
    }

    public MultipleDeleteResult deleteMultipleObjects(String bucketName, ObjectKeyAndVersion[] objectNameAndVersions, boolean isQuiet) throws S3ServiceException {
        return this.deleteMultipleObjectsWithMFA(bucketName, objectNameAndVersions, null, null, isQuiet);
    }

    public MultipleDeleteResult deleteMultipleObjectsWithMFA(String bucketName, ObjectKeyAndVersion[] objectNameAndVersions, String multiFactorSerialNumber, String multiFactorAuthCode, boolean isQuiet) throws S3ServiceException {
        return this.deleteMultipleObjectsWithMFAImpl(bucketName, objectNameAndVersions, multiFactorSerialNumber, multiFactorAuthCode, isQuiet);
    }

    public S3Object getObjectDetails(S3Bucket bucket, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Get Object Details");
            MxDelegate.getInstance().registerStorageObjectHeadEvent(bucket.getName(), objectKey);
            return (S3Object)this.getObjectDetailsImpl(bucket.getName(), objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object getVersionedObjectDetails(String versionId, S3Bucket bucket, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Get Versioned Object Details");
            MxDelegate.getInstance().registerStorageObjectHeadEvent(bucket.getName(), objectKey);
            return (S3Object)this.getObjectDetailsImpl(bucket.getName(), objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object getVersionedObjectDetails(String versionId, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        try {
            MxDelegate.getInstance().registerStorageObjectHeadEvent(bucketName, objectKey);
            return (S3Object)this.getObjectDetailsImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    @Override
    public S3Object getObject(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        try {
            return (S3Object)super.getObject(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object getObject(S3Bucket bucket, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Get Object");
            MxDelegate.getInstance().registerStorageObjectGetEvent(bucket.getName(), objectKey);
            return (S3Object)this.getObjectImpl(bucket.getName(), objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object getVersionedObject(String versionId, S3Bucket bucket, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Get Versioned Object");
            MxDelegate.getInstance().registerStorageObjectGetEvent(bucket.getName(), objectKey);
            return (S3Object)this.getObjectImpl(bucket.getName(), objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3Object getVersionedObject(String versionId, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        try {
            MxDelegate.getInstance().registerStorageObjectGetEvent(bucketName, objectKey);
            return (S3Object)this.getObjectImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void putObjectAcl(S3Bucket bucket, S3Object object) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Put Object Access Control List");
            this.assertValidObject(object, "Put Object Access Control List");
            this.putObjectAcl(bucket.getName(), object.getKey(), object.getAcl());
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void putObjectAcl(String bucketName, S3Object object) throws S3ServiceException {
        try {
            this.assertValidObject(object, "Put Object Access Control List");
            this.putObjectAcl(bucketName, object.getKey(), object.getAcl());
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void putVersionedObjectAcl(String versionId, String bucketName, String objectKey, AccessControlList acl) throws S3ServiceException {
        try {
            this.putObjectAclImpl(bucketName, objectKey, acl, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void putVersionedObjectAcl(String versionId, S3Bucket bucket, S3Object object) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Put Versioned Object Access Control List");
            this.assertValidObject(object, "Put Versioned Object Access Control List");
            String objectKey = object.getKey();
            AccessControlList acl = object.getAcl();
            if (acl == null) {
                throw new S3ServiceException("The object '" + objectKey + "' does not include ACL information");
            }
            this.putObjectAclImpl(bucket.getName(), objectKey, acl, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public AccessControlList getObjectAcl(S3Bucket bucket, String objectKey) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Get Object Access Control List");
            return this.getObjectAclImpl(bucket.getName(), objectKey, null);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public AccessControlList getVersionedObjectAcl(String versionId, S3Bucket bucket, String objectKey) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Get versioned Object Access Control List");
            return this.getObjectAclImpl(bucket.getName(), objectKey, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public AccessControlList getVersionedObjectAcl(String versionId, String bucketName, String objectKey) throws S3ServiceException {
        try {
            return this.getObjectAclImpl(bucketName, objectKey, versionId);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public AccessControlList getBucketAcl(S3Bucket bucket) throws S3ServiceException {
        try {
            this.assertValidBucket(bucket, "Get Bucket Access Control List");
            return this.getBucketAclImpl(bucket.getName());
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public String getBucketLocation(String bucketName) throws S3ServiceException {
        try {
            return this.getBucketLocationImpl(bucketName);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public S3BucketLoggingStatus getBucketLoggingStatus(String bucketName) throws S3ServiceException {
        try {
            return (S3BucketLoggingStatus)this.getBucketLoggingStatusImpl(bucketName);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void setBucketLoggingStatus(String bucketName, S3BucketLoggingStatus status, boolean updateTargetACLifRequired) throws S3ServiceException {
        try {
            if (status.isLoggingEnabled() && updateTargetACLifRequired) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking whether the target logging bucket '" + status.getTargetBucketName() + "' has the appropriate ACL settings"));
                }
                boolean isSetLoggingGroupWrite = false;
                boolean isSetLoggingGroupReadACP = false;
                String groupIdentifier = GroupGrantee.LOG_DELIVERY.getIdentifier();
                AccessControlList logBucketACL = this.getBucketAcl(status.getTargetBucketName());
                for (GrantAndPermission gap : logBucketACL.getGrantAndPermissions()) {
                    if (!groupIdentifier.equals(gap.getGrantee().getIdentifier())) continue;
                    if (gap.getPermission().equals(Permission.PERMISSION_WRITE)) {
                        isSetLoggingGroupWrite = true;
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Target bucket '" + status.getTargetBucketName() + "' has ACL " + "permission " + Permission.PERMISSION_WRITE + " for group " + groupIdentifier));
                        continue;
                    }
                    if (!gap.getPermission().equals(Permission.PERMISSION_READ_ACP)) continue;
                    isSetLoggingGroupReadACP = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Target bucket '" + status.getTargetBucketName() + "' has ACL " + "permission " + Permission.PERMISSION_READ_ACP + " for group " + groupIdentifier));
                }
                if (!isSetLoggingGroupWrite || !isSetLoggingGroupReadACP) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Target logging bucket '" + status.getTargetBucketName() + "' does not have the necessary ACL settings, updating ACL now"));
                    }
                    logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_WRITE);
                    logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_READ_ACP);
                    this.putBucketAcl(status.getTargetBucketName(), logBucketACL);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Target logging bucket '" + status.getTargetBucketName() + "' has the necessary ACL settings"));
                }
            }
            this.setBucketLoggingStatusImpl(bucketName, status);
        }
        catch (ServiceException se) {
            throw new S3ServiceException(se);
        }
    }

    public void setBucketPolicy(String bucketName, String policyDocument) throws S3ServiceException {
        this.setBucketPolicyImpl(bucketName, policyDocument);
    }

    public String getBucketPolicy(String bucketName) throws S3ServiceException {
        try {
            return this.getBucketPolicyImpl(bucketName);
        }
        catch (S3ServiceException e) {
            if (e.getResponseCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public void deleteBucketPolicy(String bucketName) throws S3ServiceException {
        this.deleteBucketPolicyImpl(bucketName);
    }

    public boolean isRequesterPaysBucket(String bucketName) throws S3ServiceException {
        return this.isRequesterPaysBucketImpl(bucketName);
    }

    public void setRequesterPaysBucket(String bucketName, boolean requesterPays) throws S3ServiceException {
        this.setRequesterPaysBucketImpl(bucketName, requesterPays);
    }

    public void putObjectMaybeAsMultipart(String bucketName, StorageObject object, long maxPartSize) throws ServiceException {
        if (object.getDataInputFile() == null) {
            throw new ServiceException("multipartUpload method only supports file-based objects");
        }
        MultipartUtils multipartUtils = new MultipartUtils(maxPartSize);
        if (!multipartUtils.isFileLargerThanMaxPartSize(object.getDataInputFile())) {
            log.debug((Object)("Performing normal PUT upload for object with data <= " + maxPartSize));
            this.putObject(bucketName, object);
        } else {
            log.debug((Object)("Performing multipart upload for object with data > " + maxPartSize));
            MultipartUpload upload = this.multipartStartUpload(bucketName, object.getKey(), object.getMetadataMap(), object.getAcl(), object.getStorageClass());
            boolean foundUpload = false;
            int maxTries = 5;
            int tries = 0;
            do {
                try {
                    this.multipartListParts(upload);
                    foundUpload = true;
                }
                catch (S3ServiceException e) {
                    if ("NoSuchUpload".equals(e.getErrorCode())) {
                        ++tries;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            tries = maxTries;
                        }
                        continue;
                    }
                    throw e;
                }
            } while (!foundUpload && tries < maxTries);
            if (!foundUpload) {
                throw new ServiceException("Multipart upload was started but unavailable for use after " + tries + " attempts, giving up");
            }
            try {
                List<S3Object> partObjects = multipartUtils.splitFileIntoObjectsByMaxPartSize(object.getKey(), object.getDataInputFile());
                ArrayList<MultipartPart> parts = new ArrayList<MultipartPart>();
                int partNumber = 1;
                for (S3Object partObject : partObjects) {
                    MultipartPart part = this.multipartUploadPart(upload, partNumber, partObject);
                    parts.add(part);
                    ++partNumber;
                }
                this.multipartCompleteUpload(upload, parts);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn((Object)"Multipart upload failed, attempting clean-up by aborting upload", (Throwable)e);
                try {
                    this.multipartAbortUpload(upload);
                }
                catch (S3ServiceException e2) {
                    log.warn((Object)"Multipart upload failed and could not clean-up by aborting upload", (Throwable)e2);
                }
                if (e instanceof ServiceException) {
                    throw (ServiceException)e;
                }
                throw new ServiceException("Multipart upload failed", e);
            }
        }
    }

    public MultipartUpload multipartStartUpload(String bucketName, String objectKey, Map<String, Object> metadata) throws S3ServiceException {
        return this.multipartStartUpload(bucketName, objectKey, metadata, null, null);
    }

    public MultipartUpload multipartStartUpload(String bucketName, String objectKey, Map<String, Object> metadata, AccessControlList acl, String storageClass) throws S3ServiceException {
        return this.multipartStartUploadImpl(bucketName, objectKey, metadata, acl, storageClass, null);
    }

    public MultipartUpload multipartStartUpload(String bucketName, S3Object object) throws S3ServiceException {
        return this.multipartStartUploadImpl(bucketName, object.getKey(), object.getMetadataMap(), object.getAcl(), object.getStorageClass(), object.getServerSideEncryptionAlgorithm());
    }

    public void multipartAbortUpload(MultipartUpload upload) throws S3ServiceException {
        this.multipartAbortUploadImpl(upload.getUploadId(), upload.getBucketName(), upload.getObjectKey());
    }

    public List<MultipartUpload> multipartListUploads(String bucketName) throws S3ServiceException {
        return this.multipartListUploads(bucketName, null, null, null, null, null);
    }

    public List<MultipartUpload> multipartListUploads(String bucketName, String nextKeyMarker, String nextUploadIdMarker, Integer maxUploads) throws S3ServiceException {
        return this.multipartListUploads(bucketName, null, null, nextKeyMarker, nextUploadIdMarker, maxUploads);
    }

    public List<MultipartUpload> multipartListUploads(String bucketName, String prefix, String delimiter, String nextKeyMarker, String nextUploadIdMarker, Integer maxUploads) throws S3ServiceException {
        MultipartUploadChunk result = this.multipartListUploadsChunkedImpl(bucketName, prefix, delimiter, nextKeyMarker, nextUploadIdMarker, maxUploads, true);
        return Arrays.asList(result.getUploads());
    }

    public MultipartUploadChunk multipartListUploadsChunked(String bucketName, String prefix, String delimiter, String keyMarker, String uploadIdMarker, Integer maxUploads, boolean completeListing) throws S3ServiceException {
        return this.multipartListUploadsChunkedImpl(bucketName, prefix, delimiter, keyMarker, uploadIdMarker, maxUploads, completeListing);
    }

    public List<MultipartPart> multipartListParts(MultipartUpload upload) throws S3ServiceException {
        return this.multipartListPartsImpl(upload.getUploadId(), upload.getBucketName(), upload.getObjectKey());
    }

    public MultipartCompleted multipartCompleteUpload(MultipartUpload upload, List<MultipartPart> parts) throws S3ServiceException {
        return this.multipartCompleteUploadImpl(upload.getUploadId(), upload.getBucketName(), upload.getObjectKey(), parts);
    }

    public MultipartCompleted multipartCompleteUpload(MultipartUpload upload) throws S3ServiceException {
        List<MultipartPart> parts = this.multipartListParts(upload);
        return this.multipartCompleteUploadImpl(upload.getUploadId(), upload.getBucketName(), upload.getObjectKey(), parts);
    }

    public MultipartPart multipartUploadPart(MultipartUpload upload, Integer partNumber, S3Object object) throws S3ServiceException {
        MultipartPart part = this.multipartUploadPartImpl(upload.getUploadId(), upload.getBucketName(), partNumber, object);
        upload.addMultipartPartToUploadedList(part);
        return part;
    }

    public MultipartPart multipartUploadPartCopy(MultipartUpload upload, Integer partNumber, String sourceBucketName, String sourceObjectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId) throws S3ServiceException {
        MultipartPart part = this.multipartUploadPartCopyImpl(upload.getUploadId(), upload.getBucketName(), upload.getObjectKey(), partNumber, sourceBucketName, sourceObjectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, versionId);
        upload.addMultipartPartToUploadedList(part);
        return part;
    }

    public MultipartPart multipartUploadPartCopy(MultipartUpload upload, Integer partNumber, String sourceBucketName, String sourceObjectKey, String versionId) throws S3ServiceException {
        MultipartPart part = this.multipartUploadPartCopyImpl(upload.getUploadId(), upload.getBucketName(), upload.getObjectKey(), partNumber, sourceBucketName, sourceObjectKey, null, null, null, null, null, null, versionId);
        upload.addMultipartPartToUploadedList(part);
        return part;
    }

    public MultipartPart multipartUploadPartCopy(MultipartUpload upload, Integer partNumber, String sourceBucketName, String sourceObjectKey) throws S3ServiceException {
        MultipartPart part = this.multipartUploadPartCopyImpl(upload.getUploadId(), upload.getBucketName(), upload.getObjectKey(), partNumber, sourceBucketName, sourceObjectKey, null, null, null, null, null, null, null);
        upload.addMultipartPartToUploadedList(part);
        return part;
    }

    public void setWebsiteConfig(String bucketName, WebsiteConfig config) throws S3ServiceException {
        this.setWebsiteConfigImpl(bucketName, config);
    }

    public WebsiteConfig getWebsiteConfig(String bucketName) throws S3ServiceException {
        return this.getWebsiteConfigImpl(bucketName);
    }

    public void deleteWebsiteConfig(String bucketName) throws S3ServiceException {
        this.deleteWebsiteConfigImpl(bucketName);
    }

    public void setNotificationConfig(String bucketName, NotificationConfig config) throws S3ServiceException {
        this.setNotificationConfigImpl(bucketName, config);
    }

    public NotificationConfig getNotificationConfig(String bucketName) throws S3ServiceException {
        return this.getNotificationConfigImpl(bucketName);
    }

    public void unsetNotificationConfig(String bucketName) throws S3ServiceException {
        this.setNotificationConfigImpl(bucketName, new NotificationConfig());
    }

    protected abstract void setBucketPolicyImpl(String var1, String var2) throws S3ServiceException;

    protected abstract String getBucketPolicyImpl(String var1) throws S3ServiceException;

    protected abstract void deleteBucketPolicyImpl(String var1) throws S3ServiceException;

    protected abstract void setRequesterPaysBucketImpl(String var1, boolean var2) throws S3ServiceException;

    protected abstract boolean isRequesterPaysBucketImpl(String var1) throws S3ServiceException;

    protected abstract BaseVersionOrDeleteMarker[] listVersionedObjectsImpl(String var1, String var2, String var3, String var4, String var5, long var6) throws S3ServiceException;

    protected abstract VersionOrDeleteMarkersChunk listVersionedObjectsChunkedImpl(String var1, String var2, String var3, long var4, String var6, String var7, boolean var8) throws S3ServiceException;

    protected abstract void updateBucketVersioningStatusImpl(String var1, boolean var2, boolean var3, String var4, String var5) throws S3ServiceException;

    protected abstract S3BucketVersioningStatus getBucketVersioningStatusImpl(String var1) throws S3ServiceException;

    protected abstract MultipartUpload multipartStartUploadImpl(String var1, String var2, Map<String, Object> var3, AccessControlList var4, String var5, String var6) throws S3ServiceException;

    protected abstract void multipartAbortUploadImpl(String var1, String var2, String var3) throws S3ServiceException;

    protected abstract MultipartUploadChunk multipartListUploadsChunkedImpl(String var1, String var2, String var3, String var4, String var5, Integer var6, boolean var7) throws S3ServiceException;

    protected abstract List<MultipartPart> multipartListPartsImpl(String var1, String var2, String var3) throws S3ServiceException;

    protected abstract MultipartCompleted multipartCompleteUploadImpl(String var1, String var2, String var3, List<MultipartPart> var4) throws S3ServiceException;

    protected abstract MultipartPart multipartUploadPartImpl(String var1, String var2, Integer var3, S3Object var4) throws S3ServiceException;

    protected abstract MultipartPart multipartUploadPartCopyImpl(String var1, String var2, String var3, Integer var4, String var5, String var6, Calendar var7, Calendar var8, String[] var9, String[] var10, Long var11, Long var12, String var13) throws S3ServiceException;

    protected abstract void setWebsiteConfigImpl(String var1, WebsiteConfig var2) throws S3ServiceException;

    protected abstract WebsiteConfig getWebsiteConfigImpl(String var1) throws S3ServiceException;

    protected abstract void deleteWebsiteConfigImpl(String var1) throws S3ServiceException;

    protected abstract void setNotificationConfigImpl(String var1, NotificationConfig var2) throws S3ServiceException;

    protected abstract NotificationConfig getNotificationConfigImpl(String var1) throws S3ServiceException;

    public abstract MultipleDeleteResult deleteMultipleObjectsWithMFAImpl(String var1, ObjectKeyAndVersion[] var2, String var3, String var4, boolean var5) throws S3ServiceException;
}

