/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hbase;

import java.util.Arrays;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.serializer.BinarySerializer;
import org.apache.hugegraph.backend.store.hbase.HbaseOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class HbaseSerializer
extends BinarySerializer {
    private static final Logger LOG = Log.logger(HbaseSerializer.class);
    private final short vertexLogicPartitions;
    private final short edgeLogicPartitions;

    public HbaseSerializer(HugeConfig config) {
        super(false, true, ((Boolean)config.get(HbaseOptions.HBASE_ENABLE_PARTITION)).booleanValue());
        this.vertexLogicPartitions = ((Integer)config.get(HbaseOptions.HBASE_VERTEX_PARTITION)).shortValue();
        this.edgeLogicPartitions = ((Integer)config.get(HbaseOptions.HBASE_EDGE_PARTITION)).shortValue();
        LOG.debug("vertexLogicPartitions: " + this.vertexLogicPartitions);
    }

    protected short getPartition(HugeType type, Id id) {
        int hashcode = Arrays.hashCode(id.asBytes());
        short partition = 1;
        if (type.isEdge()) {
            partition = (short)(hashcode % this.edgeLogicPartitions);
        } else if (type.isVertex()) {
            partition = (short)(hashcode % this.vertexLogicPartitions);
        }
        return partition > 0 ? partition : (short)(-partition);
    }
}

