/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition.arrimpl;

import java.util.HashSet;
import java.util.Set;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.recognition.TermArrRecognition;
import org.ansj.util.Graph;
import org.ansj.util.TermUtil;

public class NumRecognition
implements TermArrRecognition {
    public static final Set<Character> j_NUM = new HashSet<Character>();
    public static final Set<Character> f_NUM = new HashSet<Character>();
    private boolean quantifierRecognition;

    public NumRecognition(boolean quantifierRecognition) {
        this.quantifierRecognition = quantifierRecognition;
    }

    @Override
    public void recognition(Graph graph) {
        Term[] terms = graph.terms;
        int length = terms.length - 1;
        Term to = null;
        Term temp = null;
        for (int i = 0; i < length; ++i) {
            temp = terms[i];
            if (temp == null || !temp.termNatures().numAttr.isNum()) continue;
            if (temp.getName().length() == 1) {
                if (j_NUM.contains(Character.valueOf(temp.getName().charAt(0)))) {
                    to = temp.to();
                    while (to.getName().length() == 1 && j_NUM.contains(Character.valueOf(to.getName().charAt(0)))) {
                        temp.setName(temp.getName() + to.getName());
                        terms[to.getOffe()] = null;
                        TermUtil.termLink(temp, to.to());
                        to = to.to();
                    }
                }
                if (temp.getName().length() > 1) {
                    --i;
                    continue;
                }
                if (f_NUM.contains(Character.valueOf(temp.getName().charAt(0)))) {
                    to = temp.to();
                    while (to.getName().length() == 1 && f_NUM.contains(Character.valueOf(to.getName().charAt(0)))) {
                        temp.setName(temp.getName() + to.getName());
                        terms[to.getOffe()] = null;
                        TermUtil.termLink(temp, to.to());
                        to = to.to();
                    }
                }
                if (temp.getName().length() > 1) {
                    --i;
                    continue;
                }
            }
            if (temp.termNatures() == TermNatures.M_ALB && !temp.from().getName().equals(".") && temp.to().getName().equals(".") && temp.to().to().termNatures() == TermNatures.M_ALB && !temp.to().to().to().getName().equals(".")) {
                temp.setName(temp.getName() + temp.to().getName() + temp.to().to().getName());
                terms[temp.to().getOffe()] = null;
                terms[temp.to().to().getOffe()] = null;
                TermUtil.termLink(temp, temp.to().to().to());
                i = temp.getOffe() - 1;
            }
            if (!this.quantifierRecognition) continue;
            to = temp.to();
            if (!to.termNatures().numAttr.isQua()) continue;
            temp.setName(temp.getName() + to.getName());
            terms[to.getOffe()] = null;
            TermUtil.termLink(temp, to.to());
            temp.setNature(to.termNatures().numAttr.nature);
            i = "m".equals(to.termNatures().numAttr.nature.natureStr) ? temp.getOffe() - 1 : to.getOffe();
        }
    }

    static {
        j_NUM.add(Character.valueOf('\u96f6'));
        j_NUM.add(Character.valueOf('\u4e00'));
        j_NUM.add(Character.valueOf('\u4e24'));
        j_NUM.add(Character.valueOf('\u4e8c'));
        j_NUM.add(Character.valueOf('\u4e09'));
        j_NUM.add(Character.valueOf('\u56db'));
        j_NUM.add(Character.valueOf('\u4e94'));
        j_NUM.add(Character.valueOf('\u516d'));
        j_NUM.add(Character.valueOf('\u4e03'));
        j_NUM.add(Character.valueOf('\u516b'));
        j_NUM.add(Character.valueOf('\u4e5d'));
        j_NUM.add(Character.valueOf('\u5341'));
        j_NUM.add(Character.valueOf('\u767e'));
        j_NUM.add(Character.valueOf('\u5343'));
        j_NUM.add(Character.valueOf('\u4e07'));
        j_NUM.add(Character.valueOf('\u4ebf'));
        f_NUM.add(Character.valueOf('\u96f6'));
        f_NUM.add(Character.valueOf('\u58f9'));
        f_NUM.add(Character.valueOf('\u8d30'));
        f_NUM.add(Character.valueOf('\u53c1'));
        f_NUM.add(Character.valueOf('\u8086'));
        f_NUM.add(Character.valueOf('\u4f0d'));
        f_NUM.add(Character.valueOf('\u9646'));
        f_NUM.add(Character.valueOf('\u67d2'));
        f_NUM.add(Character.valueOf('\u634c'));
        f_NUM.add(Character.valueOf('\u7396'));
        f_NUM.add(Character.valueOf('\u62fe'));
        f_NUM.add(Character.valueOf('\u4f70'));
        f_NUM.add(Character.valueOf('\u4edf'));
        f_NUM.add(Character.valueOf('\u4e07'));
        f_NUM.add(Character.valueOf('\u4ebf'));
    }
}

