/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.MBeanHelper;
import org.gridkit.jvmtool.MTable;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.cmd.Unsplitter;
import org.gridkit.util.formating.JsonExporter;
import org.gridkit.util.formating.TextTable;

public class MxCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "mx";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new MX(host);
    }

    @Parameters(commandDescription="[MBean] MBean query and invokation")
    public static class MX
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @ParametersDelegate
        private JmxConnectionInfo connInfo;
        @Parameter(names={"-b", "--bean"}, required=true, description="MBean name")
        private String mbean;
        @Parameter(names={"-f", "--field", "--attribute"}, variableArity=true, description="MBean attributes")
        List<String> attribs = new ArrayList<String>();
        @Parameter(names={"--quiet"}, description="Avoid non-essential output")
        boolean quiet = false;
        @Parameter(names={"--max-col-width"}, description="Table column width threshold for formating tabular data")
        int maxWidth = 40;
        @ParametersDelegate
        private CallCmd call = new CallCmd();
        @Parameter(names={"-all", "--allMatched"}, description="Process all matched MBeans")
        private boolean all = false;
        @ParametersDelegate
        private GetCmd get = new GetCmd();
        @ParametersDelegate
        private SetCmd set = new SetCmd();
        @ParametersDelegate
        private InfoCmd info = new InfoCmd();

        public MX(CommandLauncher host) {
            this.host = host;
            this.connInfo = new JmxConnectionInfo(host);
        }

        @Override
        public void run() {
            try {
                ArrayList<Runnable> action = new ArrayList<Runnable>();
                if (this.call.run) {
                    action.add(this.call);
                }
                if (this.get.run) {
                    action.add(this.get);
                }
                if (this.set.run) {
                    action.add(this.set);
                }
                if (this.info.run) {
                    action.add(this.info);
                }
                if (action.isEmpty() || action.size() > 1) {
                    this.host.failAndPrintUsage(new String[]{"You should choose one of --info, --get, --set, --call"});
                }
                ((Runnable)action.get(0)).run();
            }
            catch (Exception e) {
                this.host.fail(e.toString(), e);
            }
        }

        private Set<ObjectName> resolveSingleBean(MBeanServerConnection conn) throws Exception {
            ObjectName name = new ObjectName(this.mbean);
            Set<ObjectName> beans = conn.queryNames(name, null);
            if (beans.isEmpty()) {
                this.host.fail(new String[]{"MBean not found: " + this.mbean});
            }
            if (!this.all && beans.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (ObjectName n : beans) {
                    sb.append('\n').append(n);
                }
                this.host.fail(new String[]{"Ambiguous MBean selection. Use '-all' param for process all matched MBeans" + sb.toString()});
            }
            return beans;
        }

        class InfoCmd
        implements Runnable {
            @Parameter(names={"-mi", "--info"}, description="Display metadata for MBean")
            boolean run;

            InfoCmd() {
            }

            @Override
            public void run() {
                try {
                    MBeanServerConnection conn = MX.this.connInfo.getMServer();
                    Set names = MX.this.resolveSingleBean(conn);
                    MBeanHelper helper = new MBeanHelper(conn);
                    for (ObjectName name : names) {
                        System.out.println(helper.describe(name));
                    }
                }
                catch (Exception e) {
                    MX.this.host.fail(e.toString(), e);
                }
            }
        }

        class SetCmd
        implements Runnable {
            @Parameter(names={"-ms", "--set"}, description="Sets value for MBean attribute")
            boolean run;
            @Parameter(names={"-v", "--value"}, description="Value to set to attribute")
            String value = null;

            SetCmd() {
            }

            @Override
            public void run() {
                try {
                    if (MX.this.attribs == null || MX.this.attribs.isEmpty()) {
                        MX.this.host.failAndPrintUsage(new String[]{"MBean attribute name is missing"});
                    } else if (MX.this.attribs.size() > 1) {
                        MX.this.host.failAndPrintUsage(new String[]{"Multiple MBean attribute names not supported"});
                    }
                    if (this.value == null) {
                        MX.this.host.failAndPrintUsage(new String[]{"Value is required"});
                    }
                    MBeanServerConnection conn = MX.this.connInfo.getMServer();
                    Set names = MX.this.resolveSingleBean(conn);
                    MBeanHelper helper = new MBeanHelper(conn);
                    for (ObjectName name : names) {
                        if (!MX.this.quiet) {
                            System.out.println(name);
                        }
                        helper.set(name, MX.this.attribs.get(0), this.value);
                    }
                }
                catch (Exception e) {
                    MX.this.host.fail(e.toString(), e);
                }
            }
        }

        class GetCmd
        implements Runnable {
            @Parameter(names={"-mg", "--get"}, description="Retrieves value of MBean attribute")
            boolean run;
            @Parameter(names={"--csv"}, description="Used with --get command, result would be formatted as CSV")
            boolean csv;
            @Parameter(names={"--json"}, description="Used with --get command, result would be formatted as JSON")
            boolean json;
            @Parameter(names={"--json-array"}, description="Used with --get command, result would be formatted as JSON and wrapped as array")
            boolean jsonArray;
            @Parameter(names={"--add-mbean-name"}, description="Used with --get command in --cvs mode, if enabled MBean name and attribute name would be added as columns.")
            boolean addMBeanName;
            @Parameter(names={"--col-list"}, description="Used with --get command in --cvs mode, if set would restrict columns in output to a list.")
            List<String> cols;

            GetCmd() {
            }

            @Override
            public void run() {
                try {
                    if (this.csv && this.json || this.csv && this.jsonArray || this.json && this.jsonArray) {
                        MX.this.host.fail(new String[]{"--csv, --json, --json-array are mutually exclusive, please choose one"});
                    }
                    MBeanServerConnection conn = MX.this.connInfo.getMServer();
                    Set names = MX.this.resolveSingleBean(conn);
                    MBeanHelper helper = new MBeanHelper(conn);
                    if (this.csv) {
                        if (MX.this.attribs == null || MX.this.attribs.isEmpty()) {
                            MX.this.host.failAndPrintUsage(new String[]{"MBean attribute list is required for --csv export"});
                        }
                        MTable table = new MTable();
                        for (ObjectName name : names) {
                            helper.getAsTable(name, MX.this.attribs, table);
                        }
                        if (table.isEmpty()) {
                            System.out.println("No data");
                        } else {
                            TextTable tt = new TextTable();
                            table.export(tt);
                            tt = this.applyProjection(tt);
                            System.out.println(TextTable.formatCsv(tt));
                        }
                    } else if (this.json || this.jsonArray) {
                        boolean first = true;
                        if (this.jsonArray) {
                            System.out.println("[");
                        }
                        for (ObjectName name : names) {
                            if (this.jsonArray) {
                                if (!first) {
                                    System.out.println(",");
                                }
                                first = false;
                            }
                            List<String> alist = MX.this.attribs;
                            if (MX.this.attribs == null || MX.this.attribs.isEmpty()) {
                                alist = helper.getAttibuteList(name);
                            }
                            System.out.print(JsonExporter.mbean2json(helper.getAttributes(name, alist)));
                            if (this.jsonArray) continue;
                            System.out.println();
                        }
                        if (this.jsonArray) {
                            System.out.println();
                            System.out.println("]");
                        }
                    } else {
                        helper.setFormatingOption(MBeanHelper.FORMAT_TABLE_COLUMN_WIDTH_THRESHOLD, MX.this.maxWidth);
                        for (ObjectName name : names) {
                            if (!MX.this.quiet) {
                                System.out.println(name);
                            }
                            List<String> alist = MX.this.attribs;
                            if (MX.this.attribs == null || MX.this.attribs.isEmpty()) {
                                alist = helper.getAttibuteList(name);
                            }
                            Map<String, String> attrValues = helper.get(name, alist);
                            for (String attrib : MX.this.attribs) {
                                String attribValue = attrValues.get(attrib);
                                if (MX.this.quiet) {
                                    System.out.println(attribValue);
                                    continue;
                                }
                                if (attribValue.contains("\n")) {
                                    System.out.println("    " + attrib);
                                    System.out.println("        " + attribValue.replaceAll("\\n", "\\\n        "));
                                    continue;
                                }
                                System.out.println("    " + attrib + " " + attribValue);
                            }
                            System.out.println();
                        }
                    }
                }
                catch (Exception e) {
                    MX.this.host.fail(e.toString(), e);
                }
            }

            private TextTable applyProjection(TextTable tt) {
                if ((this.cols == null || this.cols.isEmpty()) && !this.addMBeanName) {
                    String[] hdr = tt.getRow(0);
                    for (int i = hdr.length - 1; i >= 0; --i) {
                        if (!"MBean".equals(hdr[i]) && !"Attribute".equals(hdr[i])) continue;
                        tt.removeColumn(i);
                    }
                } else if (this.cols != null && !this.cols.isEmpty()) {
                    TextTable ntt = new TextTable();
                    List<String> hdr = Arrays.asList(tt.getRow(0));
                    for (String h : this.cols) {
                        int n = hdr.indexOf(h);
                        String[] col = tt.getCol(n);
                        col[0] = h;
                        ntt.addColumnRight(col);
                    }
                    return ntt;
                }
                return tt;
            }
        }

        class CallCmd
        implements Runnable {
            @Parameter(names={"-mc", "--call"}, description="Invokes MBean method")
            boolean run;
            @Parameter(names={"-op", "--operation"}, description="MBean operation name to be called")
            String operation = null;
            @Parameter(names={"-a", "--arguments"}, variableArity=true, splitter=Unsplitter.class, description="Arguments for MBean operation invocation")
            List<String> arguments = new ArrayList<String>();

            CallCmd() {
            }

            @Override
            public void run() {
                try {
                    if (this.operation == null) {
                        MX.this.host.failAndPrintUsage(new String[]{"MBean operation name is missing"});
                    }
                    MBeanServerConnection conn = MX.this.connInfo.getMServer();
                    Set names = MX.this.resolveSingleBean(conn);
                    MBeanHelper helper = new MBeanHelper(conn);
                    helper.setFormatingOption(MBeanHelper.FORMAT_TABLE_COLUMN_WIDTH_THRESHOLD, MX.this.maxWidth);
                    for (ObjectName name : names) {
                        if (!MX.this.quiet) {
                            System.out.println(name);
                        }
                        System.out.println(helper.invoke(name, this.operation, this.arguments.toArray(new String[this.arguments.size()])));
                    }
                }
                catch (Exception e) {
                    MX.this.host.fail(e.toString(), e);
                }
            }
        }
    }
}

