/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

public interface Scoping {
    default public <S> S getScopeValue(Pop pop, Object key, Traverser.Admin<?> traverser) throws KeyNotFoundException {
        Object object = traverser.get();
        if (object instanceof Map && ((Map)object).containsKey(key)) {
            return (S)((Map)object).get(key);
        }
        if (key instanceof String) {
            String k = (String)key;
            if (traverser.getSideEffects().exists(k)) {
                return (S)traverser.getSideEffects().get(k);
            }
            Path path = traverser.path();
            if (path.hasLabel(k)) {
                return (S)(null == pop ? path.get(k) : path.get(pop, k));
            }
        }
        throw new KeyNotFoundException(key, this);
    }

    default public <S> S getSafeScopeValue(Pop pop, Object key, Traverser.Admin<?> traverser) {
        try {
            return this.getScopeValue(pop, key, traverser);
        }
        catch (KeyNotFoundException nfe) {
            throw new IllegalArgumentException(nfe.getMessage(), nfe);
        }
    }

    default public <S> S getNullableScopeValue(Pop pop, String key, Traverser.Admin<?> traverser) {
        try {
            return this.getScopeValue(pop, key, traverser);
        }
        catch (KeyNotFoundException nfe) {
            return null;
        }
    }

    public Set<String> getScopeKeys();

    public static class KeyNotFoundException
    extends Exception {
        private final Object key;
        private final Scoping step;

        public KeyNotFoundException(Object key, Scoping current) {
            super("Neither the map, sideEffects, nor path has a " + key + "-key: " + current);
            this.key = key;
            this.step = current;
        }

        public Object getKey() {
            return this.key;
        }

        public Scoping getStep() {
            return this.step;
        }
    }

    public static enum Variable {
        START,
        END;

    }
}

