/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CharNode {
    private int freq = -1;
    private int maxLen = 0;
    private KeyTree ktWordTails = new KeyTree();
    private int wordNum = 0;

    public void addWordTail(char[] wordTail) {
        this.ktWordTails.add(wordTail);
        ++this.wordNum;
        if (wordTail.length > this.maxLen) {
            this.maxLen = wordTail.length;
        }
    }

    public int getFreq() {
        return this.freq;
    }

    public void setFreq(int freq) {
        this.freq = freq;
    }

    public int wordNum() {
        return this.wordNum;
    }

    public int indexOf(char[] sen, int offset, int tailLen) {
        return this.ktWordTails.match(sen, offset + 1, tailLen) ? 1 : -1;
    }

    public int maxMatch(char[] sen, int wordTailOffset) {
        return this.ktWordTails.maxMatch(sen, wordTailOffset);
    }

    public ArrayList<Integer> maxMatch(ArrayList<Integer> tailLens, char[] sen, int wordTailOffset) {
        return this.ktWordTails.maxMatch(tailLens, sen, wordTailOffset);
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public void setMaxLen(int maxLen) {
        this.maxLen = maxLen;
    }

    private static class TreeNode {
        char key;
        Map<Character, TreeNode> subNodes;
        boolean alsoLeaf;

        public TreeNode(char key) {
            this.key = key;
            this.subNodes = new HashMap<Character, TreeNode>();
        }

        public void born(char k, TreeNode sub) {
            this.subNodes.put(Character.valueOf(k), sub);
        }

        public TreeNode subNode(char k) {
            return this.subNodes.get(Character.valueOf(k));
        }

        public boolean isAlsoLeaf() {
            return this.alsoLeaf;
        }
    }

    public static class KeyTree {
        TreeNode head = new TreeNode(' ');

        public void add(char[] w) {
            if (w.length < 1) {
                return;
            }
            TreeNode p = this.head;
            for (int i = 0; i < w.length; ++i) {
                TreeNode n = p.subNode(w[i]);
                if (n == null) {
                    n = new TreeNode(w[i]);
                    p.born(w[i], n);
                }
                p = n;
            }
            p.alsoLeaf = true;
        }

        public int maxMatch(char[] sen, int offset) {
            int idx = offset - 1;
            TreeNode node = this.head;
            for (int i = offset; i < sen.length && (node = node.subNode(sen[i])) != null; ++i) {
                if (!node.isAlsoLeaf()) continue;
                idx = i;
            }
            return idx - offset + 1;
        }

        public ArrayList<Integer> maxMatch(ArrayList<Integer> tailLens, char[] sen, int offset) {
            TreeNode node = this.head;
            for (int i = offset; i < sen.length && (node = node.subNode(sen[i])) != null; ++i) {
                if (!node.isAlsoLeaf()) continue;
                tailLens.add(i - offset + 1);
            }
            return tailLens;
        }

        public boolean match(char[] sen, int offset, int len) {
            TreeNode node = this.head;
            for (int i = 0; i < len; ++i) {
                if ((node = node.subNode(sen[offset + i])) != null) continue;
                return false;
            }
            return node.isAlsoLeaf();
        }
    }
}

