/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.jfr_jdk.parser;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jdk.jfr.consumer.RecordingFile;
import org.gridkit.jvmtool.jfr_jdk.parser.EventSource;
import org.gridkit.jvmtool.spi.parsers.FileInputStreamSource;
import org.gridkit.jvmtool.spi.parsers.InputStreamSource;
import org.gridkit.jvmtool.spi.parsers.JsonEventDumpParser;
import org.gridkit.jvmtool.spi.parsers.JsonEventSource;

class Parser
implements JsonEventDumpParser {
    private int jsonMaxDepth = Integer.MAX_VALUE;
    private List<String> whiteList = null;
    private List<String> blackList = null;

    private static void checkClasses() {
        try {
            RecordingFile.class.getSimpleName();
        }
        catch (Throwable e) {
            throw new RuntimeException("Native JFR parser is not available");
        }
    }

    public Parser() {
        Parser.checkClasses();
    }

    public JsonEventSource open(InputStreamSource source) throws Exception {
        if (source instanceof FileInputStreamSource) {
            File file = ((FileInputStreamSource)source).getSourceFile();
            RecordingFile rec = new RecordingFile(file.toPath());
            EventSource eventSource = new EventSource(rec, this.jsonMaxDepth);
            if (this.whiteList != null) {
                eventSource.setWhiteList(this.whiteList);
            }
            if (this.blackList != null) {
                eventSource.setBlackList(this.blackList);
            }
            return eventSource;
        }
        throw new IOException("Native JFR parser is rescripted to file system IO");
    }

    public void configure(Map<String, String> options) {
        for (String key : options.keySet()) {
            String[] list;
            if ("jfr.native_parser".equals(key)) {
                if (!"false".equalsIgnoreCase(options.get(key))) continue;
                throw new RuntimeException("Unsatisfied option: " + key + "=" + options.get(key));
            }
            if ("json.max_depth".equals(key)) {
                this.jsonMaxDepth = Integer.valueOf(options.get(key));
                if (this.jsonMaxDepth >= 0) continue;
                throw new RuntimeException("Illegal option value: " + key + "=" + options.get(key));
            }
            if ("jfr.blacklist".equals(key)) {
                list = options.get(key).split(",");
                if (list.length <= 0) continue;
                this.blackList = Arrays.asList(list);
                continue;
            }
            if ("jfr.whitelist".equals(key)) {
                list = options.get(key).split(",");
                if (list.length <= 0) continue;
                this.whiteList = Arrays.asList(list);
                continue;
            }
            throw new RuntimeException("Unknown option: " + key + "=" + options.get(key));
        }
    }
}

