/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.dist;

import java.util.concurrent.CompletableFuture;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeFactory;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.dist.HugeGremlinServer;
import org.apache.hugegraph.dist.HugeRestServer;
import org.apache.hugegraph.dist.RegisterUtil;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.server.RestServer;
import org.apache.hugegraph.util.ConfigUtil;
import org.apache.hugegraph.util.Log;
import org.apache.logging.log4j.LogManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.slf4j.Logger;

public class HugeGraphServer {
    private static final Logger LOG = Log.logger(HugeGraphServer.class);
    private final RestServer restServer;
    private final GremlinServer gremlinServer;

    public static void register() {
        RegisterUtil.registerBackends();
        RegisterUtil.registerPlugins();
        RegisterUtil.registerServer();
    }

    public HugeGraphServer(String gremlinServerConf, String restServerConf) throws Exception {
        SecurityManager securityManager = System.getSecurityManager();
        System.setSecurityManager(null);
        ConfigUtil.checkGremlinConfig((String)gremlinServerConf);
        HugeConfig restServerConfig = new HugeConfig(restServerConf);
        String graphsDir = (String)restServerConfig.get((TypedOption)ServerOptions.GRAPHS);
        EventHub hub = new EventHub("gremlin=>hub<=rest");
        try {
            this.restServer = HugeRestServer.start(restServerConf, hub);
        }
        catch (Throwable e) {
            LOG.error("HugeRestServer start error: ", e);
            throw e;
        }
        try {
            this.gremlinServer = HugeGremlinServer.start(gremlinServerConf, graphsDir, hub);
        }
        catch (Throwable e) {
            LOG.error("HugeGremlinServer start error: ", e);
            try {
                this.restServer.shutdown().get();
            }
            catch (Throwable t) {
                LOG.error("HugeRestServer stop error: ", t);
            }
            throw e;
        }
        finally {
            System.setSecurityManager(securityManager);
        }
    }

    public void stop() {
        try {
            this.gremlinServer.stop().get();
            LOG.info("HugeGremlinServer stopped");
        }
        catch (Throwable e) {
            LOG.error("HugeGremlinServer stop error: ", e);
        }
        try {
            this.restServer.shutdown().get();
            LOG.info("HugeRestServer stopped");
        }
        catch (Throwable e) {
            LOG.error("HugeRestServer stop error: ", e);
        }
        try {
            HugeFactory.shutdown((long)30L);
            LOG.info("HugeGraph stopped");
        }
        catch (Throwable e) {
            LOG.error("Failed to stop HugeGraph: ", e);
        }
    }

    public static void main(String[] args) throws Exception {
        HugeGraphServer server;
        if (args.length != 2) {
            String msg = "Start HugeGraphServer need to pass 2 parameters, they are the config files of GremlinServer and RestServer, for example: conf/gremlin-server.yaml conf/rest-server.properties";
            LOG.error(msg);
            throw new HugeException(msg);
        }
        HugeGraphServer.register();
        try {
            server = new HugeGraphServer(args[0], args[1]);
        }
        catch (Throwable e) {
            HugeFactory.shutdown((long)30L, (boolean)true);
            throw e;
        }
        HugeFactory.removeShutdownHook();
        CompletableFuture serverStopped = new CompletableFuture();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("HugeGraphServer stopping");
            server.stop();
            LOG.info("HugeGraphServer stopped");
            LogManager.shutdown();
            serverStopped.complete(null);
        }, "hugegraph-server-shutdown"));
        serverStopped.get();
    }
}

