/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util.collection;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.collection.IntIterator;
import org.apache.hugegraph.util.collection.IntSet;
import org.eclipse.collections.api.map.primitive.MutableIntIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import sun.misc.Unsafe;

public interface IntMap {
    public static final int NULL_VALUE = Integer.MIN_VALUE;
    public static final Unsafe UNSAFE = IntSet.UNSAFE;

    public boolean put(int var1, int var2);

    public int get(int var1);

    public boolean remove(int var1);

    public boolean containsKey(int var1);

    public IntIterator keys();

    public IntIterator values();

    public void clear();

    public int size();

    public boolean concurrent();

    public static final class IntMapByEcSegment
    implements IntMap {
        private final MutableIntIntMap[] maps;
        private final int segmentMask;

        public IntMapByEcSegment(int segments) {
            segments = IntSet.sizeToPowerOf2Size(segments);
            this.segmentMask = segments - 1;
            this.maps = new MutableIntIntMap[segments];
            for (int i = 0; i < segments; ++i) {
                this.maps[i] = new IntIntHashMap().asSynchronized();
            }
        }

        private MutableIntIntMap map(int key) {
            int index = key & this.segmentMask;
            return this.maps[index];
        }

        @Override
        public boolean put(int key, int value) {
            this.map(key).put(key, value);
            return true;
        }

        @Override
        public int get(int key) {
            return this.map(key).get(key);
        }

        @Override
        public boolean containsKey(int key) {
            return this.map(key).containsKey(key);
        }

        @Override
        public boolean remove(int key) {
            this.map(key).remove(key);
            return true;
        }

        @Override
        public void clear() {
            for (MutableIntIntMap map : this.maps) {
                map.clear();
            }
        }

        @Override
        public int size() {
            int size = 0;
            for (MutableIntIntMap map : this.maps) {
                size += map.size();
            }
            return size;
        }

        @Override
        public IntIterator keys() {
            IntIterator.IntIterators iters = new IntIterator.IntIterators(this.maps.length);
            for (MutableIntIntMap map : this.maps) {
                iters.extend(IntIterator.wrap((org.eclipse.collections.api.iterator.IntIterator)map.keySet().intIterator()));
            }
            return iters;
        }

        @Override
        public IntIterator values() {
            IntIterator.IntIterators iters = new IntIterator.IntIterators(this.maps.length);
            for (MutableIntIntMap map : this.maps) {
                iters.extend(IntIterator.wrap((org.eclipse.collections.api.iterator.IntIterator)map.values().intIterator()));
            }
            return iters;
        }

        @Override
        public boolean concurrent() {
            return false;
        }
    }

    public static final class IntMapByFixedAddr
    implements IntMap {
        private final int[] values;
        private final int capacity;
        private final AtomicInteger size;
        private final int indexBlocksNum;
        private final int indexBlockSize;
        private final int indexBlockSizeShift;
        private final IntSet.IntSetByFixedAddr4Unsigned indexBlocksSet;
        private static final int BASE_OFFSET = Unsafe.ARRAY_INT_BASE_OFFSET;
        private static final int MUL4 = 31 - Integer.numberOfLeadingZeros(Unsafe.ARRAY_INT_INDEX_SCALE);

        public IntMapByFixedAddr(int capacity) {
            this.capacity = capacity;
            this.values = new int[capacity];
            this.size = new AtomicInteger();
            int minBlockSize = 1024;
            int indexBlocksNum = 65536;
            int indexBlockSize = IntSet.segmentSize(capacity, indexBlocksNum);
            if (indexBlockSize < minBlockSize) {
                indexBlockSize = minBlockSize;
                indexBlocksNum = IntSet.segmentSize(capacity, indexBlockSize);
            }
            this.indexBlocksNum = indexBlocksNum;
            this.indexBlockSize = IntSet.segmentSize(capacity, this.indexBlocksNum);
            this.indexBlockSizeShift = Integer.numberOfTrailingZeros(this.indexBlockSize);
            this.indexBlocksSet = new IntSet.IntSetByFixedAddr4Unsigned(this.indexBlocksNum);
            this.clear();
        }

        @Override
        public boolean put(int key, int value) {
            assert (value != Integer.MIN_VALUE) : "put value can't be -2147483648";
            if (value == Integer.MIN_VALUE) {
                return false;
            }
            int newV = value;
            long offset = this.offset(key);
            int oldV = UNSAFE.getIntVolatile(this.values, offset);
            if (newV == oldV) {
                return true;
            }
            if (oldV != Integer.MIN_VALUE) {
                UNSAFE.putIntVolatile(this.values, offset, newV);
            } else if (UNSAFE.compareAndSwapInt(this.values, offset, oldV, newV)) {
                this.size.incrementAndGet();
                this.indexBlocksSet.add(key >>> this.indexBlockSizeShift);
            }
            return true;
        }

        public boolean putIfAbsent(int key, int value) {
            assert (value != Integer.MIN_VALUE);
            int newV = value;
            long offset = this.offset(key);
            int oldV = UNSAFE.getIntVolatile(this.values, offset);
            if (newV == oldV || oldV != Integer.MIN_VALUE) {
                return false;
            }
            if (UNSAFE.compareAndSwapInt(this.values, offset, oldV, newV)) {
                assert (oldV == Integer.MIN_VALUE);
                this.size.incrementAndGet();
                this.indexBlocksSet.add(key >>> this.indexBlockSizeShift);
                return true;
            }
            return false;
        }

        @Override
        public int get(int key) {
            if (key >= this.capacity) {
                return Integer.MIN_VALUE;
            }
            long offset = this.offset(key);
            int value = UNSAFE.getIntVolatile(this.values, offset);
            return value;
        }

        @Override
        public boolean containsKey(int key) {
            if (key >= this.capacity) {
                return false;
            }
            long offset = this.offset(key);
            int value = UNSAFE.getIntVolatile(this.values, offset);
            return value != Integer.MIN_VALUE;
        }

        @Override
        public boolean remove(int key) {
            int newV;
            int oldV;
            long offset = this.offset(key);
            do {
                if ((newV = Integer.MIN_VALUE) == (oldV = UNSAFE.getIntVolatile(this.values, offset))) {
                    return false;
                }
                assert (oldV != Integer.MIN_VALUE);
            } while (!UNSAFE.compareAndSwapInt(this.values, offset, oldV, newV));
            this.size.decrementAndGet();
            return true;
        }

        @Override
        public void clear() {
            Arrays.fill(this.values, Integer.MIN_VALUE);
            this.size.set(0);
            this.indexBlocksSet.clear();
        }

        @Override
        public int size() {
            return this.size.get();
        }

        @Override
        public IntIterator keys() {
            return new KeyIterator();
        }

        @Override
        public IntIterator values() {
            return new ValueIterator();
        }

        @Override
        public boolean concurrent() {
            return true;
        }

        private long offset(int key) {
            if (key >= this.capacity || key < 0) {
                E.checkArgument((boolean)false, (String)"The key %s is out of bound %s", (Object[])new Object[]{key, this.capacity});
            }
            long index = key;
            long offset = index << MUL4;
            return offset += (long)BASE_OFFSET;
        }

        private final class ValueIterator
        implements IntIterator {
            private int indexOfBlock = 0;
            private int indexInBlock = 0;
            private int current = Integer.MIN_VALUE;

            public ValueIterator() {
                this.indexOfBlock = IntMapByFixedAddr.this.indexBlocksSet.nextKey(this.indexOfBlock);
            }

            @Override
            public boolean hasNext() {
                if (this.current != Integer.MIN_VALUE) {
                    return true;
                }
                while (this.indexOfBlock < IntMapByFixedAddr.this.indexBlocksNum) {
                    while (this.indexInBlock < IntMapByFixedAddr.this.indexBlockSize) {
                        int value;
                        int index = this.indexOfBlock << IntMapByFixedAddr.this.indexBlockSizeShift;
                        if ((value = IntMapByFixedAddr.this.get(index += this.indexInBlock++)) == Integer.MIN_VALUE) continue;
                        this.current = value;
                        return true;
                    }
                    this.indexOfBlock = IntMapByFixedAddr.this.indexBlocksSet.nextKey(this.indexOfBlock + 1);
                    this.indexInBlock = 0;
                }
                return false;
            }

            @Override
            public int next() {
                if (this.current == Integer.MIN_VALUE && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int result = this.current;
                this.current = Integer.MIN_VALUE;
                return result;
            }
        }

        private final class KeyIterator
        implements IntIterator {
            private int indexOfBlock;
            private int indexInBlock;
            private boolean fetched;
            private int current;

            public KeyIterator() {
                this.indexOfBlock = IntMapByFixedAddr.this.indexBlocksSet.nextKey(0);
                this.indexInBlock = 0;
                this.fetched = false;
                this.current = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.fetched) {
                    return true;
                }
                while (this.indexOfBlock < IntMapByFixedAddr.this.indexBlocksNum) {
                    while (this.indexInBlock < IntMapByFixedAddr.this.indexBlockSize) {
                        int value;
                        int index = this.indexOfBlock << IntMapByFixedAddr.this.indexBlockSizeShift;
                        if ((value = IntMapByFixedAddr.this.get(index += this.indexInBlock++)) == Integer.MIN_VALUE) continue;
                        this.fetched = true;
                        this.current = index;
                        return true;
                    }
                    this.indexOfBlock = IntMapByFixedAddr.this.indexBlocksSet.nextKey(this.indexOfBlock + 1);
                    this.indexInBlock = 0;
                }
                assert (!this.fetched);
                return false;
            }

            @Override
            public int next() {
                if (!this.fetched && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.fetched = false;
                return this.current;
            }
        }
    }

    public static final class IntMapBySegments
    implements IntMap {
        private final IntMap[] maps;
        private final long capacity;
        private final long unsignedSize;
        private final int segmentSize;
        private final int segmentShift;
        private final int segmentMask;
        private final Function<Integer, IntMap> creator;
        private static final int DEFAULT_SEGMENTS = IntSet.CPUS * 100;
        private static final Function<Integer, IntMap> DEFAULT_CREATOR = size -> new IntMapByFixedAddr((int)size);
        private static final int BASE_OFFSET = Unsafe.ARRAY_OBJECT_BASE_OFFSET;
        private static final int SHIFT = 31 - Integer.numberOfLeadingZeros(Unsafe.ARRAY_OBJECT_INDEX_SCALE);

        public IntMapBySegments(int capacity) {
            this(capacity, DEFAULT_SEGMENTS, DEFAULT_CREATOR);
        }

        public IntMapBySegments(int capacity, int segments) {
            this(capacity, segments, DEFAULT_CREATOR);
        }

        public IntMapBySegments(int capacity, int segments, Function<Integer, IntMap> creator) {
            E.checkArgument((segments >= 1 ? 1 : 0) != 0, (String)"Invalid segments %s", (Object[])new Object[]{segments});
            E.checkArgument((capacity >= segments ? 1 : 0) != 0, (String)"Invalid capacity %s, expect >= segments %s", (Object[])new Object[]{capacity, segments});
            this.maps = new IntMap[segments];
            this.unsignedSize = capacity;
            this.capacity = this.unsignedSize * 2L;
            this.segmentSize = IntSet.segmentSize(this.capacity, segments);
            this.segmentShift = Integer.numberOfTrailingZeros(this.segmentSize);
            this.segmentMask = this.segmentShift == 0 ? 0 : -1 >>> 32 - this.segmentShift;
            this.creator = creator;
        }

        @Override
        public boolean put(int key, int value) {
            int innerKey = (int)((long)key + this.unsignedSize & (long)this.segmentMask);
            return this.segment(key).put(innerKey, value);
        }

        @Override
        public boolean remove(int key) {
            int innerKey = (int)((long)key + this.unsignedSize & (long)this.segmentMask);
            return this.segment(key).remove(innerKey);
        }

        @Override
        public int get(int key) {
            long ukey = (long)key + this.unsignedSize;
            if (ukey >= this.capacity || ukey < 0L) {
                return Integer.MIN_VALUE;
            }
            int innerKey = (int)(ukey & (long)this.segmentMask);
            return this.segment(key).get(innerKey);
        }

        @Override
        public boolean containsKey(int key) {
            long ukey = (long)key + this.unsignedSize;
            if (ukey >= this.capacity || ukey < 0L) {
                return false;
            }
            int innerKey = (int)(ukey & (long)this.segmentMask);
            return this.segment(key).containsKey(innerKey);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.maps.length; ++i) {
                IntMap map = this.segmentAt(i);
                if (map == null) continue;
                map.clear();
            }
        }

        @Override
        public int size() {
            int size = 0;
            for (int i = 0; i < this.maps.length; ++i) {
                IntMap map = this.segmentAt(i);
                if (map == null) continue;
                size += map.size();
            }
            return size;
        }

        @Override
        public IntIterator keys() {
            IntIterator.IntIterators iters = new IntIterator.IntIterators(this.maps.length);
            for (int i = 0; i < this.maps.length; ++i) {
                IntMap map = this.segmentAt(i);
                if (map == null || map.size() == 0) continue;
                int base = this.segmentSize * i;
                iters.extend(new IntIterator.MapperInt2IntIterator(map.keys(), k -> (int)((long)(k + base) - this.unsignedSize)));
            }
            return iters;
        }

        @Override
        public IntIterator values() {
            IntIterator.IntIterators iters = new IntIterator.IntIterators(this.maps.length);
            for (int i = 0; i < this.maps.length; ++i) {
                IntMap map = this.segmentAt(i);
                if (map == null || map.size() <= 0) continue;
                iters.extend(map.values());
            }
            return iters;
        }

        @Override
        public boolean concurrent() {
            return true;
        }

        private IntMap segment(int key) {
            long index;
            IntMap exist;
            long ukey = (long)key + this.unsignedSize;
            if (ukey >= this.capacity || ukey < 0L) {
                E.checkArgument((boolean)false, (String)"The key %s is out of bound %s", (Object[])new Object[]{key, this.capacity});
            }
            if ((exist = this.maps[(int)(index = ukey >>> this.segmentShift)]) != null) {
                return exist;
            }
            long offset = (index << SHIFT) + (long)BASE_OFFSET;
            Object old = UNSAFE.getObjectVolatile(this.maps, offset);
            if (old != null) {
                return (IntMap)old;
            }
            IntMap map = this.creator.apply(this.segmentSize);
            do {
                if (!UNSAFE.compareAndSwapObject(this.maps, offset, null, map)) continue;
                return map;
            } while ((old = UNSAFE.getObjectVolatile(this.maps, offset)) == null);
            return (IntMap)old;
        }

        private IntMap segmentAt(int index) {
            long offset = (index << SHIFT) + BASE_OFFSET;
            IntMap map = (IntMap)UNSAFE.getObjectVolatile(this.maps, offset);
            return map;
        }
    }
}

