/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records;

import java.util.List;
import java.util.Stack;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.SingleWayMultiPathsRecords;
import org.apache.hugegraph.traversal.algorithm.records.record.Record;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.apache.hugegraph.util.collection.IntIterator;

public class KoutRecords
extends SingleWayMultiPathsRecords {
    public KoutRecords(boolean concurrent, Id source, boolean nearest) {
        super(RecordType.INT, concurrent, source, nearest);
    }

    @Override
    public int size() {
        return this.currentRecord().size();
    }

    @Override
    public List<Id> ids(long limit) {
        List<Id> ids = CollectionFactory.newList(CollectionType.EC);
        IntIterator iterator = this.records().peek().keys();
        while ((limit == Long.MAX_VALUE || limit-- > 0L) && iterator.hasNext()) {
            ids.add(this.id(iterator.next()));
        }
        return ids;
    }

    @Override
    public HugeTraverser.PathSet paths(long limit) {
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        Stack<Record> records = this.records();
        IntIterator iterator = records.peek().keys();
        while ((limit == Long.MAX_VALUE || limit-- > 0L) && iterator.hasNext()) {
            paths.add(this.linkPath(records.size() - 1, iterator.next()));
        }
        return paths;
    }
}

