/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.traversal.algorithm.ShortestPathTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class MultiNodeShortestPathTraverser
extends OltpTraverser {
    public MultiNodeShortestPathTraverser(HugeGraph graph) {
        super(graph);
    }

    public List<HugeTraverser.Path> multiNodeShortestPath(Iterator<Vertex> vertices, EdgeStep step, int maxDepth, long capacity) {
        List vertexList = IteratorUtils.list(vertices);
        int vertexCount = vertexList.size();
        E.checkState((vertexCount >= 2 && vertexCount <= 10 ? 1 : 0) != 0, (String)"The number of vertices of multiple node shortest path must in [2, %s], but got: %s", (Object[])new Object[]{10, vertexList.size()});
        List<Pair<Id, Id>> pairs = MultiNodeShortestPathTraverser.newList();
        MultiNodeShortestPathTraverser.cmn(vertexList, vertexCount, 2, 0, null, r -> {
            Id source = ((HugeVertex)r.get(0)).id();
            Id target = ((HugeVertex)r.get(1)).id();
            Pair pair = Pair.of((Object)source, (Object)target);
            pairs.add(pair);
        });
        if (maxDepth >= this.concurrentDepth() && vertexCount > 10) {
            return this.multiNodeShortestPathConcurrent(pairs, step, maxDepth, capacity);
        }
        return this.multiNodeShortestPathSingle(pairs, step, maxDepth, capacity);
    }

    public List<HugeTraverser.Path> multiNodeShortestPathConcurrent(List<Pair<Id, Id>> pairs, EdgeStep step, int maxDepth, long capacity) {
        CopyOnWriteArrayList<HugeTraverser.Path> results = new CopyOnWriteArrayList<HugeTraverser.Path>();
        ShortestPathTraverser traverser = new ShortestPathTraverser(this.graph());
        this.traversePairs(pairs.iterator(), pair -> {
            HugeTraverser.Path path = traverser.shortestPath((Id)pair.getLeft(), (Id)pair.getRight(), step, maxDepth, capacity);
            if (!HugeTraverser.Path.EMPTY.equals(path)) {
                results.add(path);
            }
        });
        return results;
    }

    public List<HugeTraverser.Path> multiNodeShortestPathSingle(List<Pair<Id, Id>> pairs, EdgeStep step, int maxDepth, long capacity) {
        List<HugeTraverser.Path> results = MultiNodeShortestPathTraverser.newList();
        ShortestPathTraverser traverser = new ShortestPathTraverser(this.graph());
        for (Pair<Id, Id> pair : pairs) {
            HugeTraverser.Path path = traverser.shortestPath((Id)pair.getLeft(), (Id)pair.getRight(), step, maxDepth, capacity);
            if (HugeTraverser.Path.EMPTY.equals(path)) continue;
            results.add(path);
        }
        return results;
    }

    private static <T> void cmn(List<T> all, int m, int n, int current, List<T> result, Consumer<List<T>> consumer) {
        assert (m <= all.size());
        assert (current <= all.size());
        if (result == null) {
            result = MultiNodeShortestPathTraverser.newList(n);
        }
        if (n == 0) {
            consumer.accept(result);
            return;
        }
        if (m < n || current >= all.size()) {
            return;
        }
        int index = result.size();
        result.add(all.get(current));
        MultiNodeShortestPathTraverser.cmn(all, m - 1, n - 1, ++current, result, consumer);
        result.remove(index);
        MultiNodeShortestPathTraverser.cmn(all, m - 1, n, current, result, consumer);
    }
}

