/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.traversal.algorithm.records.KoutRecords;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class KoutTraverser
extends OltpTraverser {
    public KoutTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> kout(Id sourceV, Directions dir, String label, int depth, boolean nearest, long degree, long capacity, long limit) {
        long remaining;
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        KoutTraverser.checkPositive(depth, "k-out max_depth");
        KoutTraverser.checkDegree(degree);
        KoutTraverser.checkCapacity(capacity);
        KoutTraverser.checkLimit(limit);
        if (capacity != -1L) {
            E.checkArgument((capacity >= limit && limit != -1L ? 1 : 0) != 0, (String)"Capacity can't be less than limit, but got capacity '%s' and limit '%s'", (Object[])new Object[]{capacity, limit});
        }
        Id labelId = this.getEdgeLabelId(label);
        Set<Id> latest = KoutTraverser.newIdSet();
        latest.add(sourceV);
        Set<Id> all = KoutTraverser.newIdSet();
        all.add(sourceV);
        long l = remaining = capacity == -1L ? -1L : capacity - (long)latest.size();
        while (depth-- > 0) {
            if (depth == 0 && limit != -1L && (limit < remaining || remaining == -1L)) {
                remaining = limit;
            }
            if (nearest) {
                latest = this.adjacentVertices(sourceV, latest, dir, labelId, all, degree, remaining);
                all.addAll(latest);
            } else {
                latest = this.adjacentVertices(sourceV, latest, dir, labelId, null, degree, remaining);
            }
            if (capacity == -1L || (remaining -= (long)latest.size()) > 0L || depth <= 0) continue;
            throw new HugeException("Reach capacity '%s' while remaining depth '%s'", capacity, depth);
        }
        return latest;
    }

    public KoutRecords customizedKout(Id source, EdgeStep step, int maxDepth, boolean nearest, long capacity, long limit) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        KoutTraverser.checkPositive(maxDepth, "k-out max_depth");
        KoutTraverser.checkCapacity(capacity);
        KoutTraverser.checkLimit(limit);
        long[] depth = new long[]{maxDepth};
        boolean concurrent = maxDepth >= this.concurrentDepth();
        KoutRecords records = new KoutRecords(concurrent, source, nearest);
        Consumer<Id> consumer = v -> {
            if (this.reachLimit(limit, depth[0], records.size())) {
                return;
            }
            Iterator<Edge> edges = this.edgesOfVertex((Id)v, step);
            while (!this.reachLimit(limit, depth[0], records.size()) && edges.hasNext()) {
                Id target = ((HugeEdge)edges.next()).id().otherVertexId();
                records.addPath((Id)v, target);
                this.checkCapacity(capacity, records.accessed(), depth[0]);
            }
        };
        while (true) {
            long l = depth[0];
            depth[0] = l - 1L;
            if (l <= 0L) break;
            records.startOneLayer(true);
            this.traverseIds(records.keys(), consumer, concurrent);
            records.finishOneLayer();
        }
        return records;
    }

    private void checkCapacity(long capacity, long accessed, long depth) {
        if (capacity == -1L) {
            return;
        }
        if (accessed >= capacity && depth > 0L) {
            throw new HugeException("Reach capacity '%s' while remaining depth '%s'", capacity, depth);
        }
    }

    private boolean reachLimit(long limit, long depth, int size) {
        return limit != -1L && depth <= 0L && (long)size >= limit;
    }
}

