/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.concurrent.PausableScheduledThreadPool;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.ServerInfoManager;
import org.apache.hugegraph.task.StandardTaskScheduler;
import org.apache.hugegraph.task.TaskScheduler;
import org.apache.hugegraph.util.Consumers;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ExecutorUtil;
import org.apache.hugegraph.util.LockUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class TaskManager {
    private static final Logger LOG = Log.logger(TaskManager.class);
    public static final String TASK_WORKER_PREFIX = "task-worker";
    public static final String TASK_WORKER = "task-worker-%d";
    public static final String TASK_DB_WORKER = "task-db-worker-%d";
    public static final String SERVER_INFO_DB_WORKER = "server-info-db-worker-%d";
    public static final String TASK_SCHEDULER = "task-scheduler-%d";
    protected static final long SCHEDULE_PERIOD = 1000L;
    private static final int THREADS = 4;
    private static final TaskManager MANAGER = new TaskManager(4);
    private final Map<HugeGraphParams, TaskScheduler> schedulers = new ConcurrentHashMap<HugeGraphParams, TaskScheduler>();
    private final ExecutorService taskExecutor;
    private final ExecutorService taskDbExecutor;
    private final ExecutorService serverInfoDbExecutor;
    private final PausableScheduledThreadPool schedulerExecutor;
    private static final ThreadLocal<String> CONTEXTS = new ThreadLocal();

    public static TaskManager instance() {
        return MANAGER;
    }

    private TaskManager(int pool) {
        this.taskExecutor = ExecutorUtil.newFixedThreadPool((int)pool, (String)TASK_WORKER);
        this.taskDbExecutor = ExecutorUtil.newFixedThreadPool((int)1, (String)TASK_DB_WORKER);
        this.serverInfoDbExecutor = ExecutorUtil.newFixedThreadPool((int)1, (String)SERVER_INFO_DB_WORKER);
        this.schedulerExecutor = ExecutorUtil.newPausableScheduledThreadPool((int)1, (String)TASK_SCHEDULER);
        this.schedulerExecutor.scheduleWithFixedDelay(this::scheduleOrExecuteJob, 10000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void addScheduler(HugeGraphParams graph) {
        E.checkArgumentNotNull((Object)graph, (String)"The graph can't be null", (Object[])new Object[0]);
        StandardTaskScheduler scheduler = new StandardTaskScheduler(graph, this.taskExecutor, this.taskDbExecutor, this.serverInfoDbExecutor);
        this.schedulers.put(graph, scheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeScheduler(HugeGraphParams graph) {
        TaskScheduler scheduler = this.schedulers.get(graph);
        if (scheduler != null) {
            TaskScheduler taskScheduler = scheduler;
            synchronized (taskScheduler) {
                if (scheduler.close()) {
                    this.schedulers.remove(graph);
                }
            }
        }
        if (!this.taskExecutor.isTerminated()) {
            this.closeTaskTx(graph);
        }
        if (!this.schedulerExecutor.isTerminated()) {
            this.closeSchedulerTx(graph);
        }
    }

    private void closeTaskTx(HugeGraphParams graph) {
        boolean selfIsTaskWorker = Thread.currentThread().getName().startsWith(TASK_WORKER_PREFIX);
        int totalThreads = selfIsTaskWorker ? 3 : 4;
        try {
            if (selfIsTaskWorker) {
                graph.closeTx();
            } else {
                Consumers.executeOncePerThread(this.taskExecutor, totalThreads, graph::closeTx);
            }
        }
        catch (Exception e) {
            throw new HugeException("Exception when closing task tx", e);
        }
    }

    private void closeSchedulerTx(HugeGraphParams graph) {
        Callable<Void> closeTx = () -> {
            graph.closeTx();
            Thread.yield();
            return null;
        };
        try {
            this.schedulerExecutor.submit(closeTx).get();
        }
        catch (Exception e) {
            throw new HugeException("Exception when closing scheduler tx", e);
        }
    }

    public void pauseScheduledThreadPool() {
        this.schedulerExecutor.pauseSchedule();
    }

    public void resumeScheduledThreadPool() {
        this.schedulerExecutor.resumeSchedule();
    }

    public TaskScheduler getScheduler(HugeGraphParams graph) {
        return this.schedulers.get(graph);
    }

    public ServerInfoManager getServerInfoManager(HugeGraphParams graph) {
        StandardTaskScheduler scheduler = (StandardTaskScheduler)this.getScheduler(graph);
        if (scheduler == null) {
            return null;
        }
        return scheduler.serverManager();
    }

    public void shutdown(long timeout) {
        assert (this.schedulers.isEmpty()) : this.schedulers.size();
        Throwable ex = null;
        boolean terminated = this.schedulerExecutor.isTerminated();
        TimeUnit unit = TimeUnit.SECONDS;
        if (!this.schedulerExecutor.isShutdown()) {
            this.schedulerExecutor.shutdown();
            try {
                terminated = this.schedulerExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.taskExecutor.isShutdown()) {
            this.taskExecutor.shutdown();
            try {
                terminated = this.taskExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.serverInfoDbExecutor.isShutdown()) {
            this.serverInfoDbExecutor.shutdown();
            try {
                terminated = this.serverInfoDbExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.taskDbExecutor.isShutdown()) {
            this.taskDbExecutor.shutdown();
            try {
                terminated = this.taskDbExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (!terminated) {
            ex = new TimeoutException(timeout + "s");
        }
        if (ex != null) {
            throw new HugeException("Failed to wait for TaskScheduler", ex);
        }
    }

    public int workerPoolSize() {
        return ((ThreadPoolExecutor)this.taskExecutor).getCorePoolSize();
    }

    public int pendingTasks() {
        int size = 0;
        for (TaskScheduler scheduler : this.schedulers.values()) {
            size += scheduler.pendingTasks();
        }
        return size;
    }

    protected void notifyNewTask(HugeTask<?> task) {
        BlockingQueue<Runnable> queue = this.schedulerExecutor.getQueue();
        if (queue.size() <= 1) {
            this.schedulerExecutor.submit(this::scheduleOrExecuteJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scheduleOrExecuteJob() {
        try {
            for (TaskScheduler entry : this.schedulers.values()) {
                StandardTaskScheduler scheduler;
                StandardTaskScheduler standardTaskScheduler = scheduler = (StandardTaskScheduler)entry;
                synchronized (standardTaskScheduler) {
                    this.scheduleOrExecuteJobForGraph(scheduler);
                }
            }
            return;
        }
        catch (Throwable e) {
            LOG.error("Exception occurred when schedule job", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleOrExecuteJobForGraph(StandardTaskScheduler scheduler) {
        E.checkNotNull((Object)scheduler, (String)"scheduler");
        ServerInfoManager serverManager = scheduler.serverManager();
        String graph = scheduler.graphName();
        LockUtil.lock(graph, "graph_lock");
        try {
            if (!serverManager.graphReady()) {
                return;
            }
            serverManager.heartbeat();
            if (serverManager.master()) {
                scheduler.scheduleTasks();
                if (!serverManager.onlySingleNode()) {
                    return;
                }
            }
            scheduler.executeTasksOnWorker(serverManager.selfServerId());
            scheduler.cancelTasksOnWorker(serverManager.selfServerId());
        }
        finally {
            LockUtil.unlock(graph, "graph_lock");
        }
    }

    protected static void setContext(String context) {
        CONTEXTS.set(context);
    }

    protected static void resetContext() {
        CONTEXTS.remove();
    }

    public static String getContext() {
        return CONTEXTS.get();
    }

    public static class ContextCallable<V>
    implements Callable<V> {
        private final Callable<V> callable;
        private final String context;

        public ContextCallable(Callable<V> callable) {
            E.checkNotNull(callable, (String)"callable");
            this.context = TaskManager.getContext();
            this.callable = callable;
        }

        @Override
        public V call() throws Exception {
            TaskManager.setContext(this.context);
            try {
                V v = this.callable.call();
                return v;
            }
            finally {
                TaskManager.resetContext();
            }
        }
    }
}

