/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.id.SnowflakeIdGenerator;
import org.apache.hugegraph.backend.id.SplicingIdGenerator;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertexProperty;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyVertexProperty;

public class HugeVertex
extends HugeElement
implements Vertex,
Cloneable {
    private static final List<HugeEdge> EMPTY_LIST = ImmutableList.of();
    private Id id;
    private VertexLabel label;
    protected Collection<HugeEdge> edges;

    public HugeVertex(HugeGraph graph, Id id, VertexLabel label) {
        super(graph);
        E.checkArgumentNotNull((Object)label, (String)"Vertex label can't be null", (Object[])new Object[0]);
        this.label = label;
        this.id = id;
        this.edges = EMPTY_LIST;
        if (this.id != null) {
            if (label.idStrategy() == IdStrategy.CUSTOMIZE_UUID) {
                this.assignId(id);
            } else {
                this.checkIdLength();
            }
        }
    }

    @Override
    public HugeType type() {
        return HugeType.VERTEX;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public VertexLabel schemaLabel() {
        assert (VertexLabel.OLAP_VL.equals(this.label) || this.graph().sameAs(this.label.graph()));
        return this.label;
    }

    @Override
    public String name() {
        String name;
        E.checkState((this.label.idStrategy() == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"Only primary key vertex has name, but got '%s' with id strategy '%s'", (Object[])new Object[]{this, this.label.idStrategy()});
        if (this.id != null) {
            String[] parts = SplicingIdGenerator.parse(this.id);
            E.checkState((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid primary key vertex id '%s'", (Object[])new Object[]{this.id});
            name = parts[1];
        } else {
            assert (this.id == null);
            List<Object> propValues = this.primaryValues();
            E.checkState((!propValues.isEmpty() ? 1 : 0) != 0, (String)"Primary values must not be empty (has properties %s)", (Object[])new Object[]{this.hasProperties()});
            name = ConditionQuery.concatValues(propValues);
            E.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"The value of primary key can't be empty", (Object[])new Object[0]);
        }
        return name;
    }

    public void assignId(Id id) {
        this.assignId(id, false);
    }

    @PerfUtil.Watched(prefix="vertex")
    public void assignId(Id id, boolean force) {
        IdStrategy strategy = this.label.idStrategy();
        switch (strategy) {
            case CUSTOMIZE_STRING: {
                assert (!id.number());
                this.id = id;
                break;
            }
            case CUSTOMIZE_NUMBER: {
                assert (id.number());
                this.id = id;
                break;
            }
            case CUSTOMIZE_UUID: {
                this.id = id.uuid() ? id : IdGenerator.of(id.asString(), true);
                break;
            }
            case PRIMARY_KEY: {
                this.id = SplicingIdGenerator.instance().generate(this);
                break;
            }
            case AUTOMATIC: {
                if (force) {
                    assert (id.number());
                    this.id = id;
                    break;
                }
                this.id = SnowflakeIdGenerator.instance(this.graph()).generate(this);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown id strategy '%s'", strategy));
            }
        }
        this.checkIdLength();
    }

    protected void checkIdLength() {
        assert (this.id != null);
        int len = this.id.asBytes().length;
        if (len <= 128) {
            return;
        }
        E.checkArgument((boolean)false, (String)"The max length of vertex id is %s, but got %s {%s}", (Object[])new Object[]{128, len, this.id});
    }

    public String label() {
        return this.schemaLabel().name();
    }

    public void correctVertexLabel(VertexLabel correctLabel) {
        E.checkArgumentNotNull((Object)correctLabel, (String)"Vertex label can't be null", (Object[])new Object[0]);
        if (this.label != null && !this.label.undefined() && !correctLabel.undefined()) {
            E.checkArgument((boolean)this.label.equals(correctLabel), (String)"Vertex label can't be changed from '%s' to '%s'", (Object[])new Object[]{this.label, correctLabel});
        }
        this.label = correctLabel;
    }

    @PerfUtil.Watched(prefix="vertex")
    protected List<Object> primaryValues() {
        E.checkArgument((this.label.idStrategy() == IdStrategy.PRIMARY_KEY ? 1 : 0) != 0, (String)"The id strategy '%s' don't have primary keys", (Object[])new Object[]{this.label.idStrategy()});
        List<Id> primaryKeys = this.label.primaryKeys();
        E.checkArgument((!primaryKeys.isEmpty() ? 1 : 0) != 0, (String)"Primary key can't be empty for id strategy '%s'", (Object[])new Object[]{IdStrategy.PRIMARY_KEY});
        boolean encodeNumber = (Boolean)this.graph().option(CoreOptions.VERTEX_ENCODE_PK_NUMBER);
        ArrayList<Object> propValues = new ArrayList<Object>(primaryKeys.size());
        for (Id pk : primaryKeys) {
            HugeProperty property = this.getProperty(pk);
            E.checkState((property != null ? 1 : 0) != 0, (String)"The value of primary key '%s' can't be null", (Object[])new Object[]{this.graph().propertyKey(pk).name()});
            Object propValue = property.serialValue(encodeNumber);
            if ("".equals(propValue)) {
                propValue = ConditionQuery.INDEX_VALUE_EMPTY;
            }
            propValues.add(propValue);
        }
        return propValues;
    }

    public boolean existsEdges() {
        return this.edges.size() > 0;
    }

    public Collection<HugeEdge> getEdges() {
        return Collections.unmodifiableCollection(this.edges);
    }

    public void resetEdges() {
        this.edges = HugeVertex.newList();
    }

    public void removeEdge(HugeEdge edge) {
        this.edges.remove(edge);
    }

    public void addEdge(HugeEdge edge) {
        if (this.edges == EMPTY_LIST) {
            this.edges = HugeVertex.newList();
        }
        this.edges.add(edge);
    }

    @PerfUtil.Watched(prefix="vertex")
    public HugeEdge addEdge(String label, Vertex vertex, Object ... keyValues) {
        HugeVertex targetVertex = (HugeVertex)vertex;
        HugeEdge edge = this.constructEdge(label, targetVertex, keyValues);
        this.addOutEdge(edge);
        targetVertex.addInEdge(edge.switchOwner());
        if (this.fresh()) {
            this.graph().canAddEdge(edge);
            return this.tx().addEdge(edge);
        }
        return (HugeEdge)this.graph().addEdge(edge);
    }

    public HugeEdge constructEdge(String label, HugeVertex vertex, Object ... keyValues) {
        HugeElement.ElementKeys elemKeys = HugeVertex.classifyKeys(keyValues);
        if (elemKeys.id() != null) {
            throw Edge.Exceptions.userSuppliedIdsNotSupported();
        }
        Id id = null;
        E.checkArgumentNotNull((Object)vertex, (String)"Target vertex can't be null", (Object[])new Object[0]);
        E.checkArgument((label != null && !label.isEmpty() ? 1 : 0) != 0, (String)"Edge label can't be null or empty", (Object[])new Object[0]);
        EdgeLabel edgeLabel = this.graph().edgeLabel(label);
        E.checkArgument((boolean)edgeLabel.checkLinkEqual(this.schemaLabel().id(), vertex.schemaLabel().id()), (String)"Undefined link of edge label '%s': '%s' -> '%s'", (Object[])new Object[]{label, this.label(), vertex.label()});
        List<Id> keys = this.graph().mapPkName2Id(elemKeys.keys());
        E.checkArgument((boolean)new HashSet<Id>(keys).containsAll(edgeLabel.sortKeys()), (String)"The sort key(s) must be set for the edge with label: '%s'", (Object[])new Object[]{edgeLabel.name()});
        Collection nonNullKeys = CollectionUtils.subtract(edgeLabel.properties(), edgeLabel.nullableKeys());
        if (!new HashSet<Id>(keys).containsAll(nonNullKeys)) {
            Collection missed = CollectionUtils.subtract((Collection)nonNullKeys, keys);
            E.checkArgument((boolean)false, (String)"All non-null property keys: %s of edge label '%s' must be set, but missed keys: %s", (Object[])new Object[]{this.graph().mapPkId2Name(nonNullKeys), edgeLabel.name(), this.graph().mapPkId2Name(missed)});
        }
        HugeEdge edge = new HugeEdge(this, id, edgeLabel, vertex);
        ElementHelper.attachProperties((Element)edge, (Object[])keyValues);
        edge.assignId();
        return edge;
    }

    @PerfUtil.Watched
    public void addOutEdge(HugeEdge edge) {
        if (edge.ownerVertex() == null) {
            edge.sourceVertex(this);
        }
        E.checkState((boolean)edge.isDirection(Directions.OUT), (String)"The owner vertex('%s') of OUT edge '%s' should be '%s'", (Object[])new Object[]{edge.ownerVertex().id(), edge, this.id()});
        this.addEdge(edge);
    }

    @PerfUtil.Watched
    public void addInEdge(HugeEdge edge) {
        if (edge.ownerVertex() == null) {
            edge.targetVertex(this);
        }
        E.checkState((boolean)edge.isDirection(Directions.IN), (String)"The owner vertex('%s') of IN edge '%s' should be '%s'", (Object[])new Object[]{edge.ownerVertex().id(), edge, this.id()});
        this.addEdge(edge);
    }

    public Iterator<Edge> getEdges(Directions direction, String ... edgeLabels) {
        LinkedList<HugeEdge> list = new LinkedList<HugeEdge>();
        for (HugeEdge edge : this.edges) {
            if (!edge.matchDirection(direction) || !edge.belongToLabels(edgeLabels)) continue;
            list.add(edge);
        }
        return list.iterator();
    }

    public Iterator<Vertex> getVertices(Directions direction, String ... edgeLabels) {
        LinkedList<HugeVertex> list = new LinkedList<HugeVertex>();
        Iterator<Edge> edges = this.getEdges(direction, edgeLabels);
        while (edges.hasNext()) {
            HugeEdge edge = (HugeEdge)edges.next();
            list.add(edge.otherVertex(this));
        }
        return list.iterator();
    }

    @PerfUtil.Watched(prefix="vertex")
    public Iterator<Edge> edges(Direction tinkerpopDir, String ... edgeLabels) {
        Directions direction = Directions.convert(tinkerpopDir);
        if (this.existsEdges()) {
            return this.getEdges(direction, edgeLabels);
        }
        Id[] edgeLabelIds = this.graph().mapElName2Id(edgeLabels);
        ConditionQuery query = GraphTransaction.constructEdgesQuery(this.id(), direction, edgeLabelIds);
        return this.graph().edges(query);
    }

    @PerfUtil.Watched(prefix="vertex")
    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        Iterator<Edge> edges = this.edges(direction, edgeLabels);
        return this.graph().adjacentVertices(edges);
    }

    @PerfUtil.Watched(prefix="vertex")
    public void remove() {
        this.removed(true);
        GraphTransaction tx = this.tx();
        if (tx != null) {
            assert (this.fresh());
            tx.removeVertex(this);
        } else {
            assert (!this.fresh());
            this.graph().removeVertex(this);
        }
    }

    @PerfUtil.Watched(prefix="vertex")
    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... objects) {
        if (objects.length != 0 && objects[0].equals(T.id)) {
            throw VertexProperty.Exceptions.userSuppliedIdsNotSupported();
        }
        if (objects.length != 0) {
            throw VertexProperty.Exceptions.metaPropertiesNotSupported();
        }
        PropertyKey propertyKey = this.graph().propertyKey(key);
        if (cardinality != VertexProperty.Cardinality.single) {
            E.checkArgument((propertyKey.cardinality() == Cardinality.convert(cardinality) ? 1 : 0) != 0, (String)"Invalid cardinality '%s' for property key '%s', expect '%s'", (Object[])new Object[]{cardinality, key, propertyKey.cardinality().string()});
        }
        E.checkArgument((VertexLabel.OLAP_VL.equals(this.label) || this.label.properties().contains(propertyKey.id()) ? 1 : 0) != 0, (String)"Invalid property '%s' for vertex label '%s'", (Object[])new Object[]{key, this.label});
        if (this.schemaLabel().primaryKeys().contains(propertyKey.id())) {
            E.checkArgument((!this.hasProperty(propertyKey.id()) ? 1 : 0) != 0, (String)"Can't update primary key: '%s'", (Object[])new Object[]{key});
        }
        if (value == null) {
            this.removeProperty(propertyKey.id());
            return EmptyVertexProperty.instance();
        }
        VertexProperty prop = (VertexProperty)this.addProperty(propertyKey, value, !this.fresh());
        return prop;
    }

    @Override
    protected GraphTransaction tx() {
        return null;
    }

    @PerfUtil.Watched(prefix="vertex")
    protected <V> HugeVertexProperty<V> newProperty(PropertyKey pkey, V val) {
        return new HugeVertexProperty<V>(this, pkey, val);
    }

    @Override
    @PerfUtil.Watched(prefix="vertex")
    protected <V> void onUpdateProperty(Cardinality cardinality, HugeProperty<V> prop) {
        if (prop != null) {
            assert (prop instanceof HugeVertexProperty);
            GraphTransaction tx = this.tx();
            if (tx != null) {
                assert (this.fresh());
                tx.addVertexProperty((HugeVertexProperty)prop);
            } else {
                assert (!this.fresh());
                this.graph().addVertexProperty((HugeVertexProperty)prop);
            }
        }
    }

    @Override
    @PerfUtil.Watched(prefix="vertex")
    protected boolean ensureFilledProperties(boolean throwIfNotExist) {
        if (this.isPropLoaded()) {
            this.updateToDefaultValueIfNone();
            return true;
        }
        if (this.schemaLabel().properties().isEmpty()) {
            this.propLoaded();
            return true;
        }
        Iterator<Vertex> vertices = this.graph().adjacentVertex(this.id());
        HugeVertex vertex = (HugeVertex)QueryResults.one(vertices);
        if (vertex == null && !throwIfNotExist) {
            return false;
        }
        E.checkState((vertex != null ? 1 : 0) != 0, (String)"Vertex '%s' does not exist", (Object[])new Object[]{this.id});
        if (vertex.schemaLabel().undefined() || !vertex.schemaLabel().equals(this.schemaLabel())) {
            this.correctVertexLabel(VertexLabel.undefined(this.graph()));
            vertex.resetProperties();
        }
        this.copyProperties(vertex);
        this.updateToDefaultValueIfNone();
        return true;
    }

    @PerfUtil.Watched(prefix="vertex")
    public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
        this.ensureFilledProperties(true);
        int propsCapacity = keys.length == 0 ? this.sizeOfProperties() : keys.length;
        ArrayList<VertexProperty> props = new ArrayList<VertexProperty>(propsCapacity);
        if (keys.length == 0) {
            for (HugeProperty<?> prop : this.getProperties()) {
                assert (prop instanceof VertexProperty);
                props.add((VertexProperty)prop);
            }
        } else {
            for (String key : keys) {
                Id pkeyId;
                try {
                    pkeyId = this.graph().propertyKey(key).id();
                }
                catch (IllegalArgumentException ignored) {
                    continue;
                }
                HugeProperty prop = this.getProperty(pkeyId);
                if (prop == null) continue;
                assert (prop instanceof VertexProperty);
                props.add((VertexProperty)prop);
            }
        }
        return props.iterator();
    }

    @Override
    public Object sysprop(HugeKeys key) {
        switch (key) {
            case ID: {
                return this.id();
            }
            case LABEL: {
                return this.schemaLabel().id();
            }
            case PRIMARY_VALUES: {
                return this.name();
            }
            case PROPERTIES: {
                return this.getPropertiesMap();
            }
        }
        E.checkArgument((boolean)false, (String)"Invalid system property '%s' of Vertex", (Object[])new Object[]{key});
        return null;
    }

    public boolean valid() {
        try {
            return this.ensureFilledProperties(false);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public HugeVertex prepareRemoved() {
        HugeVertex vertex = this.clone();
        vertex.removed(true);
        vertex.resetEdges();
        vertex.resetProperties();
        return vertex;
    }

    public boolean olap() {
        return this.label.olap();
    }

    @Override
    public HugeVertex copy() {
        HugeVertex vertex = this.clone();
        vertex.copyProperties(this);
        return vertex;
    }

    protected HugeVertex clone() {
        try {
            return (HugeVertex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HugeException("Failed to clone HugeVertex", e);
        }
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public static final Id getIdValue(Object idValue) {
        return HugeElement.getIdValue(idValue);
    }

    public static HugeVertex undefined(HugeGraph graph, Id id) {
        VertexLabel label = VertexLabel.undefined(graph);
        return new HugeVertex(graph, id, label);
    }

    public static HugeVertex create(GraphTransaction tx, Id id, VertexLabel label) {
        return new HugeVertex4Insert(tx, id, label);
    }

    private static <V> Set<V> newSet() {
        return CollectionFactory.newSet(CollectionType.EC);
    }

    private static <V> List<V> newList() {
        return CollectionFactory.newList(CollectionType.EC);
    }

    private static final class HugeVertex4Insert
    extends HugeVertex {
        private GraphTransaction tx;

        public HugeVertex4Insert(GraphTransaction tx, Id id, VertexLabel label) {
            super(tx.graph(), id, label);
            this.edges = HugeVertex.newSet();
            this.tx = tx;
            this.fresh(true);
        }

        @Override
        public void resetEdges() {
            this.edges = HugeVertex.newSet();
        }

        @Override
        public void addEdge(HugeEdge edge) {
            if (this.edges == EMPTY_LIST) {
                this.edges = HugeVertex.newSet();
            }
            this.edges.add(edge);
        }

        @Override
        public void committed() {
            super.committed();
            this.tx = null;
        }

        @Override
        protected GraphTransaction tx() {
            if (this.fresh()) {
                E.checkNotNull((Object)this.tx, (String)"tx");
                return this.tx;
            }
            return null;
        }
    }
}

