/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.comm;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.exception.ExistedException;
import org.apache.hugegraph.iterator.ListIterator;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.Consumers;
import org.apache.hugegraph.job.algorithm.comm.LouvainAlgorithm;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public class LouvainTraverser
extends AbstractAlgorithm.AlgoTraverser {
    public static final String C_PASS = "c_pass-";
    public static final String C_KIN = "c_kin";
    public static final String C_WEIGHT = "c_weight";
    public static final String C_MEMBERS = "c_members";
    private static final long LIMIT = 100000000L;
    private static final int MAX_COMM_SIZE = 100000;
    private static final Logger LOG = Log.logger(LouvainTraverser.class);
    private final GraphTraversalSource g = this.graph().traversal();
    private final String sourceLabel;
    private final String sourceCLabel;
    private final long degree;
    private final boolean skipIsolated;
    private final Cache cache;
    private long m;
    private String passLabel;

    public LouvainTraverser(UserJob<Object> job, int workers, long degree, String sourceLabel, String sourceCLabel, boolean skipIsolated) {
        super(job, "louvain", workers);
        this.sourceLabel = sourceLabel;
        this.sourceCLabel = sourceCLabel;
        this.degree = degree;
        this.skipIsolated = skipIsolated;
        this.m = 1L;
        this.passLabel = "";
        this.cache = new Cache();
    }

    private void defineSchemaOfPk() {
        String label = this.labelOfPassN(0);
        if (this.graph().existsVertexLabel(label) || this.graph().existsEdgeLabel(label)) {
            throw new IllegalArgumentException("Please clear historical results before proceeding");
        }
        SchemaManager schema = this.graph().schema();
        schema.propertyKey(C_KIN).asInt().ifNotExist().create();
        schema.propertyKey(C_MEMBERS).valueSet().asText().ifNotExist().create();
        schema.propertyKey(C_WEIGHT).asFloat().ifNotExist().create();
        this.m = (Long)this.g.E(new Object[0]).count().next();
    }

    private void defineSchemaOfPassN(int pass) {
        this.passLabel = this.labelOfPassN(pass);
        SchemaManager schema = this.graph().schema();
        try {
            schema.vertexLabel(this.passLabel).useCustomizeStringId().properties(C_KIN, C_MEMBERS, C_WEIGHT).create();
            schema.edgeLabel(this.passLabel).sourceLabel(this.passLabel).targetLabel(this.passLabel).properties(C_WEIGHT).create();
        }
        catch (ExistedException e) {
            throw new IllegalArgumentException("Please clear historical results before proceeding", e);
        }
    }

    private List<String> cpassEdgeLabels() {
        ArrayList<String> names = new ArrayList<String>();
        for (SchemaLabel schemaLabel : this.graph().schema().getEdgeLabels()) {
            String name = schemaLabel.name();
            if (!name.startsWith(C_PASS)) continue;
            names.add(name);
        }
        return names;
    }

    private List<String> cpassVertexLabels() {
        ArrayList<String> names = new ArrayList<String>();
        for (SchemaLabel schemaLabel : this.graph().schema().getVertexLabels()) {
            String name = schemaLabel.name();
            if (!name.startsWith(C_PASS)) continue;
            names.add(name);
        }
        return names;
    }

    private String labelOfPassN(int n) {
        return C_PASS + n;
    }

    private float weightOfEdge(Edge e) {
        if (e.label().startsWith(C_PASS)) {
            assert (e.property(C_WEIGHT).isPresent());
            return ((Float)e.value(C_WEIGHT)).floatValue();
        }
        if (e.property(C_WEIGHT).isPresent()) {
            return ((Float)e.value(C_WEIGHT)).floatValue();
        }
        return 1.0f;
    }

    private float weightOfEdges(List<Edge> edges) {
        float weight = 0.0f;
        for (Edge edge : edges) {
            weight += this.weightOfEdge(edge);
        }
        return weight;
    }

    private Vertex newCommunityNode(Id cid, float cweight, int kin, List<String> members) {
        assert (!members.isEmpty()) : members;
        return this.graph().addVertex(T.label, this.passLabel, T.id, cid, C_WEIGHT, Float.valueOf(cweight), C_KIN, kin, C_MEMBERS, members);
    }

    private Vertex makeCommunityNode(Id cid) {
        VertexLabel vl = this.graph().vertexLabel(this.passLabel);
        return new HugeVertex(this.graph(), cid, vl);
    }

    private Edge newCommunityEdge(Vertex source, Vertex target, float weight) {
        return source.addEdge(this.passLabel, target, new Object[]{C_WEIGHT, Float.valueOf(weight)});
    }

    private void insertNewCommunity(int pass, Id cid, float cweight, int kin, List<String> members, Map<Id, MutableFloat> cedges) {
        Id vid = this.cache.genId(pass, cid);
        Vertex node = this.newCommunityNode(vid, cweight, kin, members);
        this.commitIfNeeded();
        for (Map.Entry<Id, MutableFloat> e : cedges.entrySet()) {
            float weight = e.getValue().floatValue();
            vid = this.cache.genId(pass, e.getKey());
            Vertex targetV = this.makeCommunityNode(vid);
            this.newCommunityEdge(node, targetV, weight);
            this.commitIfNeeded();
        }
        LOG.debug("Add new comm: {} kin={} size={}", new Object[]{node, kin, members.size()});
    }

    private boolean needSkipVertex(int pass, Vertex v) {
        String label = v.label();
        if (label.startsWith(C_PASS)) {
            if (pass == 0) {
                return true;
            }
            String lastPassLabel = this.labelOfPassN(pass - 1);
            if (!label.equals(lastPassLabel)) {
                return true;
            }
        }
        return this.sourceCLabel != null && !this.match((Element)v, this.sourceCLabel);
    }

    private Iterator<Vertex> sourceVertices(int pass) {
        if (pass > 0) {
            String lastPassLabel = this.labelOfPassN(pass - 1);
            return this.vertices(lastPassLabel, 100000000L);
        }
        assert (pass == 0);
        return this.vertices(this.sourceLabel, 100000000L);
    }

    private List<Edge> neighbors(Id vid) {
        Iterator<Edge> nbs = this.edgesOfVertex(vid, Directions.BOTH, (Id)null, this.degree);
        ListIterator list = new ListIterator(100000000L, nbs);
        return (List)list.list();
    }

    private float weightOfVertex(Vertex v, List<Edge> edges) {
        Float value = this.cache.vertexWeight((Id)v.id());
        if (value != null) {
            return value.floatValue();
        }
        if (edges == null) {
            edges = this.neighbors((Id)v.id());
        }
        float weight = this.weightOfEdges(edges);
        this.cache.vertexWeight((Id)v.id(), weight);
        return weight;
    }

    private int kinOfVertex(Vertex v) {
        if (v.label().startsWith(C_PASS) && v.property(C_KIN).isPresent()) {
            return (Integer)v.value(C_KIN);
        }
        return 0;
    }

    private float cweightOfVertex(Vertex v) {
        if (v.label().startsWith(C_PASS) && v.property(C_WEIGHT).isPresent()) {
            return ((Float)v.value(C_WEIGHT)).floatValue();
        }
        return 1.0f;
    }

    private Community communityOfVertex(Vertex v, List<Edge> nbs) {
        Id vid = (Id)v.id();
        Community c = this.cache.vertex2Community(vid);
        if (c == null) {
            c = this.wrapCommunity(v, nbs);
            assert (c != null);
        }
        return c;
    }

    private Community wrapCommunity(Vertex v, List<Edge> nbs) {
        Id vid = (Id)v.id();
        Community comm = this.cache.vertex2Community(vid);
        if (comm != null) {
            return comm;
        }
        comm = new Community(vid);
        comm.add(this, v, nbs);
        comm = this.cache.vertex2CommunityIfAbsent(vid, comm);
        return comm;
    }

    private Collection<Pair<Community, MutableInt>> nbCommunities(int pass, List<Edge> edges) {
        HashMap<Id, Pair> comms = new HashMap<Id, Pair>();
        for (Edge edge : edges) {
            HugeVertex otherV = ((HugeEdge)edge).otherVertex();
            if (this.needSkipVertex(pass, otherV)) continue;
            Community c = this.wrapCommunity(otherV, null);
            if (!comms.containsKey(c.cid)) {
                comms.put(c.cid, Pair.of((Object)c, (Object)new MutableInt(0)));
            }
            ((MutableInt)((Pair)comms.get(c.cid)).getRight()).add((Number)Float.valueOf(2.0f * this.weightOfEdge(edge)));
        }
        return comms.values();
    }

    private void doMoveCommunity(Vertex v, List<Edge> nbs, Community newC) {
        Id vid = (Id)v.id();
        Community oldC = this.cache.vertex2Community(vid, newC);
        if (oldC != null) {
            oldC.remove(this, v, nbs);
        }
        newC.add(this, v, nbs);
        LOG.debug("Move {} to community: {}", (Object)v, (Object)newC);
    }

    private boolean moveCommunity(Vertex v, int pass) {
        List<Edge> nbs = this.neighbors((Id)v.id());
        if (this.skipIsolated && pass == 0 && nbs.isEmpty()) {
            return false;
        }
        Community c = this.communityOfVertex(v, nbs);
        double ki = (float)this.kinOfVertex(v) + this.weightOfVertex(v, nbs);
        double maxDeltaQ = 0.0;
        Community bestComm = null;
        for (Pair<Community, MutableInt> nbc : this.nbCommunities(pass, nbs)) {
            double deltaQ;
            Community otherC = (Community)nbc.getLeft();
            if (otherC.size() >= 100000) {
                LOG.info("Skip community {} for {} due to its size >= {}", new Object[]{otherC.cid, v, 100000});
                continue;
            }
            double kiin = ((MutableInt)nbc.getRight()).floatValue();
            double tot = (float)otherC.kin() + otherC.kout();
            if (c.equals(otherC)) {
                assert (c == otherC);
                if (tot < ki) {
                    LOG.warn("Changing vertex: {}(ki={}, kiin={}, pass={}), otherC: {}", new Object[]{v, ki, kiin, pass, otherC});
                }
                if ((tot -= ki) < 0.0) {
                    tot = 0.0;
                }
            }
            if (!((deltaQ = kiin - ki * tot / (double)this.m) > maxDeltaQ)) continue;
            maxDeltaQ = deltaQ;
            bestComm = otherC;
        }
        if (maxDeltaQ > 0.0 && !c.equals(bestComm)) {
            this.doMoveCommunity(v, nbs, bestComm);
            return true;
        }
        return false;
    }

    private double moveCommunities(int pass) {
        LOG.info("Detect community for pass {}", (Object)pass);
        Iterator<Vertex> vertices = this.sourceVertices(pass);
        long total = 0L;
        AtomicLong moved = new AtomicLong(0L);
        Consumers<Vertex> consumers = new Consumers<Vertex>(this.executor, v -> {
            if (this.moveCommunity((Vertex)v, pass)) {
                moved.incrementAndGet();
            }
        });
        consumers.start("louvain-move-pass-" + pass);
        try {
            while (vertices.hasNext()) {
                this.updateProgress(++this.progress);
                Vertex v2 = vertices.next();
                if (this.needSkipVertex(pass, v2)) continue;
                ++total;
                consumers.provide(v2);
            }
        }
        catch (Throwable e) {
            throw Consumers.wrapException(e);
        }
        finally {
            consumers.await();
        }
        return total == 0L ? 0.0 : moved.doubleValue() / (double)total;
    }

    private void mergeCommunities(int pass) {
        LOG.info("Merge community for pass {}", (Object)pass);
        Collection<Pair<Community, Set<Id>>> comms = this.cache.communities();
        assert (this.skipIsolated || this.allMembersExist(comms, pass - 1));
        this.cache.resetVertexWeight();
        Consumers<Pair> consumers = new Consumers<Pair>(this.executor, pair -> this.mergeCommunity(pass, (Community)pair.getLeft(), (Set)pair.getRight()), () -> this.graph().tx().commit());
        consumers.start("louvain-merge-pass-" + pass);
        try {
            for (Pair<Community, Set<Id>> pair2 : comms) {
                Community c = (Community)pair2.getLeft();
                if (c.empty()) continue;
                this.progress += (long)((Set)pair2.getRight()).size();
                this.updateProgress(this.progress);
                consumers.provide(pair2);
            }
        }
        catch (Throwable e) {
            throw Consumers.wrapException(e);
        }
        finally {
            consumers.await();
        }
        this.graph().tx().commit();
        assert (this.skipIsolated || this.allMembersExist(pass));
        this.cache.reset();
    }

    private void mergeCommunity(int pass, Community c, Set<Id> cvertices) {
        int kin = c.kin();
        int membersSize = cvertices.size();
        assert (!cvertices.isEmpty());
        assert (membersSize == c.size());
        ArrayList<String> members = new ArrayList<String>(membersSize);
        HashMap<Id, MutableFloat> cedges = new HashMap<Id, MutableFloat>(membersSize);
        for (Id v : cvertices) {
            members.add(v.toString());
            List<Edge> neighbors = this.neighbors(v);
            for (Edge edge : neighbors) {
                HugeVertex otherV = ((HugeEdge)edge).otherVertex();
                if (cvertices.contains(otherV.id())) {
                    kin += (int)this.weightOfEdge(edge);
                    continue;
                }
                assert (this.cache.vertex2Community(otherV.id()) != null);
                Id otherCid = this.communityOfVertex(otherV, null).cid;
                if (otherCid.compareTo(c.cid) < 0) continue;
                if (!cedges.containsKey(otherCid)) {
                    cedges.putIfAbsent(otherCid, new MutableFloat(0.0f));
                }
                ((MutableFloat)cedges.get(otherCid)).add(this.weightOfEdge(edge));
            }
        }
        this.insertNewCommunity(pass, c.cid, c.weight(), kin, members, cedges);
    }

    private boolean allMembersExist(Collection<Pair<Community, Set<Id>>> comms, int lastPass) {
        String lastLabel = this.labelOfPassN(lastPass);
        GraphTraversal t = lastPass < 0 ? this.g.V(new Object[0]).id() : this.g.V(new Object[0]).hasLabel(lastLabel, new String[0]).id();
        Set all = this.execute(t, () -> ((GraphTraversal)t).toSet());
        for (Pair<Community, Set<Id>> comm : comms) {
            all.removeAll((Collection)comm.getRight());
        }
        if (all.size() > 0) {
            LOG.warn("Lost members of last pass: {}", (Object)all);
        }
        return all.isEmpty();
    }

    private boolean allMembersExist(int pass) {
        boolean allExist;
        String label = this.labelOfPassN(pass);
        int lastPass = pass - 1;
        Number expected = lastPass < 0 ? (Number)(this.tryNext(this.g.V(new Object[0]).count()).longValue() - this.tryNext(this.g.V(new Object[0]).hasLabel(label, new String[0]).count()).longValue()) : (Number)this.tryNext(this.g.V(new Object[0]).hasLabel(this.labelOfPassN(lastPass), new String[0]).values(new String[]{C_WEIGHT}).sum());
        Number actual = this.tryNext(this.g.V(new Object[0]).hasLabel(label, new String[0]).values(new String[]{C_WEIGHT}).sum());
        boolean bl = allExist = actual.floatValue() == expected.floatValue();
        assert (allExist) : actual + "!=" + expected;
        return allExist;
    }

    public Object louvain(int maxTimes, int stableTimes, double precision) {
        assert (maxTimes > 0);
        assert (precision > 0.0);
        this.defineSchemaOfPk();
        int times = maxTimes;
        int movedTimes = 0;
        double movedPercent = 0.0;
        for (int i = 0; i < maxTimes; ++i) {
            boolean finished = true;
            double lastMovedPercent = 1.0;
            int tinyChanges = 0;
            while (true) {
                double d;
                movedPercent = this.moveCommunities(i);
                if (!(d > 0.0)) break;
                ++movedTimes;
                finished = false;
                if (lastMovedPercent - movedPercent < precision) {
                    ++tinyChanges;
                }
                if (i == 0 && movedPercent < precision || tinyChanges >= stableTimes) break;
                lastMovedPercent = movedPercent;
            }
            if (finished) {
                times = i;
                break;
            }
            this.defineSchemaOfPassN(i);
            this.mergeCommunities(i);
        }
        Map results = InsertionOrderUtil.newMap();
        results.putAll(ImmutableMap.of((Object)"pass_times", (Object)times, (Object)"phase1_times", (Object)movedTimes, (Object)"last_precision", (Object)movedPercent, (Object)"times", (Object)maxTimes));
        Number communities = 0L;
        Number modularity = -1L;
        String commLabel = this.passLabel;
        if (!commLabel.isEmpty()) {
            communities = this.tryNext(this.g.V(new Object[0]).hasLabel(commLabel, new String[0]).count());
            modularity = this.modularity(commLabel);
        }
        results.putAll(ImmutableMap.of((Object)"communities", (Object)communities, (Object)"modularity", (Object)modularity));
        return results;
    }

    public double modularity(int pass) {
        String label = this.labelOfPassN(pass);
        return this.modularity(label);
    }

    private double modularity(String label) {
        Number kin = this.tryNext(this.g.V(new Object[0]).hasLabel(label, new String[0]).values(new String[]{C_KIN}).sum());
        Number weight = this.tryNext(this.g.E(new Object[0]).hasLabel(label, new String[0]).values(new String[]{C_WEIGHT}).sum());
        double m = (double)kin.intValue() + (double)weight.floatValue() * 2.0;
        double q = 0.0;
        Iterator<Vertex> comms = this.vertices(label, 100000000L);
        while (comms.hasNext()) {
            Vertex comm = comms.next();
            int cin = (Integer)comm.value(C_KIN);
            Number cout = this.tryNext(this.g.V(new Object[]{comm}).bothE(new String[0]).values(new String[]{C_WEIGHT}).sum());
            double cdegree = (float)cin + cout.floatValue();
            q += (double)cin / m - Math.pow(cdegree / m, 2.0);
        }
        return q;
    }

    public Collection<Object> showCommunity(String community) {
        String C_PASS0 = this.labelOfPassN(0);
        Collection<Object> comms = Collections.singletonList(community);
        boolean reachPass0 = false;
        while (comms.size() > 0 && !reachPass0) {
            Iterator<Vertex> subComms = this.vertices(comms.iterator());
            comms = new HashSet();
            while (subComms.hasNext()) {
                this.updateProgress(++this.progress);
                Vertex sub = subComms.next();
                if (!sub.property(C_MEMBERS).isPresent()) continue;
                Set members = (Set)sub.value(C_MEMBERS);
                reachPass0 = sub.label().equals(C_PASS0);
                comms.addAll(members);
            }
        }
        return comms;
    }

    public long exportCommunity(int pass, boolean vertexFirst) {
        String exportFile = String.format("%s/louvain-%s.txt", LouvainAlgorithm.EXPORT_PATH, this.jobId());
        String label = this.labelOfPassN(pass);
        GraphTraversal t = this.g.V(new Object[0]).hasLabel(label, new String[0]);
        this.execute(t, () -> {
            try (OutputStream os = Files.newOutputStream(Paths.get(exportFile, new String[0]), new OpenOption[0]);
                 BufferedOutputStream bos = new BufferedOutputStream(os);){
                block18: while (t.hasNext()) {
                    String comm = ((Vertex)t.next()).id().toString();
                    Collection<Object> members = this.showCommunity(comm);
                    if (vertexFirst) {
                        Iterator<Object> iterator = members.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block18;
                            Object member = iterator.next();
                            bos.write(StringEncoding.encode(member.toString()));
                            bos.write(StringEncoding.encode("\t"));
                            bos.write(StringEncoding.encode(comm));
                            bos.write(StringEncoding.encode("\n"));
                        }
                    }
                    bos.write(StringEncoding.encode(comm));
                    bos.write(StringEncoding.encode(": "));
                    bos.write(StringEncoding.encode(members.toString()));
                    bos.write(StringEncoding.encode("\n"));
                }
                return null;
            }
        });
        return this.progress;
    }

    public long clearPass(int pass) {
        GraphTraversal te = this.g.E(new Object[0]);
        if (pass < 0) {
            List<String> els = this.cpassEdgeLabels();
            if (els.size() > 0) {
                String first = els.remove(0);
                te = te.hasLabel(first, els.toArray(new String[0]));
                this.drop(te);
            }
            for (String label : this.cpassEdgeLabels()) {
                this.graph().schema().edgeLabel(label).remove();
            }
        } else {
            String label = this.labelOfPassN(pass);
            if (this.graph().existsEdgeLabel(label)) {
                te = te.hasLabel(label, new String[0]);
                this.drop(te);
                this.graph().schema().edgeLabel(label).remove();
            }
        }
        GraphTraversal tv = this.g.V(new Object[0]);
        if (pass < 0) {
            List<String> vls = this.cpassVertexLabels();
            if (vls.size() > 0) {
                String first = vls.remove(0);
                tv = tv.hasLabel(first, vls.toArray(new String[0]));
                this.drop(tv);
            }
            for (String label : this.cpassVertexLabels()) {
                this.graph().schema().vertexLabel(label).remove();
            }
        } else {
            String label = this.labelOfPassN(pass);
            if (this.graph().existsVertexLabel(label)) {
                tv = tv.hasLabel(label, new String[0]);
                this.drop(tv);
                this.graph().schema().vertexLabel(label).remove();
            }
        }
        return this.progress;
    }

    private static class Cache {
        private final Map<Id, Float> vertexWeightCache = new ConcurrentHashMap<Id, Float>();
        private final Map<Id, Community> vertex2Community = new ConcurrentHashMap<Id, Community>();
        private final Map<Id, Integer> genIds = new ConcurrentHashMap<Id, Integer>();

        public Community vertex2Community(Object id) {
            assert (id instanceof Id);
            return this.vertex2Community.get(id);
        }

        public Community vertex2Community(Id id, Community c) {
            return this.vertex2Community.put(id, c);
        }

        public Community vertex2CommunityIfAbsent(Id id, Community c) {
            Community old = this.vertex2Community.putIfAbsent(id, c);
            if (old != null) {
                c = old;
            }
            return c;
        }

        public Float vertexWeight(Id id) {
            return this.vertexWeightCache.get(id);
        }

        public void vertexWeight(Id id, float weight) {
            this.vertexWeightCache.put(id, Float.valueOf(weight));
        }

        public void reset() {
            this.vertexWeightCache.clear();
            this.vertex2Community.clear();
            this.genIds.clear();
        }

        public void resetVertexWeight() {
            this.vertexWeightCache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Id genId(int pass, Id cid) {
            Map<Id, Integer> map = this.genIds;
            synchronized (map) {
                if (!this.genIds.containsKey(cid)) {
                    this.genIds.putIfAbsent(cid, this.genIds.size() + 1);
                }
                String id = pass + "~" + this.genIds.get(cid);
                return IdGenerator.of(id);
            }
        }

        public Id genId2(int pass, Id cid) {
            String id = cid.toString();
            if (pass == 0) {
                id = pass + "~" + id;
            } else {
                String lastPass = String.valueOf(pass - 1);
                assert (id.startsWith(lastPass));
                id = id.substring(lastPass.length());
                id = pass + id;
            }
            return IdGenerator.of(id);
        }

        public Collection<Pair<Community, Set<Id>>> communities() {
            HashMap<Id, Pair> comms = new HashMap<Id, Pair>();
            for (Map.Entry<Id, Community> e : this.vertex2Community.entrySet()) {
                Community c = e.getValue();
                if (c.empty()) continue;
                Pair pair = comms.computeIfAbsent(c.cid, k -> Pair.of((Object)c, new HashSet()));
                ((Set)pair.getRight()).add(e.getKey());
            }
            return comms.values();
        }
    }

    private static class Community {
        private final Id cid;
        private int size = 0;
        private float weight = 0.0f;
        private int kin = 0;
        private float kout = 0.0f;

        public Community(Id cid) {
            this.cid = cid;
        }

        public boolean empty() {
            return this.size <= 0;
        }

        public int size() {
            return this.size;
        }

        public float weight() {
            return this.weight;
        }

        public synchronized void add(LouvainTraverser t, Vertex v, List<Edge> nbs) {
            ++this.size;
            this.weight += t.cweightOfVertex(v);
            this.kin += t.kinOfVertex(v);
            this.kout += t.weightOfVertex(v, nbs);
        }

        public synchronized void remove(LouvainTraverser t, Vertex v, List<Edge> nbs) {
            --this.size;
            this.weight -= t.cweightOfVertex(v);
            this.kin -= t.kinOfVertex(v);
            this.kout -= t.weightOfVertex(v, nbs);
        }

        public synchronized int kin() {
            return this.kin;
        }

        public synchronized float kout() {
            return this.kout;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Community)) {
                return false;
            }
            Community other = (Community)object;
            return Objects.equals(this.cid, other.cid);
        }

        public String toString() {
            return String.format("[%s](size=%s weight=%s kin=%s kout=%s)", this.cid, this.size, Float.valueOf(this.weight), this.kin, Float.valueOf(this.kout));
        }
    }
}

