/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.ram;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hugegraph.backend.store.ram.RamMap;
import org.apache.hugegraph.exception.NotSupportException;

public final class IntObjectMap<V>
implements RamMap {
    private static final float DEFAULT_INITIAL_FACTOR = 0.25f;
    private final int maxSize;
    private int currentSize;
    private Object[] array;

    public IntObjectMap(int size) {
        this.maxSize = size;
        this.currentSize = (int)((float)size * 0.25f);
        this.array = new Object[this.currentSize];
    }

    public V get(int key) {
        if (key >= this.currentSize) {
            return null;
        }
        return (V)this.array[key];
    }

    public void set(int key, V value) {
        if (key >= this.currentSize) {
            this.expandCapacity();
        }
        this.array[key] = value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, null);
    }

    @Override
    public long size() {
        return this.maxSize;
    }

    @Override
    public void writeTo(DataOutputStream buffer) throws IOException {
        throw new NotSupportException("IntObjectMap.writeTo");
    }

    @Override
    public void readFrom(DataInputStream buffer) throws IOException {
        throw new NotSupportException("IntObjectMap.readFrom");
    }

    private synchronized void expandCapacity() {
        if (this.currentSize == this.maxSize) {
            return;
        }
        this.currentSize = Math.min(this.currentSize * 2, this.maxSize);
        Object[] newArray = new Object[this.currentSize];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.clear();
        this.array = newArray;
    }
}

