/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.SupplyingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.EmptyTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class SideEffectCapStep<S, E>
extends SupplyingBarrierStep<S, E> {
    private List<String> sideEffectKeys;
    public transient Map<String, SideEffectCapable<Object, E>> sideEffectCapableSteps;

    public SideEffectCapStep(Traversal.Admin traversal, String sideEffectKey, String ... sideEffectKeys) {
        super(traversal);
        this.sideEffectKeys = new ArrayList<String>(1 + sideEffectKeys.length);
        this.sideEffectKeys.add(sideEffectKey);
        Collections.addAll(this.sideEffectKeys, sideEffectKeys);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.sideEffectKeys);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (String sideEffectKey : this.sideEffectKeys) {
            result ^= sideEffectKey.hashCode();
        }
        return result;
    }

    public List<String> getSideEffectKeys() {
        return this.sideEffectKeys;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    protected E supply() {
        if (null == this.sideEffectCapableSteps) {
            this.sideEffectCapableSteps = new HashMap<String, SideEffectCapable<Object, E>>();
            Traversal.Admin parentTraversal = this.getTraversal();
            while (!(parentTraversal instanceof EmptyTraversal)) {
                for (SideEffectCapable capableStep : TraversalHelper.getStepsOfAssignableClassRecursively(SideEffectCapable.class, parentTraversal)) {
                    if (!this.sideEffectKeys.contains(capableStep.getSideEffectKey()) || this.sideEffectCapableSteps.containsKey(capableStep.getSideEffectKey())) continue;
                    this.sideEffectCapableSteps.put(capableStep.getSideEffectKey(), capableStep);
                }
                if (this.sideEffectKeys.size() == this.sideEffectCapableSteps.size()) break;
                parentTraversal = parentTraversal.getParent().asStep().getTraversal();
            }
        }
        if (this.sideEffectKeys.size() == 1) {
            String sideEffectKey = this.sideEffectKeys.get(0);
            Object result = this.getTraversal().getSideEffects().get(sideEffectKey);
            SideEffectCapable<Object, E> sideEffectCapable = this.sideEffectCapableSteps.get(sideEffectKey);
            Object finalResult = null == sideEffectCapable ? result : sideEffectCapable.generateFinalResult(result);
            this.getTraversal().getSideEffects().set(sideEffectKey, finalResult);
            return (E)finalResult;
        }
        return (E)this.getMapOfSideEffects();
    }

    private Map<String, Object> getMapOfSideEffects() {
        TraversalSideEffects temp = this.getTraversal().getSideEffects();
        HashMap<String, Object> sideEffects = new HashMap<String, Object>();
        for (String sideEffectKey : this.sideEffectKeys) {
            if (!temp.exists(sideEffectKey)) continue;
            Object result = temp.get(sideEffectKey);
            SideEffectCapable<Object, E> sideEffectCapable = this.sideEffectCapableSteps.get(sideEffectKey);
            Object finalResult = null == sideEffectCapable ? result : sideEffectCapable.generateFinalResult(result);
            temp.set(sideEffectKey, finalResult);
            sideEffects.put(sideEffectKey, finalResult);
        }
        return sideEffects;
    }

    @Override
    public SideEffectCapStep<S, E> clone() {
        SideEffectCapStep clone = (SideEffectCapStep)super.clone();
        clone.sideEffectCapableSteps = null;
        return clone;
    }
}

