/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.http.client.utils.URIBuilder;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendSessionPool;
import org.apache.hugegraph.backend.store.mysql.MysqlOptions;
import org.apache.hugegraph.backend.store.mysql.MysqlUtil;
import org.apache.hugegraph.backend.store.mysql.ResultSetWrapper;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class MysqlSessions
extends BackendSessionPool {
    private static final Logger LOG = Log.logger(MysqlSessions.class);
    private static final String JDBC_PREFIX = "jdbc:";
    private static final int DROP_DB_TIMEOUT = 10000;
    private HugeConfig config;
    private String database;
    private volatile boolean opened;

    public MysqlSessions(HugeConfig config, String database, String store) {
        super(config, database + "/" + store);
        this.config = config;
        this.database = database;
        this.opened = false;
    }

    public HugeConfig config() {
        return this.config;
    }

    public String database() {
        return this.database;
    }

    public String escapedDatabase() {
        return MysqlUtil.escapeString(this.database());
    }

    public synchronized void open() throws Exception {
        try (Connection conn = this.open(false);){
            this.opened = true;
        }
    }

    protected boolean opened() {
        return this.opened;
    }

    protected void doClose() {
    }

    public Session session() {
        return (Session)super.getOrNewSession();
    }

    protected Session newSession() {
        return new Session();
    }

    public void createDatabase() {
        block14: {
            LOG.debug("Create database: {}", (Object)this.database());
            String sql = this.buildCreateDatabase(this.database());
            try (Connection conn = this.openWithoutDB(0);){
                conn.createStatement().execute(sql);
            }
            catch (SQLException e) {
                if (e.getMessage().endsWith("already exists")) break block14;
                throw new BackendException("Failed to create database '%s'", (Throwable)e, new Object[]{this.database()});
            }
        }
    }

    public void dropDatabase() {
        LOG.debug("Drop database: {}", (Object)this.database());
        String sql = this.buildDropDatabase(this.database());
        try (Connection conn = this.openWithoutDB(10000);){
            conn.createStatement().execute(sql);
        }
        catch (SQLException e) {
            if (e.getCause() instanceof SocketTimeoutException) {
                LOG.warn("Drop database '{}' timeout", (Object)this.database());
            }
            throw new BackendException("Failed to drop database '%s'", (Throwable)e, new Object[]{this.database()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsDatabase() {
        try (Connection conn = this.openWithoutDB(0);
             ResultSet result = conn.getMetaData().getCatalogs();){
            String dbName;
            do {
                if (!result.next()) return false;
            } while (!(dbName = result.getString(1)).equals(this.database()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new BackendException("Failed to obtain database info", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean existsTable(String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void resetConnections() {
        this.forceResetSessions();
    }

    protected String buildCreateDatabase(String database) {
        return String.format("CREATE DATABASE IF NOT EXISTS %s DEFAULT CHARSET utf8 COLLATE utf8_bin;", database);
    }

    protected String buildDropDatabase(String database) {
        return String.format("DROP DATABASE IF EXISTS %s;", database);
    }

    protected String buildExistsTable(String table) {
        return String.format("SELECT * FROM information_schema.tables WHERE table_schema = '%s' AND table_name = '%s' LIMIT 1;", this.escapedDatabase(), MysqlUtil.escapeString(table));
    }

    protected Connection openWithoutDB(int timeout) {
        String url = this.buildUri(false, false, false, timeout);
        try {
            return this.connect(url);
        }
        catch (SQLException e) {
            throw new BackendException("Failed to access %s", (Throwable)e, new Object[]{url});
        }
    }

    protected Connection openWithDB(int timeout) {
        String url = this.buildUri(false, true, false, timeout);
        try {
            return this.connect(url);
        }
        catch (SQLException e) {
            throw new BackendException("Failed to access %s", (Throwable)e, new Object[]{url});
        }
    }

    private Connection open(boolean autoReconnect) throws SQLException {
        String url = this.buildUri(true, true, autoReconnect, null);
        return this.connect(url);
    }

    protected String buildUri(boolean withConnParams, boolean withDB, boolean autoReconnect, Integer timeout) {
        URIBuilder builder;
        String url = this.buildUrlPrefix(withDB);
        boolean forcedAutoReconnect = (Boolean)this.config.get(MysqlOptions.JDBC_FORCED_AUTO_RECONNECT);
        int maxTimes = (Integer)this.config.get(MysqlOptions.JDBC_RECONNECT_MAX_TIMES);
        int interval = (Integer)this.config.get(MysqlOptions.JDBC_RECONNECT_INTERVAL);
        String sslMode = (String)this.config.get(MysqlOptions.JDBC_SSL_MODE);
        E.checkArgument((boolean)url.startsWith(JDBC_PREFIX), (String)"The url must start with '%s': '%s'", (Object[])new Object[]{JDBC_PREFIX, url});
        String urlWithoutJdbc = url.substring(JDBC_PREFIX.length());
        try {
            builder = this.newConnectionURIBuilder(urlWithoutJdbc);
        }
        catch (URISyntaxException e) {
            throw new BackendException("Invalid url '%s'", (Throwable)e, new Object[]{url});
        }
        if (forcedAutoReconnect) {
            autoReconnect = true;
        }
        if (withConnParams || forcedAutoReconnect) {
            builder.setParameter("characterEncoding", "utf-8").setParameter("rewriteBatchedStatements", "true").setParameter("useServerPrepStmts", "false").setParameter("autoReconnect", String.valueOf(autoReconnect)).setParameter("maxReconnects", String.valueOf(maxTimes)).setParameter("initialTimeout", String.valueOf(interval));
        }
        if (timeout != null) {
            builder.setParameter("socketTimeout", String.valueOf(timeout));
        }
        builder.setParameter("useSSL", sslMode);
        return JDBC_PREFIX + builder.toString();
    }

    protected String buildUrlPrefix(boolean withDB) {
        String url = (String)this.config.get(MysqlOptions.JDBC_URL);
        if (!url.endsWith("/")) {
            url = String.format("%s/", url);
        }
        String database = withDB ? this.database() : this.connectDatabase();
        return String.format("%s%s", url, database);
    }

    protected String connectDatabase() {
        return "";
    }

    protected URIBuilder newConnectionURIBuilder(String url) throws URISyntaxException {
        return new URIBuilder(url);
    }

    private Connection connect(String url) throws SQLException {
        LOG.info("Connect to the jdbc url: '{}'", (Object)url);
        String driverName = (String)this.config.get(MysqlOptions.JDBC_DRIVER);
        String username = (String)this.config.get(MysqlOptions.JDBC_USERNAME);
        String password = (String)this.config.get(MysqlOptions.JDBC_PASSWORD);
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new BackendException("Invalid driver class '%s'", new Object[]{driverName});
        }
        return DriverManager.getConnection(url, username, password);
    }

    public class Session
    extends BackendSession.AbstractBackendSession {
        private Connection conn = null;
        private Map<String, PreparedStatement> statements = new HashMap<String, PreparedStatement>();
        private int count = 0;

        public HugeConfig config() {
            return MysqlSessions.this.config();
        }

        public void open() {
            try {
                this.doOpen();
            }
            catch (SQLException e) {
                throw new BackendException("Failed to open connection", (Throwable)e);
            }
        }

        private void tryOpen() {
            try {
                this.doOpen();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        private void doOpen() throws SQLException {
            this.opened = true;
            if (this.conn != null && !this.conn.isClosed()) {
                return;
            }
            this.conn = MysqlSessions.this.open(true);
        }

        public void close() {
            assert (this.closeable());
            if (this.conn == null) {
                return;
            }
            this.opened = false;
            this.doClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doClose() {
            SQLException exception = null;
            for (PreparedStatement statement : this.statements.values()) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    exception = e;
                }
            }
            this.statements.clear();
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                exception = e;
            }
            finally {
                this.conn = null;
            }
            if (exception != null) {
                throw new BackendException("Failed to close connection", (Throwable)exception);
            }
        }

        public boolean opened() {
            if (this.opened && this.conn == null) {
                this.tryOpen();
            }
            return this.opened && this.conn != null;
        }

        public boolean closed() {
            if (!this.opened || this.conn == null) {
                return true;
            }
            try {
                return this.conn.isClosed();
            }
            catch (SQLException ignored) {
                return true;
            }
        }

        public void clear() {
            this.count = 0;
            SQLException exception = null;
            for (PreparedStatement statement : this.statements.values()) {
                try {
                    statement.clearBatch();
                }
                catch (SQLException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                this.statements = new HashMap<String, PreparedStatement>();
            }
        }

        public void begin() throws SQLException {
            this.conn.setAutoCommit(false);
        }

        public void end() throws SQLException {
            this.conn.setAutoCommit(true);
        }

        public void endAndLog() {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.warn("Failed to set connection to auto-commit status", (Throwable)e);
            }
        }

        public Integer commit() {
            int updated = 0;
            try {
                for (PreparedStatement statement : this.statements.values()) {
                    updated += IntStream.of(statement.executeBatch()).sum();
                }
                this.conn.commit();
                this.clear();
            }
            catch (SQLException e) {
                throw new BackendException("Failed to commit", (Throwable)e);
            }
            this.endAndLog();
            return updated;
        }

        public void rollback() {
            this.clear();
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {
                throw new BackendException("Failed to rollback", (Throwable)e);
            }
            finally {
                this.endAndLog();
            }
        }

        public boolean hasChanges() {
            return this.count > 0;
        }

        public void reconnectIfNeeded() {
            if (!this.opened) {
                return;
            }
            if (this.conn == null) {
                this.tryOpen();
            }
            try {
                this.execute("SELECT 1;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public void reset() {
            if (this.conn == null) {
                return;
            }
            try {
                this.doClose();
            }
            catch (Throwable e) {
                LOG.warn("Failed to reset connection", e);
            }
        }

        public ResultSetWrapper select(String sql) throws SQLException {
            assert (this.conn.getAutoCommit());
            Statement statement = this.conn.createStatement();
            try {
                ResultSet rs = statement.executeQuery(sql);
                return new ResultSetWrapper(rs, statement);
            }
            catch (SQLException e) {
                statement.close();
                throw e;
            }
        }

        public boolean execute(String sql) throws SQLException {
            if (!this.conn.getAutoCommit()) {
                this.end();
            }
            try (Statement statement = this.conn.createStatement();){
                boolean bl = statement.execute(sql);
                return bl;
            }
        }

        public void add(PreparedStatement statement) {
            try {
                statement.addBatch();
                ++this.count;
            }
            catch (SQLException e) {
                throw new BackendException("Failed to add statement '%s' to batch", (Throwable)e, new Object[]{statement});
            }
        }

        public PreparedStatement prepareStatement(String sqlTemplate) throws SQLException {
            PreparedStatement statement = this.statements.get(sqlTemplate);
            if (statement == null) {
                statement = this.conn.prepareStatement(sqlTemplate);
                this.statements.putIfAbsent(sqlTemplate, statement);
            }
            return statement;
        }
    }
}

