/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.serializer.Serializer;
import org.apache.hugegraph.traversal.algorithm.CustomizedCrosspointsTraverser;
import org.apache.hugegraph.traversal.algorithm.FusiformSimilarityTraverser;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.SingleSourceShortestPathTraverser;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class JsonSerializer
implements Serializer {
    private static final int LBUF_SIZE = 1024;
    private static JsonSerializer INSTANCE = new JsonSerializer();

    private JsonSerializer() {
    }

    public static JsonSerializer instance() {
        return INSTANCE;
    }

    @Override
    public String writeMap(Map<?, ?> map) {
        return JsonUtil.toJson(map);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String writeList(String label, Collection<?> list) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(1024);){
            out.write(String.format("{\"%s\": ", label).getBytes("UTF-8"));
            out.write(JsonUtil.toJson(list).getBytes("UTF-8"));
            out.write("}".getBytes("UTF-8"));
            String string = out.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new HugeException("Failed to serialize %s", (Throwable)e, new Object[]{label});
        }
    }

    /*
     * Exception decompiling
     */
    private String writeIterator(String label, Iterator<?> iter, boolean paging) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String writePropertyKey(PropertyKey propertyKey) {
        return JsonUtil.toJson((Object)propertyKey);
    }

    @Override
    public String writeTaskWithSchema(SchemaElement.TaskWithSchema taskWithSchema) {
        String schema;
        String type;
        StringBuilder builder = new StringBuilder();
        long id = taskWithSchema.task() == null ? 0L : taskWithSchema.task().asLong();
        SchemaElement schemaElement = taskWithSchema.schemaElement();
        if (schemaElement instanceof PropertyKey) {
            type = "property_key";
            schema = this.writePropertyKey((PropertyKey)schemaElement);
        } else if (schemaElement instanceof IndexLabel) {
            type = "index_label";
            schema = this.writeIndexlabel((IndexLabel)schemaElement);
        } else {
            throw new HugeException("Invalid schema element '%s' in TaskWithSchema, only support [PropertyKey, IndexLabel]", new Object[]{schemaElement});
        }
        return builder.append("{\"").append(type).append("\": ").append(schema).append(", \"task_id\": ").append(id).append("}").toString();
    }

    @Override
    public String writePropertyKeys(List<PropertyKey> propertyKeys) {
        return this.writeList("propertykeys", propertyKeys);
    }

    @Override
    public String writeVertexLabel(VertexLabel vertexLabel) {
        return JsonUtil.toJson((Object)vertexLabel);
    }

    @Override
    public String writeVertexLabels(List<VertexLabel> vertexLabels) {
        return this.writeList("vertexlabels", vertexLabels);
    }

    @Override
    public String writeEdgeLabel(EdgeLabel edgeLabel) {
        return JsonUtil.toJson((Object)edgeLabel);
    }

    @Override
    public String writeEdgeLabels(List<EdgeLabel> edgeLabels) {
        return this.writeList("edgelabels", edgeLabels);
    }

    @Override
    public String writeIndexlabel(IndexLabel indexLabel) {
        return JsonUtil.toJson((Object)indexLabel);
    }

    @Override
    public String writeIndexlabels(List<IndexLabel> indexLabels) {
        return this.writeList("indexlabels", indexLabels);
    }

    @Override
    public String writeVertex(Vertex vertex) {
        return JsonUtil.toJson((Object)vertex);
    }

    @Override
    public String writeVertices(Iterator<Vertex> vertices, boolean paging) {
        return this.writeIterator("vertices", vertices, paging);
    }

    @Override
    public String writeEdge(Edge edge) {
        return JsonUtil.toJson((Object)edge);
    }

    @Override
    public String writeEdges(Iterator<Edge> edges, boolean paging) {
        return this.writeIterator("edges", edges, paging);
    }

    @Override
    public String writeIds(List<Id> ids) {
        return JsonUtil.toJson(ids);
    }

    @Override
    public String writeAuthElement(SchemaDefine.AuthElement elem) {
        return this.writeMap(elem.asMap());
    }

    @Override
    public <V extends SchemaDefine.AuthElement> String writeAuthElements(String label, List<V> elems) {
        ArrayList<Map> list = new ArrayList<Map>(elems.size());
        for (SchemaDefine.AuthElement elem : elems) {
            list.add(elem.asMap());
        }
        return this.writeList(label, list);
    }

    @Override
    public String writePaths(String name, Collection<HugeTraverser.Path> paths, boolean withCrossPoint, Iterator<Vertex> vertices) {
        ArrayList<Map> pathList = new ArrayList<Map>(paths.size());
        for (HugeTraverser.Path path : paths) {
            pathList.add(path.toMap(withCrossPoint));
        }
        ImmutableMap results = vertices == null ? ImmutableMap.of((Object)name, pathList) : ImmutableMap.of((Object)name, pathList, (Object)"vertices", vertices);
        return JsonUtil.toJson((Object)results);
    }

    @Override
    public String writeCrosspoints(CustomizedCrosspointsTraverser.CrosspointsPaths paths, Iterator<Vertex> iterator, boolean withPath) {
        Object pathList;
        if (withPath) {
            pathList = new ArrayList();
            for (HugeTraverser.Path path : paths.paths()) {
                pathList.add(path.toMap(false));
            }
        } else {
            pathList = ImmutableList.of();
        }
        ImmutableMap results = ImmutableMap.of((Object)"crosspoints", (Object)paths.crosspoints(), (Object)"paths", (Object)pathList, (Object)"vertices", iterator);
        return JsonUtil.toJson((Object)results);
    }

    @Override
    public String writeSimilars(FusiformSimilarityTraverser.SimilarsMap similars, Iterator<Vertex> vertices) {
        return JsonUtil.toJson((Object)ImmutableMap.of((Object)"similars", (Object)similars.toMap(), (Object)"vertices", vertices));
    }

    @Override
    public String writeWeightedPath(SingleSourceShortestPathTraverser.NodeWithWeight path, Iterator<Vertex> vertices) {
        Object pathMap = path == null ? ImmutableMap.of() : path.toMap();
        return JsonUtil.toJson((Object)ImmutableMap.of((Object)"path", (Object)pathMap, (Object)"vertices", vertices));
    }

    @Override
    public String writeWeightedPaths(SingleSourceShortestPathTraverser.WeightedPaths paths, Iterator<Vertex> vertices) {
        Object pathMap = paths == null ? ImmutableMap.of() : paths.toMap();
        return JsonUtil.toJson((Object)ImmutableMap.of((Object)"paths", (Object)pathMap, (Object)"vertices", vertices));
    }

    @Override
    public String writeNodesWithPath(String name, List<Id> nodes, long size, Collection<HugeTraverser.Path> paths, Iterator<Vertex> vertices) {
        ArrayList<Map> pathList = new ArrayList<Map>();
        for (HugeTraverser.Path path : paths) {
            pathList.add(path.toMap(false));
        }
        ImmutableMap results = ImmutableMap.of((Object)name, nodes, (Object)"size", (Object)size, (Object)"paths", pathList, (Object)"vertices", vertices);
        return JsonUtil.toJson((Object)results);
    }
}

