/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Iterator;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.SingleSourceShortestPathTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/singlesourceshortestpath")
@Singleton
@Tag(name="SingleSourceShortestPathAPI")
public class SingleSourceShortestPathAPI
extends API {
    private static final Logger LOG = Log.logger(SingleSourceShortestPathAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="weight") String weight, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="skip_degree") @DefaultValue(value="0") long skipDegree, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="with_vertex") boolean withVertex) {
        LOG.debug("Graph [{}] get single source shortest path from '{}' with direction {}, edge label {}, weight property {}, max degree '{}', limit '{}' and with vertex '{}'", new Object[]{graph, source, direction, edgeLabel, weight, maxDegree, withVertex});
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = SingleSourceShortestPathAPI.graph(manager, graph);
        SingleSourceShortestPathTraverser traverser = new SingleSourceShortestPathTraverser(g);
        SingleSourceShortestPathTraverser.WeightedPaths paths = traverser.singleSourceShortestPaths(sourceId, dir, edgeLabel, weight, maxDegree, skipDegree, capacity, (long)limit);
        Iterator iterator = QueryResults.emptyIterator();
        assert (paths != null);
        if (!paths.isEmpty() && withVertex) {
            iterator = g.vertices(paths.vertices().toArray());
        }
        return manager.serializer((Graph)g).writeWeightedPaths(paths, iterator);
    }
}

