/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.KoutTraverser;
import org.apache.hugegraph.traversal.algorithm.records.KoutRecords;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/kout")
@Singleton
@Tag(name="KoutAPI")
public class KoutAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(KoutAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_depth") int depth, @QueryParam(value="nearest") @DefaultValue(value="true") boolean nearest, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity, @QueryParam(value="limit") @DefaultValue(value="10000000") int limit) {
        Set ids;
        LOG.debug("Graph [{}] get k-out from '{}' with direction '{}', edge label '{}', max depth '{}', nearest '{}', max degree '{}', capacity '{}' and limit '{}'", new Object[]{graph, source, direction, edgeLabel, depth, nearest, maxDegree, capacity, limit});
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = KoutAPI.graph(manager, graph);
        try (KoutTraverser traverser = new KoutTraverser(g);){
            ids = traverser.kout(sourceId, dir, edgeLabel, depth, nearest, maxDegree, capacity, (long)limit);
        }
        return manager.serializer((Graph)g).writeList("vertices", ids);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, Request request) {
        KoutRecords results;
        E.checkArgumentNotNull((Object)request, (String)"The request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.source, (String)"The source of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.step != null ? 1 : 0) != 0, (String)"The steps of request can't be null", (Object[])new Object[0]);
        if (request.countOnly) {
            E.checkArgument((!request.withVertex && !request.withPath ? 1 : 0) != 0, (String)"Can't return vertex or path when count only", (Object[])new Object[0]);
        }
        LOG.debug("Graph [{}] get customized kout from source vertex '{}', with step '{}', max_depth '{}', nearest '{}', count_only '{}', capacity '{}', limit '{}', with_vertex '{}' and with_path '{}'", new Object[]{graph, request.source, request.step, request.maxDepth, request.nearest, request.countOnly, request.capacity, request.limit, request.withVertex, request.withPath});
        HugeGraph g = KoutAPI.graph(manager, graph);
        Id sourceId = HugeVertex.getIdValue((Object)request.source);
        EdgeStep step = KoutAPI.step(g, request.step);
        try (KoutTraverser traverser = new KoutTraverser(g);){
            results = traverser.customizedKout(sourceId, step, request.maxDepth, request.nearest, request.capacity, (long)request.limit);
        }
        long size = results.size();
        if ((long)request.limit != Long.MAX_VALUE && size > (long)request.limit) {
            size = request.limit;
        }
        ImmutableList neighbors = request.countOnly ? ImmutableList.of() : results.ids((long)request.limit);
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        if (request.withPath) {
            paths.addAll(results.paths((long)request.limit));
        }
        Iterator iter = QueryResults.emptyIterator();
        if (request.withVertex && !request.countOnly) {
            HashSet ids = new HashSet(neighbors);
            if (request.withPath) {
                for (HugeTraverser.Path p : paths) {
                    ids.addAll(p.vertices());
                }
            }
            if (!ids.isEmpty()) {
                iter = g.vertices(ids.toArray());
            }
        }
        return manager.serializer((Graph)g).writeNodesWithPath("kout", (List<Id>)neighbors, size, (Collection<HugeTraverser.Path>)paths, iter);
    }

    private static class Request {
        @JsonProperty(value="source")
        public Object source;
        @JsonProperty(value="step")
        public TraverserAPI.Step step;
        @JsonProperty(value="max_depth")
        public int maxDepth;
        @JsonProperty(value="nearest")
        public boolean nearest = true;
        @JsonProperty(value="count_only")
        public boolean countOnly = false;
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10000000");
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;
        @JsonProperty(value="with_path")
        public boolean withPath = false;

        private Request() {
        }

        public String toString() {
            return String.format("KoutRequest{source=%s,step=%s,maxDepth=%snearest=%s,countOnly=%s,capacity=%s,limit=%s,withVertex=%s,withPath=%s}", this.source, this.step, this.maxDepth, this.nearest, this.countOnly, this.capacity, this.limit, this.withVertex, this.withPath);
        }
    }
}

