/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.schema;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.Userdata;
import org.apache.hugegraph.type.define.AggregateType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.WriteType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/schema/propertykeys")
@Singleton
@Tag(name="PropertyKeyAPI")
public class PropertyKeyAPI
extends API {
    private static final Logger LOG = Log.logger(PropertyKeyAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=202)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=property_key_write"})
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, JsonPropertyKey jsonPropertyKey) {
        LOG.debug("Graph [{}] create property key: {}", (Object)graph, (Object)jsonPropertyKey);
        PropertyKeyAPI.checkCreatingBody(jsonPropertyKey);
        HugeGraph g = PropertyKeyAPI.graph(manager, graph);
        PropertyKey.Builder builder = jsonPropertyKey.convert2Builder(g);
        SchemaElement.TaskWithSchema pk = builder.createWithTask();
        return manager.serializer((Graph)g).writeTaskWithSchema(pk);
    }

    @PUT
    @Timed
    @StatusFilter.Status(value=202)
    @Path(value="{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=property_key_write"})
    public String update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name, @QueryParam(value="action") String action, JsonPropertyKey jsonPropertyKey) {
        LOG.debug("Graph [{}] {} property key: {}", new Object[]{graph, action, jsonPropertyKey});
        PropertyKeyAPI.checkUpdatingBody(jsonPropertyKey);
        E.checkArgument((boolean)name.equals(jsonPropertyKey.name), (String)"The name in url(%s) and body(%s) are different", (Object[])new Object[]{name, jsonPropertyKey.name});
        HugeGraph g = PropertyKeyAPI.graph(manager, graph);
        if ("clear".equals(action)) {
            PropertyKey propertyKey = g.propertyKey(name);
            E.checkArgument((boolean)propertyKey.olap(), (String)"Only olap property key can do action clear, but got '%s'", (Object[])new Object[]{propertyKey});
            Id id = g.clearPropertyKey(propertyKey);
            SchemaElement.TaskWithSchema pk = new SchemaElement.TaskWithSchema((SchemaElement)propertyKey, id);
            return manager.serializer((Graph)g).writeTaskWithSchema(pk);
        }
        boolean append = PropertyKeyAPI.checkAndParseAction(action);
        PropertyKey.Builder builder = jsonPropertyKey.convert2Builder(g);
        PropertyKey propertyKey = append ? (PropertyKey)builder.append() : (PropertyKey)builder.eliminate();
        SchemaElement.TaskWithSchema pk = new SchemaElement.TaskWithSchema((SchemaElement)propertyKey, IdGenerator.ZERO);
        return manager.serializer((Graph)g).writeTaskWithSchema(pk);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=property_key_read"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="names") List<String> names) {
        ArrayList<PropertyKey> propKeys;
        boolean listAll = CollectionUtils.isEmpty(names);
        if (listAll) {
            LOG.debug("Graph [{}] list property keys", (Object)graph);
        } else {
            LOG.debug("Graph [{}] get property keys by names {}", (Object)graph, names);
        }
        HugeGraph g = PropertyKeyAPI.graph(manager, graph);
        if (listAll) {
            propKeys = g.schema().getPropertyKeys();
        } else {
            propKeys = new ArrayList<PropertyKey>(names.size());
            for (String name : names) {
                propKeys.add(g.schema().getPropertyKey(name));
            }
        }
        return manager.serializer((Graph)g).writePropertyKeys(propKeys);
    }

    @GET
    @Timed
    @Path(value="{name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=property_key_read"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] get property key by name '{}'", (Object)graph, (Object)name);
        HugeGraph g = PropertyKeyAPI.graph(manager, graph);
        PropertyKey propertyKey = g.schema().getPropertyKey(name);
        return manager.serializer((Graph)g).writePropertyKey(propertyKey);
    }

    @DELETE
    @Timed
    @StatusFilter.Status(value=202)
    @Path(value="{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=property_key_delete"})
    public Map<String, Id> delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] remove property key by name '{}'", (Object)graph, (Object)name);
        HugeGraph g = PropertyKeyAPI.graph(manager, graph);
        g.schema().getPropertyKey(name);
        return ImmutableMap.of((Object)"task_id", (Object)g.schema().propertyKey(name).remove());
    }

    @JsonIgnoreProperties(value={"status"})
    private static class JsonPropertyKey
    implements Checkable {
        @JsonProperty(value="id")
        public long id;
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="cardinality")
        public Cardinality cardinality;
        @JsonProperty(value="data_type")
        public DataType dataType;
        @JsonProperty(value="aggregate_type")
        public AggregateType aggregateType;
        @JsonProperty(value="write_type")
        public WriteType writeType;
        @JsonProperty(value="properties")
        public String[] properties;
        @JsonProperty(value="user_data")
        public Userdata userdata;
        @JsonProperty(value="check_exist")
        public Boolean checkExist;

        private JsonPropertyKey() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.name, (String)"The name of property key can't be null", (Object[])new Object[0]);
            E.checkArgument((this.properties == null || this.properties.length == 0 ? 1 : 0) != 0, (String)"Not allowed to pass properties when creating property key since it doesn't support meta properties currently", (Object[])new Object[0]);
        }

        private PropertyKey.Builder convert2Builder(HugeGraph g) {
            PropertyKey.Builder builder = g.schema().propertyKey(this.name);
            if (this.id != 0L) {
                E.checkArgument((this.id > 0L ? 1 : 0) != 0, (String)"Only positive number can be assign as property key id", (Object[])new Object[0]);
                E.checkArgument((g.mode() == GraphMode.RESTORING ? 1 : 0) != 0, (String)"Only accept property key id when graph in RESTORING mode, but '%s' is in mode '%s'", (Object[])new Object[]{g, g.mode()});
                builder.id(this.id);
            }
            if (this.cardinality != null) {
                builder.cardinality(this.cardinality);
            }
            if (this.dataType != null) {
                builder.dataType(this.dataType);
            }
            if (this.aggregateType != null) {
                builder.aggregateType(this.aggregateType);
            }
            if (this.writeType != null) {
                builder.writeType(this.writeType);
            }
            if (this.userdata != null) {
                builder.userdata((Map)this.userdata);
            }
            if (this.checkExist != null) {
                builder.checkExist(this.checkExist.booleanValue());
            }
            return builder;
        }

        public String toString() {
            return String.format("JsonPropertyKey{name=%s, cardinality=%s, dataType=%s, aggregateType=%s, writeType=%s, properties=%s}", this.name, this.cardinality, this.dataType, this.aggregateType, this.writeType, this.properties);
        }
    }
}

