/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

interface LocalCache<K, V>
extends ConcurrentMap<K, V> {
    public boolean isRecordingStats();

    @Nonnull
    public StatsCounter statsCounter();

    public boolean hasRemovalListener();

    @Nullable
    public RemovalListener<K, V> removalListener();

    public void notifyRemoval(@Nullable K var1, @Nullable V var2, RemovalCause var3);

    @Nonnull
    public Executor executor();

    public boolean hasWriteTime();

    @Nonnull
    public Ticker expirationTicker();

    @Nonnull
    public Ticker statsTicker();

    @Nonnegative
    public long estimatedSize();

    @Nullable
    public V getIfPresent(@Nonnull Object var1, boolean var2);

    @Nullable
    public V getIfPresentQuietly(@Nonnull Object var1, @Nonnull long[] var2);

    @Nonnull
    public Map<K, V> getAllPresent(@Nonnull Iterable<?> var1);

    @Nullable
    public V put(@Nonnull K var1, @Nonnull V var2, boolean var3);

    @Override
    default public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, false, true);
    }

    public V compute(K var1, BiFunction<? super K, ? super V, ? extends V> var2, boolean var3, boolean var4);

    @Override
    default public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction, true, true);
    }

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2, boolean var3, boolean var4);

    default public void invalidateAll(Iterable<?> keys) {
        for (Object key : keys) {
            this.remove(key);
        }
    }

    public void cleanUp();

    default public Function<? super K, ? extends V> statsAware(Function<? super K, ? extends V> mappingFunction, boolean recordLoad) {
        if (!this.isRecordingStats()) {
            return mappingFunction;
        }
        return key -> {
            Object value;
            this.statsCounter().recordMisses(1);
            long startTime = this.statsTicker().read();
            try {
                value = mappingFunction.apply((K)key);
            }
            catch (Error | RuntimeException e) {
                this.statsCounter().recordLoadFailure(this.statsTicker().read() - startTime);
                throw e;
            }
            long loadTime = this.statsTicker().read() - startTime;
            if (recordLoad) {
                if (value == null) {
                    this.statsCounter().recordLoadFailure(loadTime);
                } else {
                    this.statsCounter().recordLoadSuccess(loadTime);
                }
            }
            return value;
        };
    }

    default public <T, U, R> BiFunction<? super T, ? super U, ? extends R> statsAware(BiFunction<? super T, ? super U, ? extends R> remappingFunction) {
        return this.statsAware(remappingFunction, true, true);
    }

    default public <T, U, R> BiFunction<? super T, ? super U, ? extends R> statsAware(BiFunction<? super T, ? super U, ? extends R> remappingFunction, boolean recordMiss, boolean recordLoad) {
        if (!this.isRecordingStats()) {
            return remappingFunction;
        }
        return (t, u) -> {
            Object result;
            if (u == null && recordMiss) {
                this.statsCounter().recordMisses(1);
            }
            long startTime = this.statsTicker().read();
            try {
                result = remappingFunction.apply(t, u);
            }
            catch (Error | RuntimeException e) {
                this.statsCounter().recordLoadFailure(this.statsTicker().read() - startTime);
                throw e;
            }
            long loadTime = this.statsTicker().read() - startTime;
            if (recordLoad) {
                if (result == null) {
                    this.statsCounter().recordLoadFailure(loadTime);
                } else {
                    this.statsCounter().recordLoadSuccess(loadTime);
                }
            }
            return result;
        };
    }
}

