/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.FeatureTemplate;
import com.hankcs.hanlp.model.crf.LogLinearModel;
import com.hankcs.hanlp.model.crf.crfpp.Encoder;
import com.hankcs.hanlp.model.crf.crfpp.crf_learn;
import com.hankcs.hanlp.model.perceptron.instance.InstanceHandler;
import com.hankcs.hanlp.model.perceptron.utility.IOUtility;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public abstract class CRFTagger {
    protected LogLinearModel model;

    public CRFTagger() {
    }

    public CRFTagger(String modelPath) throws IOException {
        if (modelPath == null) {
            return;
        }
        this.model = new LogLinearModel(modelPath);
    }

    public void train(String templFile, String trainFile, String modelFile, int maxitr, int freq, double eta, double C, int threadNum, int shrinkingSize, Encoder.Algorithm algorithm) throws IOException {
        Encoder encoder = new Encoder();
        if (!encoder.learn(templFile, trainFile, modelFile, true, maxitr, freq, eta, C, threadNum, shrinkingSize, algorithm)) {
            throw new IOException("fail to learn model");
        }
        this.convert(modelFile);
    }

    private void convert(String modelFile) throws IOException {
        this.model = new LogLinearModel(modelFile + ".txt", modelFile);
    }

    public void train(String trainCorpusPath, String modelPath) throws IOException {
        crf_learn.Option option = new crf_learn.Option();
        this.train(trainCorpusPath, modelPath, option.maxiter, option.freq, option.eta, option.cost, option.thread, option.shrinking_size, Encoder.Algorithm.fromString(option.algorithm));
    }

    public void train(String trainFile, String modelFile, int maxitr, int freq, double eta, double C, int threadNum, int shrinkingSize, Encoder.Algorithm algorithm) throws IOException {
        String templFile = null;
        File tmpTemplate = File.createTempFile("crfpp-template-" + new Date().getTime(), ".txt");
        tmpTemplate.deleteOnExit();
        templFile = tmpTemplate.getAbsolutePath();
        String template = this.getDefaultFeatureTemplate();
        IOUtil.saveTxt(templFile, template);
        File tmpTrain = File.createTempFile("crfpp-train-" + new Date().getTime(), ".txt");
        tmpTrain.deleteOnExit();
        this.convertCorpus(trainFile, tmpTrain.getAbsolutePath());
        trainFile = tmpTrain.getAbsolutePath();
        System.out.printf("Java\u6548\u7387\u4f4e\uff0c\u5efa\u8bae\u5b89\u88c5CRF++\uff0c\u6267\u884c\u4e0b\u5217\u7b49\u4ef7\u8bad\u7ec3\u547d\u4ee4\uff08\u4e0d\u8981\u7ec8\u6b62\u672c\u8fdb\u7a0b\uff0c\u5426\u5219\u4e34\u65f6\u8bed\u6599\u5e93\u548c\u7279\u5f81\u6a21\u677f\u5c06\u88ab\u6e05\u9664\uff09\uff1a\ncrf_learn -m %d -f %d -e %f -c %f -p %d -H %d -a %s -t %s %s %s\n", maxitr, freq, eta, C, threadNum, shrinkingSize, algorithm.toString().replace('_', '-'), templFile, trainFile, modelFile);
        Encoder encoder = new Encoder();
        if (!encoder.learn(templFile, trainFile, modelFile, true, maxitr, freq, eta, C, threadNum, shrinkingSize, algorithm)) {
            throw new IOException("fail to learn model");
        }
        this.convert(modelFile);
    }

    protected abstract void convertCorpus(Sentence var1, BufferedWriter var2) throws IOException;

    protected abstract String getDefaultFeatureTemplate();

    public void convertCorpus(String pkuPath, String tsvPath) throws IOException {
        final BufferedWriter bw = IOUtil.newBufferedWriter(tsvPath);
        IOUtility.loadInstance(pkuPath, new InstanceHandler(){

            @Override
            public boolean process(Sentence sentence) {
                Utility.normalize(sentence);
                try {
                    CRFTagger.this.convertCorpus(sentence, bw);
                    bw.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }
        });
        bw.close();
    }

    public void dumpTemplate(String templatePath) throws IOException {
        BufferedWriter bw = IOUtil.newBufferedWriter(templatePath);
        String template = this.getTemplate();
        bw.write(template);
        bw.close();
    }

    public String getTemplate() {
        String template = this.getDefaultFeatureTemplate();
        if (this.model != null && this.model.getFeatureTemplateArray() != null) {
            StringBuilder sbTemplate = new StringBuilder();
            for (FeatureTemplate featureTemplate : this.model.getFeatureTemplateArray()) {
                sbTemplate.append(featureTemplate.getTemplate()).append('\n');
            }
        }
        return template;
    }
}

