/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util.logging;

import org.nlpcn.commons.lang.util.logging.Log;

public class NoLoggingImpl
implements Log {
    private String loggerName;

    public NoLoggingImpl(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void error(String s, Throwable e) {
        this.error(s);
        if (e != null) {
            e.printStackTrace();
        }
    }

    @Override
    public void error(String s) {
        if (s != null) {
            System.err.println(this.loggerName + " : " + s);
        }
    }

    @Override
    public void debug(String s) {
        System.out.println(s);
    }

    @Override
    public void debug(String s, Throwable e) {
        System.out.println(s + e != null ? e.getMessage() : "");
    }

    @Override
    public void warn(String s) {
        System.out.println(s);
    }

    @Override
    public void warn(String s, Throwable e) {
        System.out.println(s + "," + e != null ? e.getMessage() : "");
    }

    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public void info(String s) {
        System.out.println(s);
    }

    @Override
    public boolean isWarnEnabled() {
        return false;
    }
}

