/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.struct;

import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ScheduledService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledService.class);
    public static final int MODE_FIXEDRATE = 0;
    public static final int MODE_FIXEDDELAY = 1;
    private volatile ScheduledExecutorService scheduledExecutorService;
    private String threadName;
    private final Runnable runnable;
    private final long initialDelay;
    private final long period;
    private final TimeUnit unit;
    private final int mode;
    private volatile ScheduledFuture future;
    private volatile boolean started;
    protected static final Map<ScheduledService, Long> SCHEDULED_SERVICE_MAP = new ConcurrentHashMap<ScheduledService, Long>();
    protected static volatile boolean resetting;

    public ScheduledService(String threadName, int mode, Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        this.threadName = threadName;
        this.runnable = runnable;
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.mode = mode;
    }

    public synchronized ScheduledService start() {
        if (this.started) {
            return this;
        }
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory(this.threadName, true));
        }
        ScheduledFuture<?> future = null;
        switch (this.mode) {
            case 0: {
                future = this.scheduledExecutorService.scheduleAtFixedRate(this.runnable, this.initialDelay, this.period, this.unit);
                break;
            }
            case 1: {
                future = this.scheduledExecutorService.scheduleWithFixedDelay(this.runnable, this.initialDelay, this.period, this.unit);
                break;
            }
        }
        if (future != null) {
            this.future = future;
            SCHEDULED_SERVICE_MAP.put(this, System.currentTimeMillis());
            this.started = true;
        } else {
            this.started = false;
        }
        return this;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        try {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdownNow();
                this.scheduledExecutorService = null;
            }
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), t);
        }
        finally {
            SCHEDULED_SERVICE_MAP.remove(this);
            this.started = false;
        }
    }

    public void shutdown() {
        this.stop();
    }

    public boolean isStarted() {
        return this.started;
    }

    public static synchronized void reset() {
        resetting = true;
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Start resetting all {} schedule executor service.", SCHEDULED_SERVICE_MAP.size());
        }
        for (Map.Entry<ScheduledService, Long> entry : SCHEDULED_SERVICE_MAP.entrySet()) {
            try {
                ScheduledService service = entry.getKey();
                if (!service.isStarted()) continue;
                service.stop();
                service.start();
            }
            catch (Exception e) {
                LOGGER.error(LogCodes.getLog("019990019"), e);
            }
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Already reset all {} schedule executor service.", SCHEDULED_SERVICE_MAP.size());
        }
        resetting = false;
    }

    public static boolean isResetting() {
        return resetting;
    }
}

