/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.triple;

import com.alipay.sofa.rpc.bootstrap.DefaultProviderBootstrap;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.proxy.ProxyFactory;
import com.alipay.sofa.rpc.server.ProviderProxyInvoker;
import java.lang.reflect.Method;

@Extension(value="tri")
public class TripleProviderBootstrap<T>
extends DefaultProviderBootstrap<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripleProviderBootstrap.class);

    protected TripleProviderBootstrap(ProviderConfig<T> providerConfig) {
        super(providerConfig);
    }

    @Override
    protected void preProcessProviderTarget(ProviderConfig providerConfig, ProviderProxyInvoker providerProxyInvoker) {
        Class<?> implClass = providerConfig.getRef().getClass();
        try {
            Method method = implClass.getMethod("setProxiedImpl", providerConfig.getProxyClass());
            Object obj = ProxyFactory.buildProxy(providerConfig.getProxy(), providerConfig.getProxyClass(), providerProxyInvoker);
            method.invoke(providerConfig.getRef(), obj);
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("{} don't hava method setProxiedImpl, will treated as origin provider service instead of grpc service.", implClass);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set sofa proxied service impl to stub, please make sure your stub was generated by the sofa-protoc-compiler.", e);
        }
    }

    @Override
    public void export() {
        Class<?> enclosingClass = this.getProviderConfig().getProxyClass().getEnclosingClass();
        Method sofaStub = null;
        String serviceName = this.getProviderConfig().getInterfaceId();
        try {
            sofaStub = enclosingClass.getDeclaredMethod("getServiceName", new Class[0]);
            serviceName = (String)sofaStub.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getProviderConfig().setVirtualInterfaceId(serviceName);
        super.export();
    }
}

