/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.task;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.loader.builder.Record;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.metrics.LoadSummary;
import org.apache.hugegraph.loader.task.BatchInsertTask;
import org.apache.hugegraph.loader.task.SingleInsertTask;
import org.apache.hugegraph.util.ExecutorUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class TaskManager {
    private static final Logger LOG = Log.logger(TaskManager.class);
    private final LoadContext context;
    private final LoadOptions options;
    private final Semaphore batchSemaphore;
    private final Semaphore singleSemaphore;
    private final ExecutorService batchService;
    private final ExecutorService singleService;

    public TaskManager(LoadContext context) {
        this.context = context;
        this.options = context.options();
        this.batchSemaphore = new Semaphore(this.batchSemaphoreNum());
        this.singleSemaphore = new Semaphore(this.singleSemaphoreNum());
        this.batchService = ExecutorUtil.newFixedThreadPool((int)this.options.batchInsertThreads, (String)"batch-worker-%d");
        this.singleService = ExecutorUtil.newFixedThreadPool((int)this.options.singleInsertThreads, (String)"single-worker-%d");
    }

    private int batchSemaphoreNum() {
        return 1 + this.options.batchInsertThreads;
    }

    private int singleSemaphoreNum() {
        return 2 * this.options.singleInsertThreads;
    }

    public void waitFinished() {
        this.waitFinished("insert tasks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFinished(String tasksName) {
        LOG.info("Waiting for the {} to finish", (Object)tasksName);
        try {
            this.batchSemaphore.acquire(this.batchSemaphoreNum());
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting batch-mode tasks");
        }
        finally {
            this.batchSemaphore.release(this.batchSemaphoreNum());
        }
        try {
            this.singleSemaphore.acquire(this.singleSemaphoreNum());
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting single-mode tasks");
        }
        finally {
            this.singleSemaphore.release(this.singleSemaphoreNum());
        }
        LOG.info("All the {} finished", (Object)tasksName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        long timeout = this.options.shutdownTimeout;
        try {
            this.batchService.shutdown();
            this.batchService.awaitTermination(timeout, TimeUnit.SECONDS);
            LOG.info("The batch-mode tasks service executor shutdown");
        }
        catch (InterruptedException e) {
            LOG.error("The batch-mode tasks are interrupted");
        }
        finally {
            if (!this.batchService.isTerminated()) {
                LOG.error("The unfinished batch-mode tasks will be cancelled");
            }
            this.batchService.shutdownNow();
        }
        try {
            this.singleService.shutdown();
            this.singleService.awaitTermination(timeout, TimeUnit.SECONDS);
            LOG.info("The single-mode tasks service executor shutdown");
        }
        catch (InterruptedException e) {
            LOG.error("The single-mode tasks are interrupted");
        }
        finally {
            if (!this.singleService.isTerminated()) {
                LOG.error("The unfinished single-mode tasks will be cancelled");
            }
            this.singleService.shutdownNow();
        }
    }

    public void submitBatch(InputStruct struct, ElementMapping mapping, List<Record> batch) {
        long start = System.currentTimeMillis();
        try {
            this.batchSemaphore.acquire();
        }
        catch (InterruptedException e2) {
            throw new LoadException("Interrupted while waiting to submit %s batch in batch mode", (Throwable)e2, new Object[]{mapping.type()});
        }
        LoadSummary summary = this.context.summary();
        summary.metrics(struct).plusFlighting(batch.size());
        BatchInsertTask task = new BatchInsertTask(this.context, struct, mapping, batch);
        CompletableFuture.runAsync(task, this.batchService).whenComplete((r, e) -> {
            if (e != null) {
                LOG.warn("Batch insert {} error, try single insert", (Object)mapping.type(), e);
                this.submitInSingle(struct, mapping, batch);
            } else {
                summary.metrics(struct).minusFlighting(batch.size());
            }
            this.batchSemaphore.release();
            long end = System.currentTimeMillis();
            this.context.summary().addTimeRange(mapping.type(), start, end);
        });
    }

    private void submitInSingle(InputStruct struct, ElementMapping mapping, List<Record> batch) {
        long start = System.currentTimeMillis();
        try {
            this.singleSemaphore.acquire();
        }
        catch (InterruptedException e2) {
            throw new LoadException("Interrupted while waiting to submit %s batch in single mode", (Throwable)e2, new Object[]{mapping.type()});
        }
        LoadSummary summary = this.context.summary();
        SingleInsertTask task = new SingleInsertTask(this.context, struct, mapping, batch);
        CompletableFuture.runAsync(task, this.singleService).whenComplete((r, e) -> {
            summary.metrics(struct).minusFlighting(batch.size());
            this.singleSemaphore.release();
            long end = System.currentTimeMillis();
            this.context.summary().addTimeRange(mapping.type(), start, end);
        });
    }
}

