/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.network.IOMode;
import org.apache.hugegraph.computer.core.network.MessageHandler;
import org.apache.hugegraph.computer.core.network.TransportConf;
import org.apache.hugegraph.computer.core.network.TransportServer;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.network.netty.BufAllocatorFactory;
import org.apache.hugegraph.computer.core.network.netty.NettyEventLoopUtil;
import org.apache.hugegraph.computer.core.network.netty.NettyProtocol;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class NettyTransportServer
implements TransportServer,
Closeable {
    private static final Logger LOG = Log.logger(NettyTransportServer.class);
    private static final String BOSS_THREAD_GROUP_NAME = "transport-netty-server-boss";
    private static final String WORKER_THREAD_GROUP_NAME = "transport-netty-server-worker";
    private static final int BOSS_THREADS = 1;
    private final ByteBufAllocator bufAllocator;
    private TransportConf conf;
    private ServerBootstrap bootstrap;
    private ChannelFuture bindFuture;
    private InetSocketAddress bindAddress;

    public NettyTransportServer() {
        this(BufAllocatorFactory.createBufAllocator());
    }

    public NettyTransportServer(ByteBufAllocator bufAllocator) {
        this.bufAllocator = bufAllocator;
    }

    @Override
    public synchronized int listen(Config config, MessageHandler serverHandler) {
        E.checkArgument((this.bindFuture == null ? 1 : 0) != 0, (String)"The TransportServer has already been listened", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)serverHandler, (String)"The serverHandler param can't be null", (Object[])new Object[0]);
        long start = System.currentTimeMillis();
        this.init(config);
        NettyProtocol protocol = new NettyProtocol(this.conf);
        ServerChannelInitializer initializer = new ServerChannelInitializer(protocol, serverHandler);
        this.bootstrap.childHandler((ChannelHandler)initializer);
        this.bindFuture = this.bootstrap.bind().syncUninterruptibly();
        this.bindAddress = (InetSocketAddress)this.bindFuture.channel().localAddress();
        long duration = System.currentTimeMillis() - start;
        LOG.info("The TransportServer started on address {}, took {} ms", (Object)TransportUtil.formatAddress(this.bindAddress), (Object)duration);
        return this.bindAddress.getPort();
    }

    private void init(Config config) {
        this.conf = TransportConf.wrapConfig(config);
        this.bootstrap = new ServerBootstrap();
        IOMode ioMode = this.conf.ioMode();
        EventLoopGroup bossGroup = NettyEventLoopUtil.createEventLoop(ioMode, 1, BOSS_THREAD_GROUP_NAME);
        EventLoopGroup workerGroup = NettyEventLoopUtil.createEventLoop(ioMode, this.conf.serverThreads(), WORKER_THREAD_GROUP_NAME);
        this.bootstrap.group(bossGroup, workerGroup);
        this.bootstrap.channel(NettyEventLoopUtil.serverChannelClass(ioMode));
        this.bootstrap.localAddress(this.conf.serverAddress(), this.conf.serverPort());
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)this.bufAllocator);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)this.bufAllocator);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.conf.tcpKeepAlive());
        boolean enableLt = this.conf.epollLevelTriggered();
        if (this.conf.recvBufferFileMode()) {
            enableLt = true;
        }
        NettyEventLoopUtil.enableTriggeredMode(ioMode, enableLt, this.bootstrap);
        if (this.conf.maxSynBacklog() > 0) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.conf.maxSynBacklog());
        }
        if (this.conf.sizeReceiveBuffer() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.conf.sizeReceiveBuffer());
        }
        if (this.conf.sizeSendBuffer() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.conf.sizeSendBuffer());
        }
    }

    public TransportConf conf() {
        return this.conf;
    }

    @Override
    public int port() {
        return this.bindAddress().getPort();
    }

    @Override
    public String ip() {
        InetAddress address = this.bindAddress().getAddress();
        return address == null ? null : address.getHostAddress();
    }

    @Override
    public InetSocketAddress bindAddress() {
        E.checkArgumentNotNull((Object)this.bindAddress, (String)"The TransportServer has not been initialized", (Object[])new Object[0]);
        return this.bindAddress;
    }

    @Override
    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new ComputerException("Failed to shutdown server", (Throwable)e);
        }
    }

    @Override
    public boolean bound() {
        return this.bindFuture != null && this.bindFuture.channel() != null && this.bindFuture.channel().isActive();
    }

    @Override
    public void close() throws IOException {
        if (this.bindFuture != null) {
            long timeout = this.conf.closeTimeout();
            this.bindFuture.channel().close().awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
            this.bindFuture = null;
        }
        if (this.bootstrap != null && this.bootstrap.config().group() != null) {
            this.bootstrap.config().group().shutdownGracefully();
        }
        if (this.bootstrap != null && this.bootstrap.config().childGroup() != null) {
            this.bootstrap.config().childGroup().shutdownGracefully();
        }
        this.bootstrap = null;
    }

    private static class ServerChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final MessageHandler handler;
        private final NettyProtocol protocol;

        public ServerChannelInitializer(NettyProtocol protocol, MessageHandler handler) {
            this.handler = handler;
            this.protocol = protocol;
        }

        public void initChannel(SocketChannel channel) {
            this.protocol.initializeServerPipeline((Channel)channel, this.handler);
        }
    }
}

